package com.elitesland.scp.application.facade.vo.save.order;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
@ApiModel(value = "订货单评价参数")
public class ScpDemandOrderReplySaveVO implements Serializable {
    private static final long serialVersionUID = 2320302359745458378L;

    @ApiModelProperty("ID")
    private Long id;

    @ApiModelProperty("订货单ID")
    private Long orderId;

    @ApiModelProperty(value = "订单分数")
    private Integer orderScore;

    @ApiModelProperty(value = "物流分数")
    private Integer expressScore;

    @ApiModelProperty(value = "评论内容")
    private String comment;

    @ApiModelProperty(value = "评论图片")
    private List<String> picList;

    @JsonIgnore
    private String pics;

}
