package com.elitesland.scp.application.service.boh.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.mq.MessageQueueTemplate;
import com.elitescloud.boot.provider.IdFactory;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.fin.dto.account.AccountAmtFlowRpcVO;
import com.elitesland.fin.dto.account.AccountFlowAppRpcVO;
import com.elitesland.fin.dto.account.ScpDemandOrderTitlePageRespRpcVO;
import com.elitesland.fin.dto.account.StoreReceivePageRpcVO;
import com.elitesland.fin.param.account.AccountAppRpcParam;
import com.elitesland.fin.service.account.AccountRpcService;
import com.elitesland.inv.dto.boh.StoreOrderDRpcDTO;
import com.elitesland.inv.dto.boh.StoreOrderRpcDTO;
import com.elitesland.inv.dto.boh.StoreRtnApplyResult;
import com.elitesland.inv.dto.invTrn.StoreCanRtnQtyRpcDTO;
import com.elitesland.inv.dto.invTrn.StoreReceiveRpcDTO;
import com.elitesland.inv.dto.invTrn.StoreRtnRpcDTO;
import com.elitesland.inv.dto.invwh.InvWhRpcDTO;
import com.elitesland.inv.dto.invwh.InvWhRpcDtoParam;
import com.elitesland.inv.dto.invwh.InvWhRpcSimpleDTO;
import com.elitesland.inv.provider.StoreOrderTrnProvider;
import com.elitesland.pur.provider.PurRnsProvider;
import com.elitesland.scp.application.facade.vo.boh.*;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderPageParamVO;
import com.elitesland.scp.application.facade.vo.param.order.StoreReceiveSubmitMqParam;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderTitlePageRespVO;
import com.elitesland.scp.application.service.boh.StoreReceiveService;
import com.elitesland.scp.domain.convert.order.ScpDemandOrderConvert;
import com.elitesland.scp.domain.convert.order.StoreReceiveConvert;
import com.elitesland.scp.domain.entity.storereceive.StoreReceiveDDO;
import com.elitesland.scp.domain.entity.storereceive.StoreReceiveDO;
import com.elitesland.scp.infr.dto.boh.DemandOrderDtl;
import com.elitesland.scp.infr.repo.storereceive.StoreReceiveDRepo;
import com.elitesland.scp.infr.repo.storereceive.StoreReceiveRepo;
import com.elitesland.scp.infr.repo.storereceive.StoreReceiveRepoProc;
import com.elitesland.scp.rmi.RmiInvStkRpcService;
import com.elitesland.scp.rmi.RmiItemService;
import com.elitesland.scp.rmi.RmiOrgStoreRpcService;
import com.elitesland.scp.utils.BeanUtils;
import com.elitesland.scp.utils.SysUtils;
import com.elitesland.support.provider.item.dto.ItmItemBaseRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemLotRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemQualifyRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemUomConvRpcDTO;
import com.elitesland.support.provider.item.param.ItmItemBaseRpcParam;
import com.elitesland.support.provider.item.param.ItmItemUomConvRpcDtoParam;
import com.elitesland.support.provider.item.service.ItmItemRpcService;
import com.elitesland.support.provider.org.dto.OrgAddressRpcDTO;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import com.elitesland.support.provider.org.dto.OrgStoreDetailRpcDTO;
import com.elitesland.support.provider.org.param.OrgAddressRpcDtoParam;
import com.elitesland.support.provider.org.service.OrgAddrRpcService;
import com.elitesland.support.provider.org.service.OrgOuRpcService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.core.task.TaskExecutor;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

@Component
@Slf4j
@RequiredArgsConstructor
public class StoreReceiveServiceImpl implements StoreReceiveService {

    private final StoreReceiveRepo storeReceiveRepo;
    private final StoreReceiveDRepo storeReceiveDRepo;
    private final StoreReceiveRepoProc storeReceiveRepoProc;
    private final OrgOuRpcService orgOuRpcService;
    private final ItmItemRpcService itmItemRpcService;
    private final UdcProvider udcProvider;
    private final OrgAddrRpcService orgAddrRpcService;
    private final StoreOrderTrnProvider storeOrderTrnProvider;
    private final PurRnsProvider purRnsProvider;
    private final TaskExecutor taskExecutor;
    private final MessageQueueTemplate messageQueueTemplate;
    private final RedisTemplate redisTemplate;
    private final RmiItemService rmiItemService;
    private final RmiInvStkRpcService rmiInvStkRpcService;
    private final AccountRpcService accountRpcService;

    private static final Map<String, String> receiveStatusMap = new HashMap<>();
    private static final Map<String, String> rtnStatusMap = new HashMap<>();

    static {
        rtnStatusMap.put("DR", "退货待审");
        rtnStatusMap.put("CE", "待退货");
        rtnStatusMap.put("CF", "已退货");
        rtnStatusMap.put("CL", "已取消");

        receiveStatusMap.put("CE", "待收货");
        receiveStatusMap.put("CF", "已收货");
        receiveStatusMap.put("CL", "已取消");
    }

    private final RmiOrgStoreRpcService rmiOrgStoreRpcService;

    @Override
    public PagingVO<StoreReceivePageVO> page(StoreReceivePageParam param) {
        if (StrUtil.isNotBlank(param.getItemName()) || StrUtil.isNotBlank(param.getItemCode()) || StrUtil.isNotBlank(param.getItemKeyword())) {
            List<Long> itemIdByCodeName = itmItemRpcService.findItemIdByCodeName(param.getItemCode(), param.getItemName(), param.getItemKeyword());
            if (CollectionUtil.isEmpty(itemIdByCodeName)) {
                return new PagingVO<>();
            }

            if (CollectionUtil.isEmpty(param.getItemIds())) {
                param.setItemIds(itemIdByCodeName);
            } else {
                param.getItemIds().retainAll(itemIdByCodeName);
            }
            if (CollectionUtil.isEmpty(param.getItemIds())) {
                return new PagingVO<>();
            }
        }

        if (CollectionUtil.isNotEmpty(param.getCateIds())) {
            List<Long> allLeafCateId = itmItemRpcService.findAllLeafCateId(param.getCateIds());
            param.setCateIds(allLeafCateId);

            List<Long> itemIdsByCate = storeReceiveRepoProc.findItemIdsByCate(allLeafCateId);
            if (CollectionUtil.isEmpty(itemIdsByCate)) {
                return new PagingVO<>();
            }
            if (CollectionUtil.isEmpty(param.getItemIds())) {
                param.setItemIds(itemIdsByCate);
            } else {
                param.getItemIds().retainAll(itemIdsByCate);
            }
            if (CollectionUtil.isEmpty(param.getItemIds())) {
                return new PagingVO<>();
            }
        }

        if (CollectionUtil.isNotEmpty(param.getItemIds())) {
            List<Long> docId = storeReceiveRepoProc.findDocId(param.getItemIds());
            if (CollectionUtil.isEmpty(docId)) {
                return new PagingVO<>();
            }
            if (CollectionUtil.isEmpty(param.getIds())) {
                param.setIds(docId);
            } else {
                param.getIds().retainAll(docId);
            }
            if (CollectionUtil.isEmpty(param.getIds())) {
                return new PagingVO<>();
            }
        }

        PagingVO<StoreReceivePageVO> page = storeReceiveRepoProc.page(param);
        if (CollectionUtil.isNotEmpty(page.getRecords())) {
            for (StoreReceivePageVO record : page.getRecords()) {
                if (record.getRtType().equals("R")) {
                    record.setStatusName(receiveStatusMap.get(record.getStatus()));
                } else {
                    record.setStatusName(rtnStatusMap.get(record.getStatus()));
                }
                if (record.getDocType().equals("TRN")) {
                    record.setDocTypeName("仓配");
                } else {
                    record.setDocTypeName("供应商直发");
                }
            }
        }

        CompletableFuture<Void> future1 = CompletableFuture.runAsync(() -> {
            List<StoreReceivePageVO> rnsRtnList = page.getRecords().stream().filter(i -> i.getRtType().equals("T") && i.getStatus().equals("DR"))
                    .filter(i -> i.getDocType().equals("GR")).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(rnsRtnList)) {
                List<Long> approvingIds = purRnsProvider.findApproving(rnsRtnList.stream().map(i -> i.getDocId()).collect(Collectors.toList())).computeData();
                if (CollectionUtil.isEmpty(approvingIds)) {
                    approvingIds = new ArrayList<>();
                }
                List<Long> finalApprovingIds = approvingIds;
                rnsRtnList.stream().filter(i -> !finalApprovingIds.contains(i.getDocId())).forEach(i -> i.setCanAbort(true));
            }
        }, taskExecutor);

        CompletableFuture<Void> future2 = CompletableFuture.runAsync(() -> {
            List<StoreReceivePageVO> trnRtnList = page.getRecords().stream().filter(i -> i.getRtType().equals("T") && i.getStatus().equals("DR"))
                    .filter(i -> i.getDocType().equals("TRN")).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(trnRtnList)) {
                List<Long> approvingIds = storeOrderTrnProvider.findApproving(trnRtnList.stream().map(i -> i.getDocId()).collect(Collectors.toList())).computeData();
                if (CollectionUtil.isEmpty(approvingIds)) {
                    approvingIds = new ArrayList<>();
                }
                List<Long> finalApprovingIds = approvingIds;
                trnRtnList.stream().filter(i -> !finalApprovingIds.contains(i.getDocId())).forEach(i -> i.setCanAbort(true));
            }
        }, taskExecutor);

        CompletableFuture.allOf(future1, future2).join();

        return page;
    }

    @Override
    public StoreReceiveDetailVO find(Long docId) {
        List<StoreReceiveDO> receiveDOS = storeReceiveRepo.findAllByDocId(docId);
        Assert.notEmpty(receiveDOS, "单据不存在");
        StoreReceiveDO thisDO = receiveDOS.get(0);

        StoreOrderRpcDTO storeOrderRpcDTO = storeOrderTrnProvider.detail(docId, thisDO.getDocType(), thisDO.getRtType()).computeData();
        StoreReceiveDetailVO storeReceiveDetailVO = new StoreReceiveDetailVO();
        storeReceiveDetailVO.setStoreName(storeReceiveRepoProc.findStoreName(thisDO.getOrderId()));
        assignAddress(storeReceiveDetailVO, storeOrderRpcDTO.getAddrNo()); // 填充地址信息
        storeReceiveDetailVO.setDocId(docId);
        storeReceiveDetailVO.setDocNo(storeOrderRpcDTO.getDocNo());
        storeReceiveDetailVO.setRealAmt(thisDO.getRealAmt());
        if (thisDO.getDocType().equals("TRN") && thisDO.getRtType().equals("R")) {
            List<OrgOuRpcSimpleDTO> simpleOuDto = orgOuRpcService.findSimpleOuDto(List.of(storeOrderRpcDTO.getFromOuId()));
            if (CollectionUtil.isNotEmpty(simpleOuDto)) {
                storeReceiveDetailVO.setDeliveyOuName(simpleOuDto.get(0).getOuName());
            }
            storeReceiveDetailVO.setDeliveryWhId(storeOrderRpcDTO.getFromWhId());
            storeReceiveDetailVO.setDeliveryWhName(storeOrderRpcDTO.getFromWhName());
            storeReceiveDetailVO.setReceWhName(storeOrderRpcDTO.getToWhName());
            storeReceiveDetailVO.setRecvWhId(storeOrderRpcDTO.getToWhId());
        } else if (thisDO.getDocType().equals("GR") && thisDO.getRtType().equals("R")) {
            storeReceiveDetailVO.setSuppName(storeOrderRpcDTO.getSuppName());
            storeReceiveDetailVO.setReceWhName(storeOrderRpcDTO.getToWhName());
        } else if (thisDO.getDocType().equals("GR") && thisDO.getRtType().equals("T")) {
            storeReceiveDetailVO.setSuppName(storeOrderRpcDTO.getSuppName());
            storeReceiveDetailVO.setDeliveryWhId(storeOrderRpcDTO.getFromWhId());
            storeReceiveDetailVO.setDeliveryWhName(storeOrderRpcDTO.getFromWhName());
        } else {
            List<OrgOuRpcSimpleDTO> simpleOuDto = orgOuRpcService.findSimpleOuDto(List.of(storeOrderRpcDTO.getToOuId()));
            if (CollectionUtil.isNotEmpty(simpleOuDto)) {
                storeReceiveDetailVO.setReceiveOuName(simpleOuDto.get(0).getOuName());
            }
            storeReceiveDetailVO.setDeliveryWhName(storeOrderRpcDTO.getFromWhName());
            storeReceiveDetailVO.setReceWhName(storeOrderRpcDTO.getToWhName());
        }

        storeReceiveDetailVO.setCreateDate(storeOrderRpcDTO.getCreateTime());
        storeReceiveDetailVO.setReceiveDate(thisDO.getReceiveDate());
        storeReceiveDetailVO.setDocStatus(storeOrderRpcDTO.getDocStatus());
        storeReceiveDetailVO.setNote(storeOrderRpcDTO.getRemark());
        storeReceiveDetailVO.setPics(storeOrderRpcDTO.getPics());
        storeReceiveDetailVO.setPicList(storeOrderRpcDTO.getPicList());
        if (thisDO.getRtType().equals("R")) {
            storeReceiveDetailVO.setRelateDocClsName("门店订货单");
            storeReceiveDetailVO.setRelateDocNo(thisDO.getOrderNo());
        } else {
            storeReceiveDetailVO.setRelateDocClsName("门店收货单");
            storeReceiveDetailVO.setRelateDocNo(thisDO.getReceiveDocNo());
        }
        storeReceiveDetailVO.setDocType(thisDO.getDocType());
        if (thisDO.getDocType().equals("TRN")) {
            storeReceiveDetailVO.setDocTypeName("仓配");
        } else {
            storeReceiveDetailVO.setDocTypeName("供应商直发");
        }
        // 查询商品信息
        List<Long> itemIds = storeOrderRpcDTO.getInvTrnDRpcDTOS().stream().map(i -> i.getItemId()).distinct().collect(Collectors.toList());
        Map<Long, ItmItemLotRpcDTO> itmItemMap = new HashMap<>();
        Map<Long, ItmItemBaseRpcDTO> itmItemBaseMap = new HashMap<>();
        Map<Long, List<ItmItemUomConvRpcDTO>> itemUomConvMap = new HashMap<>();
        if (CollectionUtil.isNotEmpty(itemIds)) {
            List<ItmItemLotRpcDTO> simpleItem = itmItemRpcService.findLotRpcDTOS(itemIds);
            itmItemMap = simpleItem.stream().collect(Collectors.toMap(i -> i.getId(), i -> i));
            // 获取商品基础数据
            ItmItemBaseRpcParam itemBaseRpcParam = new ItmItemBaseRpcParam();
            itemBaseRpcParam.setItemIds(itemIds);
            List<ItmItemBaseRpcDTO> itemBaseRpcDto = itmItemRpcService.findItemBaseRpcDtoByParam(itemBaseRpcParam);

            //单位转换数据
            ItmItemUomConvRpcDtoParam param = new ItmItemUomConvRpcDtoParam();
            param.setItemIds(itemIds);
            List<ItmItemUomConvRpcDTO> itemUomConvDto = itmItemRpcService.findItemUomConvDtoByParam(param);

            itmItemBaseMap = itemBaseRpcDto.stream().collect(Collectors.toMap(i -> i.getId(), i -> i));
            itemUomConvMap = itemUomConvDto.stream().collect(Collectors.groupingBy(ItmItemUomConvRpcDTO::getItemId));
        }
        //获取商品图片信息
        Map<Long, List<DemandOrderDtl>> itemImgUrlMap = getItemImgUrlMap(thisDO.getOrderId());

        Map<String, Map<String, String>> suppUdcMap = udcProvider.getValueMapByUdcCode("yst-supp", Set.of("UOM"));
        Map<String, Map<String, String>> invUdcMap = udcProvider.getValueMapByUdcCode("yst-inv", Set.of("STK_ITM_STATUS"));

        //查询运费商品行
        String orderItemSetting = SysUtils.getOrderItemSetting();
        List<StoreReceiveDDetailVO> items = new ArrayList<>();
        for (StoreOrderDRpcDTO invTrnDRpcDTO : storeOrderRpcDTO.getInvTrnDRpcDTOS()) {

            ItmItemLotRpcDTO itmItemSimpleRpcDTO = itmItemMap.get(invTrnDRpcDTO.getItemId());
            ItmItemBaseRpcDTO itmItemBaseRpcDTO = itmItemBaseMap.get(invTrnDRpcDTO.getItemId());
            List<ItmItemUomConvRpcDTO> itmItemUomConvRpcDTOS = itemUomConvMap.get(invTrnDRpcDTO.getItemId());
            // 退货单不需要显示运费行
            if (thisDO.getRtType().equals("T") && itmItemSimpleRpcDTO.getItemCode().equals(orderItemSetting)) {
                continue;
            }
            StoreReceiveDDetailVO storeReceiveDDetailVO = new StoreReceiveDDetailVO();
            // 基本单位
            storeReceiveDDetailVO.setUom1(itmItemBaseRpcDTO.getUom());
            storeReceiveDDetailVO.setUom1Name(itmItemBaseRpcDTO.getUomName());
            // 中单位
            storeReceiveDDetailVO.setUom3(itmItemBaseRpcDTO.getUom3());
            storeReceiveDDetailVO.setUom3Name(itmItemBaseRpcDTO.getUom3Name());
            // 大单位
            storeReceiveDDetailVO.setUom4(itmItemBaseRpcDTO.getUom4());
            storeReceiveDDetailVO.setUom4Name(itmItemBaseRpcDTO.getUom4Name());
            // 单位转换关系
            storeReceiveDDetailVO.setItmItemUomConvRpcDTOS(itmItemUomConvRpcDTOS);

            storeReceiveDDetailVO.setId(invTrnDRpcDTO.getId());
            storeReceiveDDetailVO.setManuDate(invTrnDRpcDTO.getManuDate());
            storeReceiveDDetailVO.setManuFactory(invTrnDRpcDTO.getManuFactory());
            storeReceiveDDetailVO.setManuFactoryName(invTrnDRpcDTO.getManuFactoryName());
            storeReceiveDDetailVO.setOrderDid(invTrnDRpcDTO.getRelateDocDid());
            storeReceiveDDetailVO.setItemId(invTrnDRpcDTO.getItemId());
            storeReceiveDDetailVO.setPrice(invTrnDRpcDTO.getPrice());
            if (thisDO.getRtType().equals("R")) {
                storeReceiveDDetailVO.setLotNo(invTrnDRpcDTO.getInLotNo());
                storeReceiveDDetailVO.setLimit1(invTrnDRpcDTO.getInLimit1());
                if (invTrnDRpcDTO.getOutQty() == null || BigDecimal.ZERO.compareTo(invTrnDRpcDTO.getOutQty()) == 0) {
                    continue;
                }
            } else {
                if (thisDO.getStatus().equals("CF")) {
                    storeReceiveDDetailVO.setLotNo(invTrnDRpcDTO.getOutLotNo());
                    storeReceiveDDetailVO.setLimit1(invTrnDRpcDTO.getOutLimit1());
                } else {
                    storeReceiveDDetailVO.setLotNo(invTrnDRpcDTO.getLotNo());
                    storeReceiveDDetailVO.setLimit1(invTrnDRpcDTO.getOutLimit1());
                }
            }
            if (thisDO.getDocType().equals("GR")) {
                storeReceiveDDetailVO.setDeliveryQty(invTrnDRpcDTO.getOutQty());
                storeReceiveDDetailVO.setOrderQty(invTrnDRpcDTO.getQty());
                storeReceiveDDetailVO.setReceiveQty(invTrnDRpcDTO.getInQty());
                storeReceiveDDetailVO.setUom(invTrnDRpcDTO.getUom());
                storeReceiveDDetailVO.setUomName(suppUdcMap.get("UOM").get(invTrnDRpcDTO.getUom()));
            } else {
                if (invTrnDRpcDTO.getQty2() == null) {
                    continue;
                }
                storeReceiveDDetailVO.setDeliveryQty(invTrnDRpcDTO.getOutQty2());
                storeReceiveDDetailVO.setOrderQty(invTrnDRpcDTO.getQty2());
                storeReceiveDDetailVO.setReceiveQty(invTrnDRpcDTO.getInQty2());
                storeReceiveDDetailVO.setUom(invTrnDRpcDTO.getUom2());
                storeReceiveDDetailVO.setUomName(suppUdcMap.get("UOM").get(invTrnDRpcDTO.getUom2()));
            }

            if (itmItemSimpleRpcDTO != null) {
                storeReceiveDDetailVO.setItemCode(itmItemSimpleRpcDTO.getItemCode());
                storeReceiveDDetailVO.setItemName(itmItemSimpleRpcDTO.getItemName());
                storeReceiveDDetailVO.setLotFlag(itmItemSimpleRpcDTO.getLotFlag());
                List<DemandOrderDtl> demandOrderDtls = itemImgUrlMap.get(itmItemSimpleRpcDTO.getId());
                if (CollectionUtil.isNotEmpty(demandOrderDtls)) {
                    storeReceiveDDetailVO.setImageUrl(demandOrderDtls.get(0).getImgUrl());
                }
                if(CollectionUtil.isNotEmpty(itmItemSimpleRpcDTO.getSpuIdQualifyDTOS())){
                    List<ItmItemQualifyRpcDTO> list = itmItemSimpleRpcDTO.getSpuIdQualifyDTOS().stream().filter(a -> a.getIsShow() != null && a.getIsShow()).collect(Collectors.toList());
                    storeReceiveDDetailVO.setItemQualifyRpcDTOList(list);
                }
            }
            storeReceiveDDetailVO.setLimit1Name(invUdcMap.get("STK_ITM_STATUS").get(storeReceiveDDetailVO.getLimit1()));
            items.add(storeReceiveDDetailVO);
        }
        storeReceiveDetailVO.setItems(items);

        if (thisDO.getRtType().equals("R")) {
            storeReceiveDetailVO.setDocStatusName(receiveStatusMap.get(thisDO.getStatus()));
        } else {
            storeReceiveDetailVO.setDocStatusName(rtnStatusMap.get(thisDO.getStatus()));
        }
        //获取系统设置
        String invOidoc = SysUtils.getInvOidoc();
        if (invOidoc != null && "1".equals(invOidoc)) {
            storeReceiveDetailVO.setIoDO(true);
        } else {
            storeReceiveDetailVO.setIoDO(false);
        }

        storeReceiveDetailVO.setCarrier(storeOrderRpcDTO.getCarrier());
        storeReceiveDetailVO.setLogisCarrierId(storeOrderRpcDTO.getLogisCarrierId());
        storeReceiveDetailVO.setLogisCarrierCode(storeOrderRpcDTO.getLogisCarrierCode());
        storeReceiveDetailVO.setLogisCarrierName(storeReceiveDetailVO.getLogisCarrierName());
        storeReceiveDetailVO.setLogisContactName(storeReceiveDetailVO.getLogisContactName());
        storeReceiveDetailVO.setLogisContactTel(storeReceiveDetailVO.getLogisContactTel());
        if (StrUtil.isNotBlank(storeOrderRpcDTO.getDeliverMethod())) {
            storeReceiveDetailVO.setDeliverMethod(storeOrderRpcDTO.getDeliverMethod());
            Map<String, Map<String, String>> orderUdcMap = udcProvider.getValueMapByUdcCode("yst-order", Set.of("SO_DELIVER_METHOD"));
            storeReceiveDetailVO.setDeliverMethodName(orderUdcMap.get("SO_DELIVER_METHOD").get(storeReceiveDetailVO.getDeliverMethod()));
        }
        storeReceiveDetailVO.setLogisDocNo(storeOrderRpcDTO.getLogisDocNo());
        List<StoreReceiveDDO> receiveDDOS = storeReceiveDRepo.findAllByMasId(thisDO.getId());
        Map<Long, StoreReceiveDDO> ddoMap = receiveDDOS.stream().collect(Collectors.toMap(i -> i.getDid(), i -> i));
        BigDecimal totalAmt = BigDecimal.ZERO;
        BigDecimal totalQty = BigDecimal.ZERO;
        for (StoreReceiveDDetailVO item : storeReceiveDetailVO.getItems()) {
            StoreReceiveDDO storeReceiveDDO = ddoMap.get(item.getId());
            if (storeReceiveDDO != null) {
                BigDecimal price = storeReceiveDDO.getPrice() == null ? BigDecimal.ZERO : storeReceiveDDO.getPrice();
                item.setPrice(price);
                item.setOrderQty(storeReceiveDDO.getQty());
            }
            if (item.getOrderQty() != null) {
                totalAmt = totalAmt.add(item.getPrice().multiply(item.getOrderQty()));
                totalQty = totalQty.add(item.getOrderQty());
            }
        }
        storeReceiveDetailVO.setTotalAmt(totalAmt);
        storeReceiveDetailVO.setTotalQty(totalQty);
        storeReceiveDetailVO.setDocStatus(thisDO.getStatus());
        if (thisDO.getRtType().equals("T")) {
            storeReceiveDetailVO.setDocStatusName(rtnStatusMap.get(storeReceiveDetailVO.getDocStatus()));
        } else {
            storeReceiveDetailVO.setDocStatusName(receiveStatusMap.get(storeReceiveDetailVO.getDocStatus()));
        }

        return storeReceiveDetailVO;
    }

    @Override
    public StoreReceiveDetailVO findByReceiveDocNo(String purGrNo) {
        List<StoreReceiveDO> receiveDOS = storeReceiveRepo.findAllByReceiveDocNo(purGrNo);
        Assert.notEmpty(receiveDOS, "单据不存在");
        StoreReceiveDO thisDO = receiveDOS.get(0);
        return find(thisDO.getDocId());
    }

    private void assignAddress(StoreReceiveDetailVO storeReceiveDetailVO, Long addrNo) {
        if (addrNo == null || addrNo <= 0) {
            return;
        }

        OrgAddressRpcDtoParam orgAddressRpcDtoParam = new OrgAddressRpcDtoParam();
        orgAddressRpcDtoParam.setAddrNos(List.of(addrNo));
        List<OrgAddressRpcDTO> addrAddressRpcDtoByParam = orgAddrRpcService.findAddrAddressRpcDtoByParam(orgAddressRpcDtoParam);
        if (CollectionUtil.isEmpty(addrAddressRpcDtoByParam)) {
            return;
        }
        OrgAddressRpcDTO orgAddressRpcDTO = addrAddressRpcDtoByParam.stream().filter(i -> i.getDefaultFlag() != null && i.getDefaultFlag()).findFirst().orElseGet(() -> null);
        if (orgAddressRpcDTO == null) {
            return;
        }
        storeReceiveDetailVO.setCountry(orgAddressRpcDTO.getCountry());
        storeReceiveDetailVO.setCountryName(orgAddressRpcDTO.getCountryName());
        storeReceiveDetailVO.setProvince(orgAddressRpcDTO.getProvince());
        storeReceiveDetailVO.setProvinceName(orgAddressRpcDTO.getProvinceName());
        storeReceiveDetailVO.setCity(orgAddressRpcDTO.getCity());
        storeReceiveDetailVO.setCityName(orgAddressRpcDTO.getCityName());
        storeReceiveDetailVO.setCounty(orgAddressRpcDTO.getCounty());
        storeReceiveDetailVO.setCountyName(orgAddressRpcDTO.getCountyName());
        storeReceiveDetailVO.setDetailaddr(orgAddressRpcDTO.getDetailAddr());
        storeReceiveDetailVO.setContPerson(orgAddressRpcDTO.getContPerson());
        storeReceiveDetailVO.setTel(orgAddressRpcDTO.getTel());
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void receiveConfirm(StoreReceiveConfirmParam confirmParam) {
        List<StoreReceiveDO> receiveDOS = storeReceiveRepo.findAllByDocId(confirmParam.getDocId());
        Assert.notEmpty(receiveDOS, "单据不存在");
        StoreReceiveDO thisDO = receiveDOS.get(0);

        String recvKey = "RECEIVE" + confirmParam.getDocId().toString();
        // 检查键是否存在
        if (redisTemplate.hasKey(recvKey)) {
            throw new BusinessException("正在收货中,请稍后重试");
        }
        // 使用SETNX设置键，确保原子性
        boolean isPoSet = redisTemplate.opsForValue().setIfAbsent(recvKey, "1", 60, TimeUnit.SECONDS);
        // 检查是否成功设置键
        if (!isPoSet) {
            throw new BusinessException("正在收货中,请稍后重试");
        }
        Assert.isTrue(Objects.equals(thisDO.getStatus(), "CE") && Objects.equals(thisDO.getRtType(), "R"), "单据不是待收货状态");
        StoreReceiveRpcDTO storeReceiveRpcDTO = new StoreReceiveRpcDTO();
        storeReceiveRpcDTO.setDocId(thisDO.getDocId());
        storeReceiveRpcDTO.setDocNo(thisDO.getDocNo());
        storeReceiveRpcDTO.setDocType(thisDO.getDocType());

        List<StoreReceiveRpcDTO.StoreReceiveRpcDTODetail> details = new ArrayList<>();
        for (StoreReceiveConfirmParam.StoreReceiveConfirmDetail detail : confirmParam.getDetails()) {
            StoreReceiveRpcDTO.StoreReceiveRpcDTODetail rpcDetail = new StoreReceiveRpcDTO.StoreReceiveRpcDTODetail();
            rpcDetail.setQty(detail.getQty());
            rpcDetail.setId(detail.getId());
            rpcDetail.setItemCode(detail.getItemCode());
            rpcDetail.setItemId(detail.getItemId());
            rpcDetail.setManuDate(detail.getManuDate());
            rpcDetail.setLimit1(detail.getLimit1());
            rpcDetail.setLotNo(detail.getLotNo());
            details.add(rpcDetail);
        }
        storeReceiveRpcDTO.setDetails(details);

        try {
            //写入mq队列,进行收货确认
            StoreReceiveSubmitMqParam orderSubmitMqParam = new StoreReceiveSubmitMqParam();
            orderSubmitMqParam.setReceiveRpcDTO(storeReceiveRpcDTO);
            orderSubmitMqParam.setDocId(confirmParam.getDocId());
            orderSubmitMqParam.setBusinessKey(StoreReceiveSubmitMqParam.RECEIVE_SUBMIT_CHANNEL);
            messageQueueTemplate.publishMessageSync("yst-suplan", StoreReceiveSubmitMqParam.RECEIVE_SUBMIT_CHANNEL, orderSubmitMqParam);
        } catch (Exception e) {
            log.info("门店收货提交：{},发送mq消息失败：{}", confirmParam.getDocId(), e.toString());
            redisTemplate.delete(recvKey);
        }

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void rtnConfirm(StoreRtnConfirmParam confirmParam) {
        List<StoreReceiveDO> receiveDOS = storeReceiveRepo.findAllByDocId(confirmParam.getDocId());
        Assert.notEmpty(receiveDOS, "单据不存在");
        StoreReceiveDO thisDO = receiveDOS.get(0);

        Assert.isTrue(Objects.equals(thisDO.getStatus(), "CE") && Objects.equals(thisDO.getRtType(), "T"), "单据不是待退货状态");
        StoreRtnRpcDTO storeRtnRpcDTO = new StoreRtnRpcDTO();
        storeRtnRpcDTO.setDocId(thisDO.getDocId());
        storeRtnRpcDTO.setDeliveryMethod(confirmParam.getDeliveryMethod());
        storeRtnRpcDTO.setDocType(thisDO.getDocType());
        storeRtnRpcDTO.setLogisDocNo(confirmParam.getLogisDocNo());
        storeRtnRpcDTO.setLogisCarrierId(confirmParam.getLogisCarrierId());
        storeRtnRpcDTO.setLogisCarrierCode(confirmParam.getLogisCarrierCode());
        storeRtnRpcDTO.setLogisCarrierName(confirmParam.getLogisCarrierName());
        storeRtnRpcDTO.setNote(confirmParam.getNote());
        storeRtnRpcDTO.setLogisContactTel(confirmParam.getLogisContactTel());
        storeRtnRpcDTO.setLogisContactName(confirmParam.getLogisContactName());

        List<StoreReceiveDDO> receiveDDOS = storeReceiveDRepo.findAllByMasId(thisDO.getId());
        Map<Long, StoreReceiveDDO> ddoMap = receiveDDOS.stream().collect(Collectors.toMap(i -> i.getDid(), i -> i));

        List<StoreRtnRpcDTO.StoreRtnRpcDTODetail> details = new ArrayList<>();
        for (StoreRtnConfirmParam.StoreRtnConfirmDetail detail : confirmParam.getDetails()) {
            StoreReceiveDDO storeReceiveDDO = ddoMap.get(detail.getId());
            if (storeReceiveDDO == null) {
                throw new BusinessException("商品" + detail.getItemCode() + "不在退货申请单内");
            }
            if (storeReceiveDDO.getQty().compareTo(detail.getQty()) < 0) {
                throw new BusinessException("商品" + detail.getItemCode() + "退货数量" + detail.getQty() + "大于申请数量" + storeReceiveDDO.getQty());
            }

            StoreRtnRpcDTO.StoreRtnRpcDTODetail rpcDetail = new StoreRtnRpcDTO.StoreRtnRpcDTODetail();
            rpcDetail.setQty(detail.getQty());
            rpcDetail.setId(detail.getId());
            rpcDetail.setItemCode(detail.getItemCode());
            rpcDetail.setItemId(detail.getItemId());
            details.add(rpcDetail);
        }
        storeRtnRpcDTO.setDetails(details);
        storeOrderTrnProvider.rtn(storeRtnRpcDTO).computeData();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void rtnApply(StoreRtnApplyParam applyParam) {
        StoreReceiveDO thisDO = new StoreReceiveDO();
        if(!applyParam.getReturnType().equals("COMPENSATION")){
            List<StoreReceiveDO> receiveDOS = storeReceiveRepo.findAllByDocId(applyParam.getDocId());
            Assert.notEmpty(receiveDOS, "单据不存在");
            thisDO = receiveDOS.get(0);
            Assert.isTrue(Objects.equals(thisDO.getStatus(), "CF") && Objects.equals(thisDO.getRtType(), "R"), "单据不是已收货状态");
        }
        StoreRtnRpcDTO storeRtnRpcDTO = new StoreRtnRpcDTO();
        storeRtnRpcDTO.setDocId(thisDO.getDocId());
        storeRtnRpcDTO.setDocType(thisDO.getDocType()!=null?thisDO.getDocType():"TRN");
        storeRtnRpcDTO.setNote(applyParam.getNote());
        storeRtnRpcDTO.setPicList(applyParam.getPicList());
        storeRtnRpcDTO.setDeliveryMethod(applyParam.getDeliveryMethod());
        storeRtnRpcDTO.setDemandWhStCode(applyParam.getDemandWhStCode());
        storeRtnRpcDTO.setReturnType(applyParam.getReturnType());
        storeRtnRpcDTO.setRefundMethod(applyParam.getRefundMethod());
        storeRtnRpcDTO.setReturnReason(applyParam.getReturnReason());

        List<StoreRtnRpcDTO.StoreRtnRpcDTODetail> details = new ArrayList<>();
        for (StoreRtnApplyParam.StoreRtnApplyDetail detail : applyParam.getDetails()) {
            StoreRtnRpcDTO.StoreRtnRpcDTODetail rpcDetail = new StoreRtnRpcDTO.StoreRtnRpcDTODetail();
            rpcDetail.setQty(detail.getQty());
            rpcDetail.setId(detail.getId());
            rpcDetail.setItemId(detail.getItemId());
            rpcDetail.setItemCode(detail.getItemCode());
            rpcDetail.setCompensationAmount(detail.getCompensationAmount());
            rpcDetail.setTaxRate(detail.getTaxRate() );
            details.add(rpcDetail);
        }
        storeRtnRpcDTO.setDetails(details);
        StoreRtnApplyResult result = storeOrderTrnProvider.rtnApply(storeRtnRpcDTO).computeData();

        StoreReceiveDO receiveDO = new StoreReceiveDO();
        receiveDO.setDocCreateDate(LocalDateTime.now());
        receiveDO.setStatus("DR"); // 退货待审
        receiveDO.setDocId(result.getDocId());
        receiveDO.setDocNo(result.getDocNo());
        receiveDO.setOrderId(thisDO.getOrderId()!=null?thisDO.getOrderId():-1L);
        receiveDO.setOrderNo(thisDO.getOrderNo());
        receiveDO.setOrderDate(thisDO.getOrderDate());
        receiveDO.setReceiveDate(thisDO.getReceiveDate());
//        receiveDO.setDeliveryDate(thisDO.getDeliveryDate());
        receiveDO.setStoreId(thisDO.getStoreId()!=null?thisDO.getStoreId():applyParam.getDemandWhStId());
        receiveDO.setOrderSetId(thisDO.getOrderSetId()!=null?thisDO.getOrderSetId():-1L);
        String docType = "GR".equals(thisDO.getDocType()) ? "GR" : "TRO";
        receiveDO.setDocType(docType);
        receiveDO.setReceiveDocId(thisDO.getDocId());
        receiveDO.setReceiveDocNo(thisDO.getDocNo());
        receiveDO.setTotalAmt(applyParam.getDetails().stream().filter(i -> i.getQty() != null && i.getPrice() != null)
                .map(i -> i.getQty().multiply(i.getPrice())).reduce(BigDecimal.ZERO, BigDecimal::add));
        receiveDO.setTotalQty(applyParam.getDetails().stream().map(i -> i.getQty()).reduce(BigDecimal.ZERO,
                BigDecimal::add));
        receiveDO.setRtType("T");
        StoreReceiveDO saved = storeReceiveRepo.save(receiveDO);

        Map<Long, BigDecimal> priceMap = applyParam.getDetails().stream().filter(i -> i.getPrice() != null).collect(Collectors.toMap(i -> i.getId(), i -> i.getPrice()));
        List<StoreReceiveDDO> receiveDDOS = new ArrayList<>();
        for (StoreRtnApplyResult.OrderItem item : result.getItems()) {
            StoreReceiveDDO storeReceiveDDO = new StoreReceiveDDO();
            storeReceiveDDO.setDid(item.getDid());
            storeReceiveDDO.setId(IdFactory.generateLong());
            storeReceiveDDO.setItemId(item.getItemId());
            storeReceiveDDO.setMasId(saved.getId());
            storeReceiveDDO.setQty(item.getQty());
            storeReceiveDDO.setPrice(priceMap.get(item.getRelateDocDid()));
            receiveDDOS.add(storeReceiveDDO);
        }
        storeReceiveDRepo.saveAll(receiveDDOS);
    }

    @Override
    public List<StoreCanRtnQtyRpcDTO> canRtn(Long docId) {
        List<StoreReceiveDO> receiveDOS = storeReceiveRepo.findAllByDocId(docId);
        Assert.notEmpty(receiveDOS, "单据不存在");
        StoreReceiveDO thisDO = receiveDOS.get(0);

        Assert.isTrue(Objects.equals(thisDO.getStatus(), "CF") && Objects.equals(thisDO.getRtType(), "R"), "单据不是已收货状态");

        List<StoreCanRtnQtyRpcDTO> rpcDTOS = storeOrderTrnProvider.canRtn(docId, thisDO.getDocType()).computeData();
        rpcDTOS.forEach(row -> {
            if ("GR".equals(thisDO.getDocType())) {
                row.setCanRtnQty(row.getCanRtnQty());
            } else {
                if (row.getCanRtnQty() != null && row.getUomRatio() != null && row.getUomRatio().compareTo(BigDecimal.ZERO) > 0) {
                    row.setCanRtnQty(row.getCanRtnQty().divide(row.getUomRatio(), row.getPlaces(), BigDecimal.ROUND_HALF_UP));
                }
            }
            if (row.getStkQty() != null && row.getUomRatio() != null && row.getUomRatio().compareTo(BigDecimal.ZERO) > 0) {
                row.setStkQty(row.getStkQty().divide(row.getUomRatio(), row.getPlaces(), BigDecimal.ROUND_HALF_UP));
            }
        });

        return rpcDTOS;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void abort(Long docId) {
        List<StoreReceiveDO> receiveDOS = storeReceiveRepo.findAllByDocId(docId);
        Assert.notEmpty(receiveDOS, "单据不存在");
        StoreReceiveDO thisDO = receiveDOS.get(0);
        Assert.isTrue(thisDO.getStatus().equals("DR"), "退货申请不可作废");

        if (thisDO.getDocType().equals("TRN")) {
            storeOrderTrnProvider.abort(docId).computeData();
        } else {
            purRnsProvider.abort(docId).computeData();
        }
        thisDO.setStatus("CL");
        storeReceiveRepo.save(thisDO);
    }

    @Override
    public Long countStoreReceive(StoreReceivePageParam param) {
        PagingVO<StoreReceivePageVO> page = storeReceiveRepoProc.page(param);
        return page.getTotal();
    }

    @Override
    public Map<String, Object> getCompItem() {
        //获取赔付商品
        String itemCode = SysUtils.getCompItemSetting();
        String compImgUrlSetting = SysUtils.getCompImgUrlSetting();
        ItmItemBaseRpcParam itmItemBaseRpcParam = new ItmItemBaseRpcParam();
        itmItemBaseRpcParam.setItemCodes(Arrays.asList(itemCode));
        List<ItmItemBaseRpcDTO> itemBaseRpcDTOList = rmiItemService.findItemBaseRpcDtoByParam(itmItemBaseRpcParam);
        if (CollUtil.isEmpty(itemBaseRpcDTOList)) {
            throw new BusinessException("赔付商品编码：" + itemCode + "不存在");
        }
        //赔付商品
        ItmItemBaseRpcDTO itmItemBaseRpcDTO = itemBaseRpcDTOList.get(0);
        Map<String, Object> stringObjectMap = BeanUtils.beanToMap(itmItemBaseRpcDTO);
        stringObjectMap.put("imgUrl", compImgUrlSetting);
        // 查询默认地址
        // 2.查询赔付默认仓库（配置项）
        String defaultInStoreCode = SysUtils.getDefaultInStore();
//        InvWhRpcSimpleDTO whRpcSimpleDTO = rmiInvStkRpcService.findSimpleWhByCode(defaultInStoreCode);
        InvWhRpcDtoParam param = new InvWhRpcDtoParam();
        param.setWhCode(defaultInStoreCode);
        List<InvWhRpcDTO> invWhRpcDTOS = rmiInvStkRpcService.findWhDTOByParam(param).computeData();
        if(!CollectionUtils.isEmpty(invWhRpcDTOS)) {
            stringObjectMap.put("invWhRpcDTO", invWhRpcDTOS.get(0));
        }
        return stringObjectMap;
    }

    private Map<Long, List<DemandOrderDtl>> getItemImgUrlMap(Long orderId) {
        List<DemandOrderDtl> orderDtl = storeReceiveRepoProc.findOrderDtl(orderId);
        if (CollUtil.isNotEmpty(orderDtl)) {
            return orderDtl.stream().collect(Collectors.groupingBy(DemandOrderDtl::getItemId));
        }
        return new HashMap<>();
    }


    @Override
    public AccountAmtFlowRpcVO  pageWithAccountFlow(AccountAppRpcParam accountAppRpcParam) {
        OrgStoreDetailRpcDTO orgStoreByStoreCode = rmiOrgStoreRpcService.findOrgStoreByStoreCode(accountAppRpcParam.getStoreCode());
        // 查询金额
        ApiResult<AccountAmtFlowRpcVO> accountAmtFlowRpcVOApiResult = accountRpcService.selectAccountAmt(accountAppRpcParam);
        AccountAmtFlowRpcVO data = accountAmtFlowRpcVOApiResult.getData();
        if(data !=null){
            StoreReceivePageParam paramVO = new StoreReceivePageParam();
            // 固定参数
            paramVO.setStoreIds(Arrays.asList(orgStoreByStoreCode.getId()));//门店编码
            paramVO.setStatusList(Arrays.asList("CF"));//已退货，已收货
            OrderItem orderItem = new OrderItem();
            orderItem.setAsc(false);
            orderItem.setColumn("createTime");
            paramVO.setOrders(Arrays.asList(orderItem));
            PagingVO<StoreReceivePageVO> page = page(paramVO);
            PagingVO<StoreReceivePageRpcVO> pageRpc = StoreReceiveConvert.INSTANCE.pageToRpcPage(page);
            if(!CollUtil.isEmpty(pageRpc.getRecords())){
                List<StoreReceivePageRpcVO> records = pageRpc.getRecords();
                List<String> rtDocNos = records.stream().filter(e -> e.getRtType().equals("T")).collect(Collectors.toList()).stream().map(e -> e.getDocNo()).collect(Collectors.toList());// 退货单
                List<String> docNos = records.stream().filter(e -> e.getRtType().equals("R")).collect(Collectors.toList()).stream().map(e -> e.getOrderNo()).collect(Collectors.toList());// 订货货单
                docNos.addAll(rtDocNos);
                // scp查询列表
                ApiResult<List<AccountFlowAppRpcVO>> listApiResult = accountRpcService.selectAccountFlow(docNos);
                // 账户流水
                List<AccountFlowAppRpcVO> flowList = listApiResult.getData();

                Map<String, List<AccountFlowAppRpcVO>> groupedMap = flowList.stream()
                        .collect(Collectors.groupingBy(AccountFlowAppRpcVO::getRootDocNo));
                for (StoreReceivePageRpcVO record : records) {
                    String keyCode = "";
                    if(record.getRtType().equals("R")){
                        keyCode = record.getOrderNo();
                    }else if(record.getRtType().equals("T")){
                        keyCode = record.getDocNo();
                    }
                    List<AccountFlowAppRpcVO> accountFlowAppRpcVOS = groupedMap.get(keyCode);
                    record.setFlowList(accountFlowAppRpcVOS);
                }

            }
            data.setStoreReceivePageVO(pageRpc);
        }
        return data;
    }


}
