package com.elitesland.scp.application.web.boh;

import cn.hutool.core.date.LocalDateTimeUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.scp.application.facade.vo.boh.*;
import com.elitesland.scp.application.service.boh.StoreAppletService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import java.time.LocalDateTime;

@Slf4j
@Api(tags = "小程序首页")
@RestController
@RequestMapping(value = "/applet/home", produces = MediaType.APPLICATION_JSON_VALUE)
@RequiredArgsConstructor
public class AppletHomeController {

    private final StoreAppletService storeAppletService;

    @ApiOperation(value = "首页查询")
    @GetMapping(value = "/detail")
    public ApiResult<StoreAppletHomeVO> detail(@RequestParam("storeId") Long storeId,
                                               @RequestParam("startDate") String startDate, @RequestParam(
            "demandWhStCode") String demandWhStCode, @RequestParam("type") String type) {
        LocalDateTime parse = LocalDateTimeUtil.parse(startDate, "yyyy-MM-dd");
        StoreAppletHomeVO storeAppletHomeVO = storeAppletService.find(storeId, parse, demandWhStCode, type);
        return ApiResult.ok(storeAppletHomeVO);
    }

    @ApiOperation(value = "待办数标")
    @PostMapping(value = "/todoCount")
    public ApiResult<StoreTodoVO> todoCount(@RequestBody StoreReceivePageParam param) {
        StoreTodoVO storeTodoVO = storeAppletService.todo(param);
        return ApiResult.ok(storeTodoVO);
    }

    @ApiOperation(value = "收货数标")
    @PostMapping(value = "/receiveTotal")
    public ApiResult<StoreReceiveTotalVO> receiveTotal(@RequestBody StoreReceivePageParam param) {
        StoreReceiveTotalVO storeReceiveTotalVO = storeAppletService.receiveTotal(param);
        return ApiResult.ok(storeReceiveTotalVO);
    }

    @ApiOperation(value = "退货数标")
    @PostMapping(value = "/rtnCount")
    public ApiResult<StoreRtnTotalVO> rtnCount(@RequestBody StoreReceivePageParam param) {
        StoreRtnTotalVO storeRtnTotalVO = storeAppletService.rtnCount(param);
        return ApiResult.ok(storeRtnTotalVO);
    }
}
