package com.elitesland.scp.application.web.collect;

import cn.hutool.json.JSONUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.scp.application.facade.vo.param.collect.ScpUserCollectCancelVO;
import com.elitesland.scp.application.facade.vo.param.collect.ScpUserCollectParamVO;
import com.elitesland.scp.application.facade.vo.resp.collect.ScpUserCollectRespVO;
import com.elitesland.scp.application.facade.vo.save.collect.ScpUserCollectSaveVO;
import com.elitesland.scp.application.service.collect.ScpUserCollectService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@Slf4j
@Api(tags = "移动端-收藏接口")
@RestController
@RequestMapping(value = "/collect", produces = MediaType.APPLICATION_JSON_VALUE)
@AllArgsConstructor
public class ScpUserCollectController {

    private final ScpUserCollectService scpUserCollectService;

    @ApiOperation(value = "我的收藏列表")
    @PostMapping(value = "/user")
    public ApiResult<List<ScpUserCollectRespVO>> getList(@RequestBody @Validated ScpUserCollectParamVO paramVO) {
        log.info("[SCP-COLLECT] getList  paramVO ={}", JSONUtil.toJsonStr(paramVO));
        return ApiResult.ok(scpUserCollectService.getUserList(paramVO));
    }

    @ApiOperation(value = "添加收藏产品")
    @PostMapping(value = "/add")
    public ApiResult<Long> save(@RequestBody @Validated ScpUserCollectSaveVO saveVO) {
        log.info("[SCP-COLLECT] save  saveVO ={}", JSONUtil.toJsonStr(saveVO));
        return ApiResult.ok(scpUserCollectService.add(saveVO));
    }

    @ApiOperation(value = "取消收藏产品")
    @PostMapping(value = "/cancel")
    public ApiResult<Object> cancel(@RequestBody @Validated ScpUserCollectCancelVO cancelVO) {
        log.info("[SCP-COLLECT] cancel  spuId ={}", JSONUtil.toJsonStr(cancelVO));
        scpUserCollectService.deleteBySpuIdAndUid(cancelVO);
        return ApiResult.ok();
    }

}
