package com.elitesland.scp.domain.entity.calendar;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;


/**
* @description: 供应商送货日历
* @author: jeesie.jiang
* @create: 2024-03-28
* @Version 1.0
**/
@Data
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "scp_supp_demand_calendar")
@Where(clause = "delete_flag = 0 or delete_flag is null")
@Accessors(chain = true)
@org.hibernate.annotations.Table(appliesTo = "scp_supp_demand_calendar", comment = "供应商送货日历")
public class ScpSuppDemandCalendarDO extends BaseModel implements Serializable {

    @Column(name = "supp_id", columnDefinition = "bigint")
    @Comment("门店id")
    private Long suppId;

    @Column(name = "supp_code", columnDefinition = "varchar(64)")
    @Comment("门店编码")
    private String suppCode;

    @Column(name = "supp_name", columnDefinition = "varchar(64)")
    @Comment("门店名称")
    private String suppName;

    @Column(name = "type", columnDefinition = "varchar(30)")
    @Comment("类型")
    private String type;

    @Column(name = "store_wh_id", columnDefinition = "bigint")
    @Comment("门店id/门店仓库id")
    private Long storeWhId;

    @Column(name = "store_wh_code", columnDefinition = "varchar(64)")
    @Comment("仓库编码/门店编码")
    private String storeWhCode;

    @Column(name = "store_wh_name", columnDefinition = "varchar(64)")
    @Comment("仓库名称/门店名称")
    private String storeWhName;

    @Column(name = "year", columnDefinition = "varchar(40)")
    @Comment("年")
    private String year;

    @Column(name = "month", columnDefinition = "varchar(40)")
    @Comment("月")
    private String month;

    @Column(name = "day", columnDefinition = "varchar(40)")
    @Comment("日")
    private String day;

    @Column(name = "work_status", columnDefinition = "varchar(40)")
    @Comment("工作状态")
    private String workStatus;


}