package com.elitesland.scp.application.service.setting;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.setting.ScpOrderSettingBaseParamVO;
import com.elitesland.scp.application.facade.vo.param.setting.ScpOrderSettingPageParamVO;
import com.elitesland.scp.application.facade.vo.param.setting.ScpOrderSettingParamVO;
import com.elitesland.scp.application.facade.vo.param.setting.ScpOrderSettingStatusParamVO;
import com.elitesland.scp.application.facade.vo.resp.setting.ScpOrderSettingPageRespVO;
import com.elitesland.scp.application.facade.vo.resp.setting.ScpOrderSettingRespVO;
import com.elitesland.scp.application.facade.vo.save.setting.ScpOrderSettingSaveVO;

import java.util.List;
import java.util.Optional;

public interface ScpOrderSettingService {

    /**
     * 单据类型配置查询
     *
     * @param paramVO
     * @return
     */
    PagingVO<ScpOrderSettingPageRespVO> page(ScpOrderSettingPageParamVO paramVO);

    /**
     * 单据类型配置详情查询
     *
     * @param id
     * @return
     */
    Optional<ScpOrderSettingRespVO> findOrderSettingById(Long id);

    /**
     * 单据类型配置保存
     *
     * @param saveVO
     * @return
     */
    Long saveOrderSetting(ScpOrderSettingSaveVO saveVO);

    /**
     * 删除
     *
     * @param ids
     */
    void deleteByIds(List<Long> ids);

    /**
     * 变更状态
     *
     * @param paramVO
     * @return
     */
    void changeOrderSettingStatus(ScpOrderSettingStatusParamVO paramVO);

    /**
     * 单据类型配置查询
     *
     * @param paramVO
     * @return
     */
    List<ScpOrderSettingRespVO> queryOrderSettingList(ScpOrderSettingParamVO paramVO);

    /**
     * 获取首选商品分类标识
     * @param type
     * @return
     */
    String getFirstItemCate(ScpOrderSettingBaseParamVO paramVO);
}
