package com.elitesland.scp.pay.controller;

import com.elitesland.scp.pay.service.AccountLinkService;
import com.elitesland.scp.pay.service.PaymentService;
import com.elitesland.scp.pay.vo.PayOrderReqDTO;
import com.elitesland.scp.utils.RandomUtil;
import com.tenpay.business.entpay.mse.sdk.api.Payment;
import com.tenpay.business.entpay.mse.sdk.api.Redirect;
import com.tenpay.business.entpay.mse.sdk.exception.EntpayException;
import com.tenpay.business.entpay.mse.sdk.model.Goods;
import com.tenpay.business.entpay.mse.sdk.model.ProfitAllocationFlagConstant;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import static com.tenpay.business.entpay.mse.sdk.model.CurrencyConstant.CNY;
import static com.tenpay.business.entpay.mse.sdk.model.PickTypeConstant.SELF_PICK;

@Slf4j
@RestController
@RequestMapping("/test")
@RequiredArgsConstructor
@Validated
public class TestController {

    private final PaymentService paymentService;
    private final AccountLinkService accountLinkService;

    @ApiOperation(value = "小程序支付下单-测试数据")
    @PostMapping("/mock/mp-pay")
    public Redirect createTestMPPay(@RequestBody String mpPath) throws EntpayException {
        PayOrderReqDTO payOrderReqDTO = new PayOrderReqDTO();
        //收款方信息
        payOrderReqDTO.setEntId("100203124444");
        payOrderReqDTO.setEntName("微企付联调企业");
        List<Goods> goodsList = new ArrayList<>();
        for (int i = 0; i < 2; i++) {
            Goods goods = Goods.builder()
                    .goodName("商品名称")
                    .goodNumber(1)
                    .goodAmount(8L)
                    .build();
            goodsList.add(goods);
        }
        payOrderReqDTO.setGoods(goodsList);
        payOrderReqDTO.setDeviceId("");
        payOrderReqDTO.setPayerClientIp("127.0.0.7");
        payOrderReqDTO.setPayerUa("idea");
        payOrderReqDTO.setCreateTime(new Date());
        payOrderReqDTO.setPickType(SELF_PICK);
        payOrderReqDTO.setPickDescription("描述");
        // 支付下单
        Date now = new Date();
        Date expireDate = new Date(now.getTime() + 600000); //10分钟前的时间
        payOrderReqDTO.setStoreId("123");
        payOrderReqDTO.setStoreName("门店名称");
        payOrderReqDTO.setStoreAreaCode("440300");
        payOrderReqDTO.setMpPath(mpPath);
        String outPaymentId = RandomUtil.getRandom(20);
        payOrderReqDTO.setOutPaymentId(outPaymentId);
        payOrderReqDTO.setAmount(10L);
        payOrderReqDTO.setCurrency(CNY);
        payOrderReqDTO.setExpireTime(expireDate);
        payOrderReqDTO.setGoods(goodsList);
        payOrderReqDTO.setMemo("双面羊绒，10，5600");
        payOrderReqDTO.setAttachment("双面羊绒，10，5600");
        payOrderReqDTO.setProfitAllocationFlag(ProfitAllocationFlagConstant.API_PROFIT_ALLOCATION);

        Payment payment = paymentService.createMpPay(payOrderReqDTO);
        // 响应跳转链接
        return accountLinkService.createPaymentLink(payment.getPaymentId(), outPaymentId, expireDate);
    }

    @ApiOperation(value = "二维码支付下单-测试数据")
    @GetMapping(value = "/mock/qrcode_pay")
    public Redirect createTestQRPay() throws EntpayException {
        log.info("二维码支付下单请求参数：{}");
        // 封装二维码支付接口
        String outPaymentId = RandomUtil.getRandom(20);
        PayOrderReqDTO payOrderReqDTO = new PayOrderReqDTO();
        payOrderReqDTO.setOutPaymentId(outPaymentId);
        payOrderReqDTO.setAmount(1L);
        payOrderReqDTO.setCurrency(CNY);
        Date now = new Date();
        Date expireDate = new Date(now.getTime() + 600000); //10分钟前的时间
        payOrderReqDTO.setExpireTime(expireDate);
        payOrderReqDTO.setEntId("100203124444");
        payOrderReqDTO.setEntName("微企付联调企业");
        payOrderReqDTO.setMemo("双面羊绒，10，5600");
        payOrderReqDTO.setAttachment("双面羊绒，10，5600");
        payOrderReqDTO.setDeviceId("");
        payOrderReqDTO.setPayerClientIp("127.0.0.7");
        payOrderReqDTO.setPayerUa("idea");
        payOrderReqDTO.setCreateTime(new Date());
        payOrderReqDTO.setPickType(SELF_PICK);
        payOrderReqDTO.setPickDescription("描述");
        payOrderReqDTO.setStoreId("123");
        payOrderReqDTO.setStoreName("门店名称");
        payOrderReqDTO.setStoreAreaCode("440300");
        List<Goods> goodsList = new ArrayList<>();
        for (int i = 0; i < 2; i++) {
            Goods goods = Goods.builder()
                    .goodName("商品名称")
                    .goodNumber(1)
                    .goodAmount(8L)
                    .build();

            goodsList.add(goods);
        }
        payOrderReqDTO.setGoods(goodsList);
        payOrderReqDTO.setProfitAllocationFlag(ProfitAllocationFlagConstant.API_PROFIT_ALLOCATION);

        Payment payment = paymentService.createQrCodePay(payOrderReqDTO);
        // 响应跳转链接
        return accountLinkService.createPaymentLink(payment.getPaymentId(), outPaymentId, expireDate);
    }
}
