package com.elitesland.scp.application.facade.vo.resp.app;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
@ApiModel("订货集分页返回")
public class AppItemActivityOrderRespVO extends BaseViewModel implements Serializable {
    private static final long serialVersionUID = -4607660124307291057L;

    @ApiModelProperty("订货集ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long demandId;

    @ApiModelProperty("订货集编码")
    private String demandCode;

    @ApiModelProperty("订货集名称")
    private String demandName;

    @ApiModelProperty("订货单编码")
    private String docCode;

    @ApiModelProperty("单据类别")
    @SysCode(sys = "yst-suplan", mod = "OB_DOC_CLS")
    private String docCls;
    private String docClsName;

    @ApiModelProperty("单据状态")
    @SysCode(sys = "yst-suplan", mod = "DEO_STATUS")
    private String docStatus;
    private String docStatusName;

    @ApiModelProperty("类型")
    @SysCode(sys = "yst-suplan", mod = "DEMAND_SET_TYPE")
    private String type;
    private String typeName;

    @ApiModelProperty("需求仓库id/门店id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long demandWhStId;

    @ApiModelProperty("需求仓库编码/门店编码")
    private String demandWhStCode;

    @ApiModelProperty("需求仓库名称/门店名称")
    private String demandWhStName;

    @ApiModelProperty("需求日期")
    private LocalDateTime demandDate;

    @ApiModelProperty("经营性质")
    @SysCode(sys = "yst-supp", mod = "STORE_TYPE2")
    private String storeType2;
    private String storeType2Name;

    @ApiModelProperty("订货单明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long detailId;

    @ApiModelProperty("来源明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long sourceId;

    @ApiModelProperty("商品id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("需求数量")
    private BigDecimal demandQuantity;

    @ApiModelProperty("拆分需求数量")
    private BigDecimal allocationDeQuantity;

    @ApiModelProperty("单位")
    private String unit;

    @ApiModelProperty("含税单价")
    private BigDecimal price;

    @ApiModelProperty("币种，默认CNY")
    private String currency;

    @ApiModelProperty("分配数量")
    private BigDecimal allocationQuantity;

    @ApiModelProperty("计划数量")
    private BigDecimal planQuantity;

    @ApiModelProperty("供应仓库id、供应商id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long suppWhId;

    @ApiModelProperty("供应仓库编码、供应商编码")
    private String suppWhCode;

    @ApiModelProperty("供应仓库名称、供应商名称")
    private String suppWhName;

    @ApiModelProperty("采购公司id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty("采购公司编码")
    private String ouCode;

    @ApiModelProperty("采购公司名称")
    private String ouName;

    @ApiModelProperty("分配单据id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long srcDocId;

    @ApiModelProperty("分配单据编码")
    private String srcDocNo;

    @ApiModelProperty("分配单据类别")
    private String srcDocCls;
    private String srcDocClsName;

    @ApiModelProperty("分配单据明细行号")
    private String srcDocLineNo;

    @ApiModelProperty("发货数量")
    private BigDecimal quantity;

    @ApiModelProperty("是否已计算，true:已计算，false:未计算")
    private Boolean isCalculated;
    private String isCalculatedName;

    @ApiModelProperty("是否已推送, true:已推送，false:未推送")
    private Boolean isPushed;
    private String isPushedName;

    @ApiModelProperty("累计订购次数")
    private BigDecimal countQty;

    @ApiModelProperty("累计订购数量")
    private BigDecimal sumQty;

    public String getIsCalculatedName() {
        return (isCalculated != null && isCalculated) ? "已计算" : "未计算";
    }

    public String getIsPushedName() {
        return (isPushed != null && isPushed) ? "已推送" : "未推送";
    }
}
