package com.elitesland.scp.domain.entity.mrp;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;


/**
 * 物料需求计划明细表
 *
 * @author chaofeng.xia
 * @since 2025/1/14
 */
@Data
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "scp_mrp_d")
@Where(clause = "delete_flag = 0 or delete_flag is null")
@Accessors(chain = true)
@org.hibernate.annotations.Table(appliesTo = "scp_mrp_d", comment = "物料需求计划明细表")
public class ScpMrpDDO extends BaseModel implements Serializable {

    @Comment("主表ID")
    @Column(name = "mas_id", columnDefinition = "bigint comment '主表ID'")
    private Long masId;

    @Comment("公司id")
    @Column(name = "ou_id", columnDefinition = "bigint comment '公司id'")
    private Long ouId;

    @Comment("公司编码")
    @Column(name = "ou_code", columnDefinition = "varchar(64) comment '公司编码'")
    private String ouCode;

    @Comment("公司名称")
    @Column(name = "ou_name", columnDefinition = "varchar(64) comment '公司名称'")
    private String ouName;

    @Comment("仓库id")
    @Column(name = "wh_id", columnDefinition = "bigint comment '仓库id'")
    private Long whId;

    @Comment("仓库编码")
    @Column(name = "wh_code", columnDefinition = "varchar(64) comment '仓库编码'")
    private String whCode;

    @Comment("仓库名称")
    @Column(name = "wh_name", columnDefinition = "varchar(64) comment '仓库名称'")
    private String whName;

    @Comment("商品id")
    @Column(name = "item_id", columnDefinition = "bigint comment '商品id'")
    private Long itemId;

    @Comment("商品编码")
    @Column(name = "item_code", columnDefinition = "varchar(64) comment '商品编码'")
    private String itemCode;

    @Comment("商品名称")
    @Column(name = "item_name", columnDefinition = "varchar(64) comment '商品名称'")
    private String itemName;

    @Comment("预测安全库存")
    @Column(name = "pred_safety_qty", columnDefinition = "decimal(20, 8) comment '预测安全库存'")
    private BigDecimal predSafetyQty;

    @Comment("预测目标库存")
    @Column(name = "pred_target_qty", columnDefinition = "decimal(20, 8) comment '预测目标库存'")
    private BigDecimal predTargetQty;

    @Comment("在库数")
    @Column(name = "inv_qty", columnDefinition = "decimal(20, 8) comment '在库数'")
    private BigDecimal invQty;

    @Comment("毛需求")
    @Column(name = "gross_demand", columnDefinition = "decimal(20, 8) comment '毛需求'")
    private BigDecimal grossDemand;

    @Comment("采购在途数量")
    @Column(name = "pur_transit_qty", columnDefinition = "decimal(20, 8) comment '采购在途数量'")
    private BigDecimal purTransitQty;

    @Comment("最小起订量")
    @Column(name = "moq", columnDefinition = "decimal(20, 8) comment '最小起订量'")
    private BigDecimal moq;

    @Comment("采购提前期")
    @Column(name = "pur_lead_time", columnDefinition = "decimal(20, 8) comment '采购提前期'")
    private BigDecimal purLeadTime;

    @Comment("预期到货日期")
    @Column(name = "expect_arrive_date", columnDefinition = "datetime comment '预期到货日期'")
    private LocalDateTime expectArriveDate;

    @Column(name = "sal_qty", columnDefinition = "decimal(20,8)")
    @Comment("月销量")
    private BigDecimal salQty;

    @Column(name = "io_qty", columnDefinition = "decimal(20,8)")
    @Comment("库存增减量")
    private BigDecimal ioQty;

    @Column(name = "before_qty", columnDefinition = "decimal(20,8)")
    @Comment("30天前的库存余额")
    private BigDecimal beforeQty;

    @Column(name = "uom_ratio", columnDefinition = "decimal(20,8),default 1")
    @Comment("转换率")
    private BigDecimal uomRatio;

    @Comment("库存周转率")
    @Column(name = "inv_turnover", columnDefinition = "decimal(20, 8) comment '库存周转率'")
    private BigDecimal invTurnover;

    @Comment("标准库存周转率")
    @Column(name = "std_inv_turnover", columnDefinition = "decimal(20, 8) comment '标准库存周转率'")
    private BigDecimal stdInvTurnover;

    @Comment("净需求")
    @Column(name = "net_demand", columnDefinition = "decimal(20, 8) comment '净需求'")
    private BigDecimal netDemand;

    @Comment("采购计划单位")
    @Column(name = "uom", columnDefinition = "decimal(20, 8) comment '采购计划单位'")
    private String uom;

    @Comment("采购计划单位名称")
    @Column(name = "uom_name", columnDefinition = "decimal(20, 8) comment '采购计划单位名称'")
    private String uomName;

    @ApiModelProperty("来源单据明细ID")
    @Column(name="root_doc_did" , columnDefinition = "bigint(20)  comment '来源单据明细ID'")
    private Long relateDocDid;

}