package com.elitesland.scp.config;

import com.elitescloud.boot.swagger.common.BaseSwaggerConfig;
import com.github.xiaoymin.knife4j.spring.extension.OpenApiExtensionResolver;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.spring.web.plugins.Docket;

/**
 * @author ryan.xu
 * @date 2024/03/18
 */
@Configuration
@ConditionalOnProperty(prefix = "knife4j", name = "enable", havingValue = "true")
public class SwaggerConfig extends BaseSwaggerConfig {

    public SwaggerConfig(OpenApiExtensionResolver openApiExtensionResolver, ServerProperties serverProperties) {
        super(openApiExtensionResolver, serverProperties);
    }

    @Bean
    public Docket createScpRestApi() {
        String[] controllerPackages = {"com.elitesland.scp.application.web", "com.elitesland.scp.job"};
        return createDocket("供应链计划-API", controllerPackages);
    }

    @Bean
    public Docket createPayRestApi() {
        String[] controllerPackages = {"com.elitesland.scp.pay.controller"};
        return createDocket("支付-API", controllerPackages);
    }

    @Bean
    public Docket createLakalaPayRestApi() {
        String[] controllerPackages = {"com.elitesland.scp.lakalapay.controller"};
        return createDocket("拉卡拉支付-API", controllerPackages);
    }
}
