package com.elitesland.scp.application.facade.vo.calendar;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.checkerframework.checker.units.qual.A;

import javax.persistence.Column;
import java.io.Serializable;
import java.util.List;

/**
* @description:  
* @author: jeesie.jiang@create: 2024-03-28
* @Version 1.0
**/

@Data
@ApiModel(value = "ScpStoreDemandCalendarSaveVO", description = "门店日历保存")
public class ScpStoreDemandCalendarSaveVO implements Serializable {

    @ApiModelProperty(value = "类型")
    private String type;

    @ApiModelProperty(value = "门店id")
    private Long storeId;

    @ApiModelProperty(value = "门店编码")
    private String storeCode;

    @ApiModelProperty(value = "门店名称")
    private String storeName;

    @ApiModelProperty(value = "年")
    private String year;

    @ApiModelProperty(value = "月")
    private String month;

    @ApiModelProperty(value = "单双日")
    private String sddType;

    @ApiModelProperty("商品分类")
    private List<String> itemType2s;

    private List<CalendarDayDetail> dayDetails;


    @Data
    public static class CalendarDayDetail extends BaseViewModel implements Serializable {

        @ApiModelProperty(value = "日")
        private String day;

        @ApiModelProperty(value = "工作状态")
        private String workStatus;

    }



}