package com.elitesland.scp.application.facade.vo.cart;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @Auther: Mark
 * @Date: 2024/3/26 17:13
 * @Description:
 */
@Data
@ApiModel("下单校验参数")
public class OrderCheckParamVO implements Serializable {

    @ApiModelProperty(value = "门店编码", required = true)
    @NotBlank(message = "门店编码不能为空")
    private String demandWhStCode;

    @ApiModelProperty(value = "单据类型", required = true)
    @NotBlank(message = "单据类型不能为空")
    private String docType;

    @ApiModelProperty(value = "确认提交", required = true)
    private Boolean confirmFlag;

}
