package com.elitesland.scp.application.facade.vo.save.calendar;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

@Data
@ApiModel(value = "单据类型配置保存参数")
public class ScpStoreCalendarSetSaveVO implements Serializable {
    private static final long serialVersionUID = -3342841575717594695L;

    @ApiModelProperty("记录唯一ID")
    private Long id;

    @ApiModelProperty(value = "配置编码", required = true)
    @NotBlank(message = "配置编码不能为空")
    private String setCode;

    @ApiModelProperty(value = "配置名称", required = true)
    @NotBlank(message = "配置名称不能为空")
    private String setName;

    @ApiModelProperty(value = "配置描述", required = true)
    @NotBlank(message = "配置描述不能为空")
    private String setDescription;

    @ApiModelProperty(value = "起始年份", required = true)
    @NotNull(message = "起始年份不能为空")
    private Integer startYear;

    @ApiModelProperty(value = "结束年份")
    private Integer endYear;

    @ApiModelProperty(value = "订单状态")
    private String docStatus;

    @ApiModelProperty("单据分类")
    private List<String> itemType2s;

    @ApiModelProperty(value = "单据分类")
    private String itemType2;
}
