package com.elitesland.scp.domain.service.alloc;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitesland.scp.application.facade.vo.resp.alloc.ScpAllocSettingItemRespVO;
import com.elitesland.scp.application.facade.vo.save.alloc.ScpAllocSettingItemSaveVO;
import com.elitesland.scp.common.ScpConstant;
import com.elitesland.scp.domain.convert.alloc.ScpAllocSettingItemConvert;
import com.elitesland.scp.domain.entity.alloc.ScpAllocSettingItemDO;
import com.elitesland.scp.domain.entity.alloc.ScpAllocSettingRedisDO;
import com.elitesland.scp.infr.repo.alloc.ScpAllocSettingItemRepo;
import com.elitesland.scp.infr.repo.alloc.ScpAllocSettingItemRepoProc;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;


@Slf4j
@Service
@RequiredArgsConstructor
public class ScpAllocSettingItemDomainServiceImpl implements ScpAllocSettingItemDomainService {

    private final RedisTemplate redisTemplate;
    private final ScpAllocSettingItemRepo scpAllocSettingItemRepo;
    private final ScpAllocSettingItemRepoProc scpAllocSettingItemRepoProc;

    @Override
    @SysCodeProc
    public List<ScpAllocSettingItemRespVO> findByMasId(Long masId) {
        List<ScpAllocSettingItemDO> settingItemDOS = scpAllocSettingItemRepo.findByMasId(masId);
        if (CollUtil.isNotEmpty(settingItemDOS)) {
            return ScpAllocSettingItemConvert.INSTANCE.dosToRespVOS(settingItemDOS);
        }
        return new ArrayList<>();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void batchSaveAllocSettingItem(List<ScpAllocSettingItemSaveVO> saveVOS) {
        scpAllocSettingItemRepo.saveAll(ScpAllocSettingItemConvert.INSTANCE.saveVosDOS(saveVOS));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByMasId(Long masId) {
        scpAllocSettingItemRepo.deleteByMasId(masId);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByIds(List<Long> ids) {
        scpAllocSettingItemRepo.deleteByIds(ids);
    }

    @Override
    public List<ScpAllocSettingItemRespVO> getEnableAllocSettingItemByStoreCode(String storeCode, String docType,
                                                                                List<String> itemTypes) {
        List<ScpAllocSettingItemRespVO> respVOS = new ArrayList<>();
        Object obj = redisTemplate.opsForValue().get(ScpConstant.ALLOC_SETTING + storeCode);
        if (obj == null) {
            return new ArrayList<>();
        }
        String str = (String) obj;
        var setting = JSON.parseObject(str, ScpAllocSettingRedisDO.class);
        List<ScpAllocSettingRedisDO.ActivityDO> activityList = setting.getActivityList();
        for (ScpAllocSettingRedisDO.ActivityDO activityDO : activityList) {
            log.info("getEnableAllocSettingItemByStoreCode:{}", JSONUtil.toJsonStr(activityDO));
            Object key = redisTemplate.opsForValue().get(ScpConstant.ALLOC_SETTING + activityDO.getActivityId());
            if (key == null) {
                log.info("强配活动ID:{}，缓存不存在", activityDO.getActivityId());
                continue;
            }
            if (LocalDateTime.now().compareTo(activityDO.getValidFrom()) < 0 || LocalDateTime.now().compareTo(activityDO.getValidTo()) > 0) {
                log.info("强配活动ID:{}，已过期", activityDO.getActivityId());
                continue;
            }
            boolean contains = activityDO.getDocTypes().contains(docType);
            if (!contains) {
                log.info("强配活动ID:{}，单据类型不匹配", activityDO.getActivityId());
                continue;
            }
            List<ScpAllocSettingRedisDO.ActivityDO.InnerItemDO> innerItemDOS = activityDO.getInnerItemDOS();
            for (ScpAllocSettingRedisDO.ActivityDO.InnerItemDO innerItemDO : innerItemDOS) {
                if (!itemTypes.contains(innerItemDO.getItemType2())) {
                    log.info("强配活动ID:{}，商品分类:{}不存在", activityDO.getActivityId(), innerItemDO.getItemType2());
                    continue;
                }
                ScpAllocSettingItemRespVO scpAllocSettingItemRespVO = new ScpAllocSettingItemRespVO();
                scpAllocSettingItemRespVO.setItemId(innerItemDO.getItemId());
                scpAllocSettingItemRespVO.setItemCode(innerItemDO.getItemCode());
                scpAllocSettingItemRespVO.setItemName(innerItemDO.getItemName());
                scpAllocSettingItemRespVO.setMasId(innerItemDO.getMasId());
                scpAllocSettingItemRespVO.setMinNum(innerItemDO.getMinNum());
                scpAllocSettingItemRespVO.setActivityCode(activityDO.getActivityCode());
                scpAllocSettingItemRespVO.setImgUrl(innerItemDO.getImgUrl());
                respVOS.add(scpAllocSettingItemRespVO);
            }
        }
        return respVOS;
    }

    @Override
    public List<Long> findMasIdByItemId(Long itemId) {
        return scpAllocSettingItemRepoProc.findMasIdByItemId(itemId);
    }
}
