package com.elitesland.scp.domain.service.calendar;

import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.calendar.ScpSuppDemandCalendarPageParamVO;
import com.elitesland.scp.application.facade.vo.calendar.ScpSuppDemandCalendarPageVO;
import com.elitesland.scp.application.facade.vo.calendar.ScpSuppDemandCalendarParamVO;
import com.elitesland.scp.domain.convert.calendar.ScpSuppDemandCalendarConvert;
import com.elitesland.scp.domain.entity.calendar.ScpSuppDemandCalendarDO;
import com.elitesland.scp.infr.dto.calendar.ScpSuppDemandCalendarDTO;
import com.elitesland.scp.infr.repo.calendar.ScpSuppDemandCalendarRepo;
import com.elitesland.scp.infr.repo.calendar.ScpSuppDemandCalendarRepoProc;
import io.seata.common.util.CollectionUtils;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
* @description:  
* @author: jeesie.jiang
* @create: 2024-03-28
* @Version 1.0
**/
@RequiredArgsConstructor
@Service
@Slf4j
public class ScpSuppDemandCalendarDomainServiceImpl implements ScpSuppDemandCalendarDomainService {

    private final ScpSuppDemandCalendarRepo scpSuppDemandCalendarRepo;

    private final ScpSuppDemandCalendarRepoProc scpSuppDemandCalendarRepoProc;


    @Override
    @SysCodeProc
    public PagingVO<ScpSuppDemandCalendarPageVO> searchPage(ScpSuppDemandCalendarPageParamVO paramVo) {
        return scpSuppDemandCalendarRepoProc.searchPage(paramVo);
    }

    @Override
    public List<ScpSuppDemandCalendarDTO> findCalendarListByConcatStr(List<String> concatKey) {
        List<ScpSuppDemandCalendarDO> calendarDOList = scpSuppDemandCalendarRepo.findByConcatYearAndMonthKey(concatKey);
        if(CollectionUtils.isNotEmpty(calendarDOList)){
            List<ScpSuppDemandCalendarDTO> dtoList = calendarDOList.stream().map(ScpSuppDemandCalendarConvert.INSTANCE::doToDto).collect(Collectors.toList());
            return dtoList;
        }else{
            return Collections.emptyList();
        }
    }

    @Override
    public List<ScpSuppDemandCalendarDTO> findCalendarByStoreDayConcatStr(List<String> storeDayConcatStr) {
        List<ScpSuppDemandCalendarDO> calendarDOList = scpSuppDemandCalendarRepo.findCalendarByStoreDayConcatStr(storeDayConcatStr);
        if(CollectionUtils.isNotEmpty(calendarDOList)){
            List<ScpSuppDemandCalendarDTO> dtoList = calendarDOList.stream().map(ScpSuppDemandCalendarConvert.INSTANCE::doToDto).collect(Collectors.toList());
            return dtoList;
        }else{
            return Collections.emptyList();
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void createBatch(List<ScpSuppDemandCalendarDTO> createParams) {
        List<ScpSuppDemandCalendarDO> saveList = createParams.stream().map(ScpSuppDemandCalendarConvert.INSTANCE::dtoToDo).collect(Collectors.toList());
        scpSuppDemandCalendarRepo.saveAll(saveList);
    }

    @Override
    @SysCodeProc
    public List<ScpSuppDemandCalendarDTO> findSuppCalendarListByParam(ScpSuppDemandCalendarParamVO param) {
        return scpSuppDemandCalendarRepoProc.findSuppCalendarListByParam(param);
    }

    @Override
    public void deleteBatch(List<Long> ids) {
        scpSuppDemandCalendarRepo.deleteAllByIdInBatch(ids);
    }
}