package com.elitesland.scp.domain.service.mrp;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.mrp.ScpMrpPageParam;
import com.elitesland.scp.application.facade.vo.resp.mrp.ScpMrpRespVO;
import com.elitesland.scp.domain.entity.mrp.ScpMrpDO;

import java.util.List;

/**
 * @author chaofeng.xia
 * @since 2025/1/15
 */
public interface ScpMrpDomainService {

    /**
     * 分页查询
     *
     * @param param 查询参数
     * @return 结果
     */
    PagingVO<ScpMrpRespVO> searchPage(ScpMrpPageParam param);

    List<ScpMrpDO> findByIds(List<Long> ids);

    ScpMrpDO findById(Long id);

    void deleteByIds(List<Long> ids);

    void updatePushStatus(Long id, String pushStatus, String pushFailReason);

    void updatePushStatus(List<Long> ids, String pushStatus, String pushFailReason);

    List<ScpMrpDO> saveList(List<ScpMrpDO> scpMrpDOs);

    ScpMrpDO save(ScpMrpDO scpMrpDO);

    void updateCalcStatus(List<Long> ids, String calcStatus, String calcFailReason);

}