package com.elitesland.scp.mq;

import com.elitescloud.boot.mq.MessageQueueListener;
import com.elitesland.scp.application.facade.vo.param.order.ScpPoOrderCreateMqParam;
import com.elitesland.scp.application.service.order.ScpDemandOrderService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

@Component
@Slf4j
@RequiredArgsConstructor
public class ScpPoOrderCreateListener implements MessageQueueListener<ScpPoOrderCreateMqParam> {

    private final ScpDemandOrderService scpDemandOrderService;

    @Override
    public @NotEmpty String[] channels() {
        return new String[]{ScpPoOrderCreateMqParam.CREATE_CHANNEL};
    }

    @Override
    public void onConsume(@NotBlank String s, @NotNull ScpPoOrderCreateMqParam poOrderCreateMqParam) {
        scpDemandOrderService.pushPo(poOrderCreateMqParam.getPoList());
    }
}
