package com.elitesland.scp.provider.order;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.scp.ScpApplication;
import com.elitesland.scp.application.facade.vo.boh.StoreReceiveDDetailVO;
import com.elitesland.scp.application.facade.vo.boh.StoreReceiveDetailVO;
import com.elitesland.scp.application.facade.vo.boh.StoreRtnConfirmParam;
import com.elitesland.scp.application.service.boh.StoreReceiveService;
import com.elitesland.scp.service.order.ScpDemandOrderDRpcService;
import com.elitesland.scp.service.order.StoreReceiveProvider;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

@Slf4j
@Service
@RestController
@RequiredArgsConstructor
@RequestMapping(ScpApplication.URI_PREFIX + ScpDemandOrderDRpcService.PATH)
public class StoreReceiveProviderImpl implements StoreReceiveProvider {
    String PATH = "/rtn";

    private final StoreReceiveService storeReceiveService;
    /**
     * 门店小程序确认退货（出库）
     *
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public ApiResult rtnConfirm(String purGrNo){
        StoreRtnConfirmParam storeRtnConfirmParam = new StoreRtnConfirmParam();
        // 通过收货单查询
        StoreReceiveDetailVO storeReceiveDetailVO = storeReceiveService.findByReceiveDocNo(purGrNo);
        storeRtnConfirmParam.setDocId(storeReceiveDetailVO.getDocId());
        storeRtnConfirmParam.setDeliveryMethod("SE");
        List<StoreRtnConfirmParam.StoreRtnConfirmDetail> details = new ArrayList<>();
        List<StoreReceiveDDetailVO> items = storeReceiveDetailVO.getItems();
        for (StoreReceiveDDetailVO item : items) {
            StoreRtnConfirmParam.StoreRtnConfirmDetail storeRtnConfirmDetail = new StoreRtnConfirmParam.StoreRtnConfirmDetail();
            storeRtnConfirmDetail.setId(item.getId());
            storeRtnConfirmDetail.setItemCode(item.getItemCode());
            storeRtnConfirmDetail.setItemId(item.getItemId());
            storeRtnConfirmDetail.setQty(item.getOrderQty());
            details.add(storeRtnConfirmDetail);
        }
        storeRtnConfirmParam.setDetails(details);
        storeReceiveService.rtnConfirm(storeRtnConfirmParam);
        return ApiResult.ok();
    }


}
