package com.elitesland.scp.rmi;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.sale.dto.CrmCustDTO;
import com.elitesland.sale.service.CrmCustRpcService;
import lombok.NonNull;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @Auther: Mark
 * @Date: 2024/3/27 14:07
 * @Description:
 */
@Component
@Slf4j
@RequiredArgsConstructor
public class RmiCrmRpcService {

    private final CrmCustRpcService crmCustRpcService;

    /**
     * 查询客户数据信息,包含主客户信息
     *
     * @param custIds
     * @return
     */
    public ApiResult<List<CrmCustDTO>> listCustById(@NonNull List<Long> custIds) {
        try {
            ApiResult<List<CrmCustDTO>> listApiResult = crmCustRpcService.listCustById(custIds);
            return listApiResult;
        } catch (Exception e) {
            log.error("查询客户数据信息异常:{}", e);
            throw new BusinessException("查询客户数据信息接口异常", e);
        }
    }

    public ApiResult<CrmCustDTO> getCustInfo(String custCode) {
        log.info("查询客户信息入参：" + custCode);
        try {
            return crmCustRpcService.getCustInfo(custCode);
        } catch (Exception e) {
            log.error("调用销售支持中心，查询客户信息异常", e);
            throw new BusinessException("调用销售支持中心，查询客户信息异常" + e);
        }

    }
}
