/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.utils.excel;

import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.util.StyleUtil;
import com.alibaba.excel.write.handler.CellWriteHandler;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteTableHolder;
import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import com.alibaba.excel.write.metadata.style.WriteFont;
import com.elitesland.scp.utils.excel.ExcelTitleComments;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;

public class ExcelTitleHandler
implements CellWriteHandler {
    private final Short colorIndex;
    private List<Integer> columnIndexes;
    private Map<Integer, String> annotationsMap;

    public ExcelTitleHandler(Class<?> clazz) {
        this.colorIndex = IndexedColors.RED.index;
        this.columnIndexes = new ArrayList<Integer>();
        this.annotationsMap = new HashMap<Integer, String>();
        Field[] declaredFields = clazz.getDeclaredFields();
        for (int i = 0; i < declaredFields.length; ++i) {
            Field declaredField = declaredFields[i];
            ExcelTitleComments annotation = declaredField.getAnnotation(ExcelTitleComments.class);
            if (annotation == null) continue;
            this.columnIndexes.add(i);
            this.annotationsMap.put(i, annotation.value());
        }
    }

    public void beforeCellCreate(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, Row row, Head head, Integer columnIndex, Integer relativeRowIndex, Boolean isHead) {
    }

    public void afterCellCreate(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, Cell cell, Head head, Integer relativeRowIndex, Boolean isHead) {
    }

    public void afterCellDataConverted(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, CellData cellData, Cell cell, Head head, Integer integer, Boolean aBoolean) {
    }

    public void afterCellDispose(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, List<CellData> cellDataList, Cell cell, Head head, Integer relativeRowIndex, Boolean isHead) {
        if (isHead.booleanValue()) {
            Sheet sheet = writeSheetHolder.getSheet();
            sheet.setColumnWidth(cell.getColumnIndex(), 3584);
            writeSheetHolder.getSheet().getRow(0).setHeight((short)460);
            Workbook workbook = writeSheetHolder.getSheet().getWorkbook();
            Drawing drawing = sheet.createDrawingPatriarch();
            WriteCellStyle headWriteCellStyle = new WriteCellStyle();
            WriteFont headWriteFont = new WriteFont();
            headWriteFont.setFontName("\u5b8b\u4f53");
            headWriteFont.setFontHeightInPoints(Short.valueOf((short)14));
            headWriteFont.setBold(Boolean.valueOf(true));
            if (CollectionUtils.isNotEmpty(this.columnIndexes) && this.columnIndexes.contains(cell.getColumnIndex())) {
                headWriteFont.setColor(this.colorIndex);
            }
            headWriteCellStyle.setWriteFont(headWriteFont);
            headWriteCellStyle.setFillForegroundColor(Short.valueOf(IndexedColors.GREY_25_PERCENT.getIndex()));
            CellStyle cellStyle = StyleUtil.buildHeadCellStyle((Workbook)workbook, (WriteCellStyle)headWriteCellStyle);
            cell.setCellStyle(cellStyle);
            if (null != this.annotationsMap && this.annotationsMap.containsKey(cell.getColumnIndex())) {
                String context = this.annotationsMap.get(cell.getColumnIndex());
                Comment comment = drawing.createCellComment((ClientAnchor)new XSSFClientAnchor(0, 0, 0, 0, (int)((short)cell.getColumnIndex()), 0, (short)cell.getColumnIndex() + 3, 3));
                comment.setString((RichTextString)new XSSFRichTextString(context));
                cell.setCellComment(comment);
            }
        }
    }
}

