package com.elitesland.scp.application.facade.vo.param.authority;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
@ApiModel(value = "计划员权限按区域添加门店/仓库参数")
public class ScpManAuthorityWhStoreParamVO implements Serializable {
    private static final long serialVersionUID = 2751181606142479769L;

    /**
     * 主表id
     */
    @ApiModelProperty(name = "主表id")
    private Long masId;

    /**
     * 类型
     */
    @ApiModelProperty(name = "类型")
    private int type;

    /**
     * 门店id/仓库id
     */
    @ApiModelProperty(name = "门店id/仓库id")
    private Long stWhId;

    /**
     * 门店编码/仓库编码
     */
    @ApiModelProperty(name = "门店编码/仓库编码")
    private String stWhCode;

    /**
     * 门店名称/仓库名称
     */
    @ApiModelProperty(name = "门店名称/仓库名称")
    private String stWhName;

    @ApiModelProperty("区域编码")
    private String region;

    @ApiModelProperty(value = "权限来源，[UDC]yst-suplan:AUTH_SOURCE")
    private String authSource;
}
