package com.elitesland.scp.application.web.boh;

import cn.hutool.json.JSONUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.dto.account.AccountAmtFlowRpcVO;
import com.elitesland.fin.param.account.AccountAppRpcParam;
import com.elitesland.inv.dto.invTrn.StoreCanRtnQtyRpcDTO;
import com.elitesland.scp.application.facade.vo.boh.*;
import com.elitesland.scp.application.service.boh.StoreReceiveService;
import com.elitesland.support.provider.item.dto.ItmItemBaseRpcDTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

@Slf4j
@Api(tags = "门店收退货接口")
@RestController
@RequestMapping(value = "/applet/rt", produces = MediaType.APPLICATION_JSON_VALUE)
@RequiredArgsConstructor
public class StoreReceiveController {

    private final StoreReceiveService storeReceiveService;

    @ApiOperation(value = "分页查询")
    @PostMapping(value = "/page")
    public ApiResult<PagingVO<StoreReceivePageVO>> page(@RequestBody StoreReceivePageParam paramVO) {
        log.info("[SCP-RT] page  paramVO ={}", JSONUtil.toJsonStr(paramVO));
        return ApiResult.ok(storeReceiveService.page(paramVO));
    }

    @ApiOperation(value = "获取赔付商品")
    @GetMapping(value = "/getCompItem")
    public ApiResult<Map<String, Object>> getCompItem() {
        return ApiResult.ok(storeReceiveService.getCompItem());
    }

    @ApiOperation(value = "详情")
    @GetMapping(value = "/detail")
    public ApiResult<StoreReceiveDetailVO> detail(@RequestParam("docId") Long docId) {
        log.info("[SCP-RT] detail  paramVO ={}", docId);
        return ApiResult.ok(storeReceiveService.find(docId));
    }

    @ApiOperation(value = "收货确认")
    @PostMapping(value = "/receiveConfirm")
    public ApiResult receiveConfirm(@RequestBody StoreReceiveConfirmParam paramVO) {
        log.info("[SCP-RT] receiveConfirm  paramVO ={}", JSONUtil.toJsonStr(paramVO));
        storeReceiveService.receiveConfirm(paramVO);
        return ApiResult.ok();
    }

    @ApiOperation(value = "退货确认")
    @PostMapping(value = "/rtnConfirm")
    public ApiResult rtnConfirm(@RequestBody StoreRtnConfirmParam paramVO) {
        log.info("[SCP-RT] rtnConfirm  paramVO ={}", JSONUtil.toJsonStr(paramVO));
        storeReceiveService.rtnConfirm(paramVO);
        return ApiResult.ok();
    }

    @ApiOperation(value = "退货申请")
    @PostMapping(value = "/rtnApply")
    public ApiResult rtnApply(@RequestBody StoreRtnApplyParam paramVO) {
        log.info("[SCP-RT] rtnApply  paramVO ={}", JSONUtil.toJsonStr(paramVO));
        storeReceiveService.rtnApply(paramVO);
        return ApiResult.ok();
    }

    @ApiOperation(value = "可退货数量")
    @GetMapping(value = "/canRtn")
    public ApiResult<List<StoreCanRtnQtyRpcDTO>> canRtn(@RequestParam("docId") Long docId) {
        log.info("[SCP-RT] canRtn  paramVO ={}", docId);
        List<StoreCanRtnQtyRpcDTO> rpcDTOS = storeReceiveService.canRtn(docId);
        return ApiResult.ok(rpcDTOS);
    }

    @ApiOperation(value = "作废")
    @PostMapping(value = "/abort")
    public ApiResult abort(@RequestParam("docId") Long docId) {
        log.info("[SCP-RT] abort  paramVO ={}", docId);
        storeReceiveService.abort(docId);
        return ApiResult.ok();
    }

    @ApiOperation(value = "返回账户流水分组数据")
    @PostMapping(value = "/pageWithAccountFlow")
    public ApiResult<AccountAmtFlowRpcVO> pageWithAccountFlow(@RequestBody AccountAppRpcParam paramVO) {
        log.info("[SCP-DEMAND-ORDER] page  param ={}", JSONUtil.toJsonStr(paramVO));
        return ApiResult.ok(storeReceiveService.pageWithAccountFlow(paramVO));
    }


}
