package com.elitesland.scp.application.web.freight;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.freight.*;
import com.elitesland.scp.application.facade.vo.resp.freight.ScpStoreOrderFreightPageRespVO;
import com.elitesland.scp.application.service.freight.ScpStoreOrderFreightService;
import com.elitesland.scp.domain.entity.freight.ScpStoreOrderFreightDO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 门店订单运费接口
 * @author Rikyon
 * @version 1.0
 * @Create 2025/8/13
 */

@RestController
@RequestMapping(value = "/scp/storeOrderFreight", produces = MediaType.APPLICATION_JSON_VALUE)
@Api(value = "门店订单运费接口", tags = {"门店订单运费接口"})
@AllArgsConstructor
public class ScpStoreOrderFreightController {
    private final ScpStoreOrderFreightService scpStoreOrderFreightService;

    @PostMapping("/save")
    @ApiOperation("门店订单运费-新增/编辑")
    public ApiResult<ScpStoreOrderFreightDO> saveStoreOrderFreight (@RequestBody ScpStoreOrderFreightSaveParamVO createParam) {
        return ApiResult.ok(scpStoreOrderFreightService.saveStoreOrderFreight(createParam));
    }

    @PostMapping("/saveAll")
    @ApiOperation("门店订单运费-批量新增/编辑")
    public ApiResult<List<ScpStoreOrderFreightDO>> saveAllStoreOrderFreight (@RequestBody List<ScpStoreOrderFreightSaveParamVO> createParam) {
        return ApiResult.ok(scpStoreOrderFreightService.saveAllStoreOrderFreight(createParam));
    }

    @PostMapping("/delete")
    @ApiOperation("门店订单运费-删除")
    public ApiResult<Boolean> deleteStoreOrderFreight (@RequestBody ScpStoreOrderFreightSaveParamVO id) {
        scpStoreOrderFreightService.deleteStoreOrderFreight(id.getId());
        return ApiResult.ok();
    }

    @PostMapping("/page")
    @ApiOperation("门店订单运费-分页查询")
    public ApiResult<PagingVO<ScpStoreOrderFreightPageRespVO>> pageStoreOrderFreight (@RequestBody ScpStoreOrderFreightPageParamVO param) {
        return ApiResult.ok(scpStoreOrderFreightService.pageStoreOrderFreight(param));
    }
    @PostMapping("/list")
    @ApiOperation("运费模板-列表查询")
    public ApiResult<List<ScpStoreOrderFreightPageRespVO>> listStoreOrderFreight (@RequestBody ScpStoreOrderFreightPageParamVO param) {
        return ApiResult.ok(scpStoreOrderFreightService.listStoreOrderFreight(param));
    }

    @PostMapping("/freightBatchQuery")
    @ApiOperation("运费查询接口")
    public ApiResult<ScpStoreOrderFreightQuaryRespVO> freightBatchQuery (@RequestBody ScpStoreOrderFreightQuaryParamVO param) {
        return ApiResult.ok(scpStoreOrderFreightService.freightBatchQuery(param));
    }
    @PostMapping("/freightBatchQueryAll")
    @ApiOperation("运费批量查询接口")
    public ApiResult<List<ScpStoreOrderFreightQuaryRespVO>> freightBatchQueryAll (@RequestBody List<ScpStoreOrderFreightQuaryParamVO> param) {
        return ApiResult.ok(scpStoreOrderFreightService.freightBatchQueryAll(param));
    }
    @PostMapping("/getStoreOrderFreightDetail/{id}")
    @ApiOperation("门店订单运费-明细查询")
    public ApiResult<ScpStoreOrderFreightRespVO> getStoreOrderFreightDetail (@PathVariable String id) {
        Long id_ = Long.valueOf(id);
        return ApiResult.ok(scpStoreOrderFreightService.getStoreOrderFreightDetail(id_));
    }

    @PostMapping("/testImport")
    @ApiOperation("门店订单运费-新增/编辑")
    public ApiResult<List<String>> testImport (@RequestBody List<ScpStoreOrderFreightImportVO> scpStoreOrderFreightImportVOList) {
        return ApiResult.ok(scpStoreOrderFreightService.executeImport(scpStoreOrderFreightImportVOList,4));
    }


}
