package com.elitesland.scp.application.web.scpsman;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.scpsman.*;
import com.elitesland.scp.application.service.scpsman.ScpsmanInfoService;
import com.elitesland.scp.application.web.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * @Auther: Mark
 * @Date: 2024/3/18 17:18
 * @Description:
 */
@RestController
@RequestMapping(value = "/scpsmanInfo", produces = MediaType.APPLICATION_JSON_VALUE)
@Api(value = "计划员信息", tags = {"计划员信息"})
public class ScpsmanInfoController extends BaseController {

    @Autowired
    private ScpsmanInfoService scpsmanInfoService;
   /* @Autowired
    private SalesmanRpcServiceImpl salesmanRpcService;*/

    @PostMapping(value = "/save")
    @ApiOperation(value = "计划员信息保存更新")
    public ApiResult<Object> save(@RequestBody @Validated SalesmanInfoSaveVO salesmanInfoSaveVO) {
        return scpsmanInfoService.save(salesmanInfoSaveVO);
    }

    @PostMapping(value = "/query")
    @ApiOperation(value = "计划员信息查询")
    public ApiResult<PagingVO<SalesmanInfoRespVO>> query(@RequestBody SalesmanInfoQueryVO salesmanInfoQueryVO) {
        return scpsmanInfoService.query(salesmanInfoQueryVO);
    }

    @GetMapping(value = "/queryDetail/{id}")
    @ApiOperation(value = "计划员详情信息查询")
    public ApiResult<SalesmanInfoDetailRespVO> queryDetail(@PathVariable("id") Long id) {
        return scpsmanInfoService.queryDetail(id);
    }

    @PostMapping(value = "/changeStatus")
    @ApiOperation(value = "计划员信息状态更新")
    public ApiResult<Object> changeStatus(@RequestBody @Validated SalesmanInfoChangeVO salesmanInfoChangeVO) {
        return scpsmanInfoService.changeStatus(salesmanInfoChangeVO);
    }

    @PostMapping(value = "/querySubordinate")
    @ApiOperation(value = "业务员下级信息查询")
    public ApiResult<PagingVO<SalesmanInfoRespVO>> querySubordinate(@RequestBody SalesmanSubordinateQueryVO salesmanSubordinateQueryVO) {
        return scpsmanInfoService.querySubordinate(salesmanSubordinateQueryVO);
    }
    @PostMapping(value = "/test")
    @ApiOperation(value = "测试接口")
    public ApiResult test() {
        scpsmanInfoService.autoManInfo();
        return ApiResult.ok();
    }
}
