/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.authority;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.sale.api.vo.resp.crm.CustBaseDTO;
import com.elitesland.sale.dto.CustBaseInfoDTO;
import com.elitesland.scp.application.facade.vo.param.authority.ScpManAuthorityParam;
import com.elitesland.scp.application.facade.vo.resp.authority.ScpManAuthorityPageRespVO;
import com.elitesland.scp.application.facade.vo.resp.authority.ScpsmanAuthorityComponentVO;
import com.elitesland.scp.application.service.UserService;
import com.elitesland.scp.application.service.authority.ScpsmanAuthorityComponentService;
import com.elitesland.scp.common.CurrentUserDTO;
import com.elitesland.scp.domain.convert.authority.ScpDemandAuthorityConvert;
import com.elitesland.scp.domain.service.authority.ScpDemandAuthorityService;
import com.elitesland.scp.rmi.RmiOrgStoreRpcService;
import com.elitesland.scp.rmi.RmiSalRpcService;
import com.elitesland.support.provider.org.dto.OrgStoreBaseRpcDTO;
import com.elitesland.support.provider.org.dto.OrgStoreDetailRpcDTO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ScpsmanAuthprityComponentImportImpl
implements ScpsmanAuthorityComponentService {
    private static final Logger log = LoggerFactory.getLogger(ScpsmanAuthprityComponentImportImpl.class);
    private final ScpDemandAuthorityService scpDemandAuthorityService;
    private final RmiOrgStoreRpcService rmiOrgStoreRpcService;
    private final RmiSalRpcService rmiSalRpcService;

    @Override
    @SysCodeProc
    public PagingVO<ScpsmanAuthorityComponentVO> salemansAuthorityComponentPage(ScpManAuthorityParam paramVO) {
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        if (ObjectUtil.isEmpty((Object)currentUserDTO)) {
            throw new BusinessException("\u5f53\u524d\u767b\u5f55\u4eba\u67e5\u8be2\u5f02\u5e38");
        }
        paramVO.setLoginAccount(currentUserDTO.getDetail().getUsername());
        PagingVO<ScpManAuthorityPageRespVO> scpManAuthorityPageRespVOPagingVO = this.scpDemandAuthorityService.queryAuthorit(paramVO);
        if (scpManAuthorityPageRespVOPagingVO.isEmpty()) {
            return PagingVO.builder().total(0L).records(null).build();
        }
        List collect = scpManAuthorityPageRespVOPagingVO.stream().map(ScpDemandAuthorityConvert.INSTANCE::pageVoToComponentVo).collect(Collectors.toList());
        List<String> storeCodeList = collect.stream().filter(t -> ObjectUtil.isNotNull((Object)t.getStWhCode())).map(ScpsmanAuthorityComponentVO::getStWhCode).distinct().collect(Collectors.toList());
        Map<String, OrgStoreBaseRpcDTO> storeMap = this.rmiOrgStoreRpcService.getOrgStoreBaseMap(storeCodeList);
        collect.stream().forEach(t -> {
            OrgStoreBaseRpcDTO orgStoreRpcDTO = (OrgStoreBaseRpcDTO)storeMap.get(t.getStWhCode());
            t.setStoreType2(orgStoreRpcDTO.getStoreType2());
            t.setStCustCode(orgStoreRpcDTO.getCustCode());
            t.setStCustName(orgStoreRpcDTO.getCustName());
            t.setStWhName(orgStoreRpcDTO.getStoreName());
            t.setBrandCode(orgStoreRpcDTO.getBrandCode());
            t.setStoreOuCode(orgStoreRpcDTO.getOuCode());
            t.setDailyFlag(orgStoreRpcDTO.getDailyFlag());
            t.setPreDailyFlag(orgStoreRpcDTO.getPreDailyFlag());
        });
        return PagingVO.builder().total(scpManAuthorityPageRespVOPagingVO.getTotal()).records(collect).build();
    }

    @Override
    public ScpsmanAuthorityComponentVO appQuery(ScpManAuthorityParam paramVO) {
        paramVO.setType(0L);
        PagingVO<ScpsmanAuthorityComponentVO> scpManAuthorityPageRespVOPagingVO = this.salemansAuthorityComponentPage(paramVO);
        if (scpManAuthorityPageRespVOPagingVO.isNotEmpty()) {
            ScpsmanAuthorityComponentVO scpsmanAuthorityComponentVO = (ScpsmanAuthorityComponentVO)scpManAuthorityPageRespVOPagingVO.getRecords().get(0);
            this.storeTypeQuery(scpsmanAuthorityComponentVO);
            return scpsmanAuthorityComponentVO;
        }
        return null;
    }

    private void storeTypeQuery(ScpsmanAuthorityComponentVO scpsmanAuthorityComponentVO) {
        List<CustBaseDTO> custBaseInfoDTOList;
        if (Objects.isNull(scpsmanAuthorityComponentVO)) {
            return;
        }
        OrgStoreDetailRpcDTO byCode = this.rmiOrgStoreRpcService.getByCode(scpsmanAuthorityComponentVO.getStWhCode());
        if (Objects.nonNull(byCode)) {
            scpsmanAuthorityComponentVO.setStoreType2(byCode.getStoreType2());
            scpsmanAuthorityComponentVO.setStoreType2Name(byCode.getStoreType2Name());
            scpsmanAuthorityComponentVO.setStoreOuCode(byCode.getOuCode());
            if (StringUtils.isBlank((CharSequence)scpsmanAuthorityComponentVO.getStCustCode())) {
                scpsmanAuthorityComponentVO.setStCustCode(byCode.getCustCode());
                scpsmanAuthorityComponentVO.setStCustName(byCode.getCustName());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)scpsmanAuthorityComponentVO.getStCustCode()) && CollectionUtil.isNotEmpty(custBaseInfoDTOList = this.rmiSalRpcService.findBaseByParam(Collections.singletonList(scpsmanAuthorityComponentVO.getStCustCode())))) {
            List<CustBaseInfoDTO> custBaseInfoDTOS;
            CustBaseDTO custBaseInfoDTO = custBaseInfoDTOList.get(0);
            scpsmanAuthorityComponentVO.setStoreCustCode(custBaseInfoDTO.getPreCustCode());
            if (StringUtils.isNotBlank((CharSequence)scpsmanAuthorityComponentVO.getStoreCustCode()) && CollectionUtil.isNotEmpty(custBaseInfoDTOS = this.rmiSalRpcService.getCustBaseInfoByCode(Collections.singletonList(scpsmanAuthorityComponentVO.getStoreCustCode())))) {
                CustBaseInfoDTO custBaseInfoDTO1 = custBaseInfoDTOS.get(0);
                scpsmanAuthorityComponentVO.setStoreCustName(custBaseInfoDTO1.getCustName());
                if (Objects.equals(custBaseInfoDTO1.getCustType2(), "A")) {
                    scpsmanAuthorityComponentVO.setStoreCustType2Flag(true);
                }
            }
        }
    }

    @Override
    public List<String> loginAndTypeQuery(ScpManAuthorityParam paramVO) {
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        if (ObjectUtil.isEmpty((Object)currentUserDTO)) {
            throw new BusinessException("\u5f53\u524d\u767b\u5f55\u4eba\u67e5\u8be2\u5f02\u5e38");
        }
        paramVO.setLoginAccount(currentUserDTO.getDetail().getUsername());
        paramVO.setEnableStatus(true);
        List<ScpManAuthorityPageRespVO> scpManAuthorityPageRespVOPagingVO = this.scpDemandAuthorityService.listQuery(paramVO);
        if (CollUtil.isEmpty(scpManAuthorityPageRespVOPagingVO)) {
            return new ArrayList<String>();
        }
        return scpManAuthorityPageRespVOPagingVO.stream().map(ScpManAuthorityPageRespVO::getStWhCode).collect(Collectors.toList());
    }

    public ScpsmanAuthprityComponentImportImpl(ScpDemandAuthorityService scpDemandAuthorityService, RmiOrgStoreRpcService rmiOrgStoreRpcService, RmiSalRpcService rmiSalRpcService) {
        this.scpDemandAuthorityService = scpDemandAuthorityService;
        this.rmiOrgStoreRpcService = rmiOrgStoreRpcService;
        this.rmiSalRpcService = rmiSalRpcService;
    }
}

