/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.web.stock;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.stock.ScpPredictStStockCalcPageParam;
import com.elitesland.scp.application.facade.vo.stock.ScpPredictStStockCalcPageVO;
import com.elitesland.scp.application.facade.vo.stock.ScpPredictStStockCalcParamVO;
import com.elitesland.scp.application.facade.vo.stock.ScpPredictStStockDownLoadParam;
import com.elitesland.scp.application.facade.vo.stock.ScpPredictStStockDownloadVO;
import com.elitesland.scp.application.facade.vo.stock.ScpPredictStStockParamVO;
import com.elitesland.scp.application.facade.vo.stock.ScpPredictStStockRespVO;
import com.elitesland.scp.application.service.stock.ScpPredictStStockCalcService;
import com.elitesland.scp.utils.excel.ExcelWriteUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u9884\u6d4b\u6279\u6b21-\u5b89\u5168\u5e93\u5b58&&\u76ee\u6807\u5e93\u5b58"})
@RestController
@RequestMapping(value={"/predict-st-stock-calc"})
@Validated
public class ScpPredictStStockCalcController {
    private static final Logger log = LoggerFactory.getLogger(ScpPredictStStockCalcController.class);
    private final ScpPredictStStockCalcService scpPredictStStockCalcService;

    @ApiOperation(value="\u9884\u6d4b\u6279\u6b21\u5217\u8868")
    @PostMapping(value={"/page"})
    public ApiResult<PagingVO<ScpPredictStStockCalcPageVO>> page(@RequestBody ScpPredictStStockCalcPageParam param) {
        return ApiResult.ok(this.scpPredictStStockCalcService.page(param));
    }

    @ApiOperation(value="\u9884\u6d4b\u6279\u6b21\u8be6\u60c5")
    @PostMapping(value={"/page/detail"})
    public ApiResult<PagingVO<ScpPredictStStockRespVO>> pageDetail(@Valid @RequestBody ScpPredictStStockParamVO param) {
        return ApiResult.ok(this.scpPredictStStockCalcService.stStockDetailPage(param));
    }

    @ApiOperation(value="\u9884\u6d4b\u6279\u6b21-\u5220\u9664")
    @PostMapping(value={"/delete"})
    public ApiResult<?> delete(@RequestBody List<Long> ids) {
        this.scpPredictStStockCalcService.delete(ids);
        return ApiResult.ok();
    }

    @ApiOperation(value="\u9884\u6d4b\u6279\u6b21\u8ba1\u7b97")
    @PostMapping(value={"/calc"})
    public ApiResult<String> calc(@RequestBody ScpPredictStStockCalcParamVO param) {
        return ApiResult.ok((Object)this.scpPredictStStockCalcService.calcPredictStStock(param));
    }

    @PostMapping(value={"/download"})
    @ApiOperation(value="\u5bfc\u5165\u6a21\u7248\u4e0b\u8f7d\u5bfc\u51fa")
    public void download(HttpServletResponse response, @RequestBody ScpPredictStStockDownLoadParam param) throws IOException {
        List<ScpPredictStStockDownloadVO> ret = this.scpPredictStStockCalcService.downloadTmplFile(param);
        ExcelWriteUtil.autoPredictStStockAliasExcelWrite(response, ret, ScpPredictStStockDownloadVO.class, "\u9884\u6d4b\u5b89\u5168\u5e93\u5b58&\u76ee\u7684\u5e93\u5b58\u5bfc\u5165\u6a21\u7248", "\u5b89\u5168\u5e93\u5b58&\u76ee\u7684\u5e93\u5b58\u5bfc\u5165\u6a21\u7248");
    }

    public ScpPredictStStockCalcController(ScpPredictStStockCalcService scpPredictStStockCalcService) {
        this.scpPredictStStockCalcService = scpPredictStStockCalcService;
    }
}

