package com.elitesland.scp.application.facade.vo.supalloc;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author jeesie
 * @description:
 * @datetime 2024年 03月 20日 16:27
 * @version: 1.0
 */
@Data
@ApiModel("供应商份额分配返回结果")
public class ScpSupplyAllocationResultVO implements Serializable {

    @ApiModelProperty(value = "供应仓库结果")
    private List<ScpSupplyAllocationResultVO.ResultVO> successList;

    @ApiModelProperty(value = "供应仓库失败结果")
    private List<ScpSupplyAllocationResultVO.ResultVO> failList;

    @Data
    public static class ResultVO implements Serializable {

        @ApiModelProperty(value = "供应仓库id")
        @JsonSerialize(using = ToStringSerializer.class)
        private Long suppId;

        @ApiModelProperty(value = "供应商编码")
        private String suppCode;

        @ApiModelProperty(value = "供应商名称")
        private String suppName;

        @ApiModelProperty(value = "类型")
        private String type;

        @ApiModelProperty(value = "门店id/门店仓库id")
        @JsonSerialize(using = ToStringSerializer.class)
        private Long storeWhId;

        @ApiModelProperty(value = "仓库编码/门店编码")
        private String storeWhCode;

        @ApiModelProperty(value = "商品品类编码")
        private String itemCateCode;

        @ApiModelProperty(value = "商品品类名称")
        private String itemCateName;

        @ApiModelProperty(value = "商品id")
        @JsonSerialize(using = ToStringSerializer.class)
        private Long itemId;

        @ApiModelProperty(value = "商品编码")
        private String itemCode;

        @ApiModelProperty(value = "商品名称")
        private String itemName;

        @ApiModelProperty(value = "配额")
        private BigDecimal allocation;

        @ApiModelProperty(value = "最小订货量")
        private BigDecimal minimumOrderQuantity;

        @ApiModelProperty(value = "采购提前期")
        private BigDecimal purchaseLeadTime;

        @ApiModelProperty(value = "行号")
        private int lineNo;

    }
}
