/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.pay.service;

import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.context.TenantContextHolder;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.mq.MessageQueueTemplate;
import com.elitescloud.boot.provider.TenantDataIsolateProvider;
import com.elitescloud.boot.tenant.client.common.TenantClient;
import com.elitescloud.boot.wrapper.RedisWrapper;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitesland.fin.param.recorder.WeChatPayRecOrderRpcParam;
import com.elitesland.inv.dto.invTro.InvTroOnlinePayParamDTO;
import com.elitesland.pur.dto.po.PurPoOnlinePayParamDTO;
import com.elitesland.scp.application.facade.vo.param.order.ScpOrderPayMqParam;
import com.elitesland.scp.domain.entity.wqf.ScpWqfEntAccountApplyDO;
import com.elitesland.scp.domain.entity.wqf.ScpWqfEntAccountDO;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.enums.UdcEnum;
import com.elitesland.scp.infr.dto.wqf.ScpWqfEntAccountApplyDDTO;
import com.elitesland.scp.infr.repo.order.ScpDemandOrderDRepoProc;
import com.elitesland.scp.infr.repo.wqf.ScpWqfEntAccountApplyDRepoProc;
import com.elitesland.scp.infr.repo.wqf.ScpWqfEntAccountApplyRepo;
import com.elitesland.scp.infr.repo.wqf.ScpWqfEntAccountApplyRepoProc;
import com.elitesland.scp.infr.repo.wqf.ScpWqfEntAccountRepoProc;
import com.elitesland.scp.pay.config.EntpayProperties;
import com.elitesland.scp.pay.service.NotifyVerifyService;
import com.elitesland.scp.pay.vo.AccountBindNotifyModel;
import com.elitesland.scp.pay.vo.PayNoficeParamVO;
import com.elitesland.scp.rmi.RmiFinRpcService;
import com.elitesland.scp.rmi.RmiInvStkRpcService;
import com.elitesland.scp.rmi.RmiPurRpcService;
import com.elitesland.scp.utils.MessageDelyQueueService;
import com.elitesland.scp.utils.SysUtils;
import com.tenpay.business.entpay.mse.sdk.api.AccountBatchBind;
import com.tenpay.business.entpay.mse.sdk.api.Payment;
import com.tenpay.business.entpay.mse.sdk.exception.EntpayException;
import com.tenpay.business.entpay.mse.sdk.model.BindAccountDetail;
import com.tenpay.business.entpay.mse.sdk.model.PaymentNotifyModel;
import com.tenpay.business.entpay.mse.sdk.model.RefundNotifyModel;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import org.apache.commons.collections.CollectionUtils;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class NotifyVerifyServiceImpl
implements NotifyVerifyService {
    private static final Logger log = LoggerFactory.getLogger(NotifyVerifyServiceImpl.class);
    private final RedisWrapper redisWrapper;
    private final RedisTemplate<Object, Object> redisTemplate;
    private final EntityManager entityManager;
    private final RmiPurRpcService rmiPurRpcService;
    private final RmiFinRpcService rmiFinRpcService;
    private final RmiInvStkRpcService rmiInvStkRpcService;
    private final MessageDelyQueueService messageDelyQueueService;
    private final ScpDemandOrderDRepoProc scpDemandOrderDRepoProc;
    private final MessageQueueTemplate messageQueueTemplate;
    private final ScpWqfEntAccountApplyRepo scpWqfEntAccountApplyRepo;
    private final ScpWqfEntAccountApplyRepoProc scpWqfEntAccountApplyRepoProc;
    private final ScpWqfEntAccountApplyDRepoProc scpWqfEntAccountApplyRepoDProc;
    private final TenantDataIsolateProvider tenantDataIsolateProvider;
    private final TransactionTemplate transactionTemplate;
    private final ScpWqfEntAccountRepoProc scpWqfEntAccountRepoProc;
    private final RedissonClient redissonClient;

    @Override
    public void processNotify(PaymentNotifyModel notifyData) throws EntpayException {
        Payment eventContent = notifyData.getEventContent();
        String outPaymentId = eventContent.getOutPaymentId();
        Payment payment = Payment.retrieveByOutPaymentId((String)outPaymentId);
        if (!"SUCCEEDED".equals(payment.getPayStatus())) {
            log.info("\u652f\u4ed8\u72b6\u6001\u3010{}\u3011\uff0c\u4e0d\u5904\u7406\uff0coutPaymentId:{}", (Object)payment.getPayStatus(), (Object)outPaymentId);
            return;
        }
        EntpayProperties entpayProperties = Optional.ofNullable(this.redisWrapper.apply(() -> this.redisTemplate.opsForValue().get((Object)"ENT_PAY_PROPERTIES"), null)).map(Object::toString).map(o -> (EntpayProperties)JSONUtil.toBean((String)o, EntpayProperties.class)).orElseThrow(() -> new BusinessException("\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u5fae\u4f01\u4ed8\u4fe1\u606f"));
        this.tenantDataIsolateProvider.byTenantDirectly(() -> {
            TenantContextHolder.setCurrentTenant((SysTenantDTO)TenantClient.getSessionTenant());
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            if ("PO".equals(outPaymentId.substring(0, 2))) {
                PurPoOnlinePayParamDTO purPoOnlinePayParamDTO = new PurPoOnlinePayParamDTO();
                purPoOnlinePayParamDTO.setOnlinePayFlag(Boolean.TRUE);
                purPoOnlinePayParamDTO.setDocNo(outPaymentId);
                purPoOnlinePayParamDTO.setOnlinePayTime(LocalDateTime.parse(eventContent.getPayTime(), formatter));
                this.rmiPurRpcService.updateOnlinePay(purPoOnlinePayParamDTO);
            } else {
                InvTroOnlinePayParamDTO invTroOnlinePayParamDTO = new InvTroOnlinePayParamDTO();
                invTroOnlinePayParamDTO.setDocNo(outPaymentId);
                invTroOnlinePayParamDTO.setOnlinePayTime(LocalDateTime.parse(eventContent.getPayTime(), formatter));
                invTroOnlinePayParamDTO.setOnlinePayFlag(Boolean.TRUE);
                this.rmiInvStkRpcService.updateOnlinePay(invTroOnlinePayParamDTO);
            }
            String key = "SCP_ONLINE_PAY:" + outPaymentId;
            if (this.redisTemplate.delete((Object)key).booleanValue()) {
                this.messageDelyQueueService.remove(key);
                this.transactionTemplate.setPropagationBehavior(3);
                this.transactionTemplate.execute(transactionStatus -> {
                    try {
                        this.scpDemandOrderDRepoProc.updatePayStatusBySrcDocId(outPaymentId, ScpUdcEnum.PAY_STATUS_PAYING.getValueCode());
                        return "ok";
                    }
                    catch (Exception e) {
                        log.error("\u66f4\u65b0\u8981\u8d27\u5355\u51fa\u9519:{}", (Object)e.getMessage(), (Object)e);
                        transactionStatus.setRollbackOnly();
                        return "ok";
                    }
                });
                ScpOrderPayMqParam orderSubmitMqParam = new ScpOrderPayMqParam();
                orderSubmitMqParam.setSrcDocNo(outPaymentId);
                orderSubmitMqParam.setFlowNo(eventContent.getPaymentId());
                orderSubmitMqParam.setBusinessKey("scp_order_pay");
                orderSubmitMqParam.setPayDateTime(LocalDateTime.parse(eventContent.getPayTime(), formatter));
                BigDecimal amt = SysUtils.processAmtScale(new BigDecimal(eventContent.getAmount()).divide(new BigDecimal(100)));
                orderSubmitMqParam.setRealRecAmt(amt);
                this.messageQueueTemplate.publishMessageSync("yst-suplan", "scp_order_pay", (Serializable)orderSubmitMqParam);
            } else {
                log.error("\u4e0d\u80fd\u91cd\u590d\u8c03\u7528\u652f\u4ed8\u56de\u8c03");
            }
            return "";
        }, entpayProperties.getTenantCode());
    }

    @Override
    public void processRefundNotify(RefundNotifyModel notifyData) {
    }

    @Override
    public void devopsPayNotify(PayNoficeParamVO paramVO) throws EntpayException {
        String outPaymentId = paramVO.getOutPaymentId();
        Payment payment = Payment.retrieveByOutPaymentId((String)outPaymentId);
        if (!"SUCCEEDED".equals(payment.getPayStatus())) {
            log.info("\u652f\u4ed8\u72b6\u6001\u4e0d\u662f\u6210\u529f\uff0c\u4e0d\u5904\u7406\uff0coutPaymentId:{}", (Object)outPaymentId);
            return;
        }
        EntpayProperties entpayProperties = Optional.ofNullable(this.redisWrapper.apply(() -> this.redisTemplate.opsForValue().get((Object)"ENT_PAY_PROPERTIES"), null)).map(Object::toString).map(o -> (EntpayProperties)JSONUtil.toBean((String)o, EntpayProperties.class)).orElseThrow(() -> new BusinessException("\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u5fae\u4f01\u4ed8\u4fe1\u606f"));
        SysTenantDTO sysTenantDTO = TenantClient.getTenant((String)entpayProperties.getTenantCode());
        TenantContextHolder.setCurrentTenant((SysTenantDTO)sysTenantDTO);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        if ("PO".equals(outPaymentId.substring(0, 2))) {
            PurPoOnlinePayParamDTO purPoOnlinePayParamDTO = new PurPoOnlinePayParamDTO();
            purPoOnlinePayParamDTO.setOnlinePayFlag(Boolean.TRUE);
            purPoOnlinePayParamDTO.setDocNo(outPaymentId);
            purPoOnlinePayParamDTO.setOnlinePayTime(LocalDateTime.parse(paramVO.getPayTime(), formatter));
            this.rmiPurRpcService.updateOnlinePay(purPoOnlinePayParamDTO);
        } else {
            InvTroOnlinePayParamDTO invTroOnlinePayParamDTO = new InvTroOnlinePayParamDTO();
            invTroOnlinePayParamDTO.setDocNo(outPaymentId);
            invTroOnlinePayParamDTO.setOnlinePayTime(LocalDateTime.parse(paramVO.getPayTime(), formatter));
            invTroOnlinePayParamDTO.setOnlinePayFlag(Boolean.TRUE);
            this.rmiInvStkRpcService.updateOnlinePay(invTroOnlinePayParamDTO);
        }
        this.redisTemplate.delete((Object)("SCP_ONLINE_PAY:" + outPaymentId));
        this.messageDelyQueueService.remove("SCP_ONLINE_PAY:" + outPaymentId);
        WeChatPayRecOrderRpcParam payParam = new WeChatPayRecOrderRpcParam();
        payParam.setSourceNo(outPaymentId);
        payParam.setFlowNo(paramVO.getPaymentId());
        payParam.setRealRecAmt(new BigDecimal(paramVO.getAmount() / 100L));
        payParam.setPayDateTime(LocalDateTime.parse(paramVO.getPayTime(), formatter));
        this.rmiFinRpcService.wqfPay(payParam);
    }

    @Override
    public void processAccountBindNotify(AccountBindNotifyModel notifyData) throws EntpayException {
        AccountBatchBind eventContent = notifyData.getEventContent();
        String outRequestNo = eventContent.getOutRequestNo();
        EntpayProperties entpayProperties = Optional.ofNullable(this.redisWrapper.apply(() -> this.redisTemplate.opsForValue().get((Object)"ENT_PAY_PROPERTIES"), null)).map(Object::toString).map(o -> (EntpayProperties)JSONUtil.toBean((String)o, EntpayProperties.class)).orElseThrow(() -> new BusinessException("\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u5fae\u4f01\u4ed8\u4fe1\u606f"));
        AccountBatchBind accountBatchBind = AccountBatchBind.retrieveByOutRequestNo((String)outRequestNo);
        String lockKey = String.format("accountBind:lock:%s", outRequestNo);
        RLock lock = this.redissonClient.getLock(lockKey);
        try {
            if (lock.tryLock(300L, 180L, TimeUnit.SECONDS)) {
                this.tenantDataIsolateProvider.byTenantDirectly(() -> {
                    TenantContextHolder.setCurrentTenant((SysTenantDTO)TenantClient.getSessionTenant());
                    List<ScpWqfEntAccountApplyDO> accountApplyDOS = this.scpWqfEntAccountApplyRepoProc.findAllByDocNo(outRequestNo);
                    if (CollectionUtils.isEmpty(accountApplyDOS)) {
                        log.error("\u6279\u91cf\u7ed1\u5b9a\u8d26\u6237\u5931\u8d25\uff0c\u672a\u67e5\u8be2\u5230\u4e2d\u53f0\u5173\u8054\u7533\u8bf7\u5355\u53f7\uff0c\u4e0d\u5904\u7406\uff0coutRequestNo:{}", (Object)outRequestNo);
                        return "";
                    }
                    List<ScpWqfEntAccountDO> wqfEntAccountDOS = this.scpWqfEntAccountRepoProc.findByApplyNo(outRequestNo);
                    this.transactionTemplate.setPropagationBehavior(3);
                    this.transactionTemplate.execute(transactionStatus -> {
                        try {
                            List<ScpWqfEntAccountApplyDDTO> bindNotifyDetail;
                            ScpWqfEntAccountApplyDO accountApplyDO = (ScpWqfEntAccountApplyDO)accountApplyDOS.get(0);
                            if (!"SUCCESS".equals(accountBatchBind.getStatus())) {
                                log.info("\u6279\u91cf\u7ed1\u5b9a\u8d26\u6237\u5931\u8d25\u3010{}\u3011\uff0c\u4e0d\u5904\u7406\uff0coutRequestNo:{}", (Object)accountBatchBind.getStatus(), (Object)outRequestNo);
                                accountApplyDO.setDocNo(accountBatchBind.getOutRequestNo());
                                accountApplyDO.setApplyStatus(UdcEnum.WQF_APPLY_STATUS_FAIL.getValueCode());
                                accountApplyDO.setErrorMsg(accountBatchBind.getFailReason());
                                this.scpWqfEntAccountApplyRepo.save(accountApplyDO);
                                return "";
                            }
                            List<String> accounts = accountBatchBind.getAccounts().stream().map(BindAccountDetail::getBankAccountNumber).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                            if (CollectionUtils.isNotEmpty((Collection)wqfEntAccountDOS)) {
                                List exists = wqfEntAccountDOS.stream().map(ScpWqfEntAccountDO::getBankAccount).collect(Collectors.toList());
                                if (CollectionUtils.isEmpty(accounts = accounts.stream().filter(d -> !exists.contains(d)).collect(Collectors.toList()))) {
                                    log.info("\u6279\u91cf\u7ed1\u5b9a\u8d26\u6237\u5931\u8d25\u3010{}\u3011\uff0c\u4e0d\u5904\u7406\uff0coutRequestNo:{},\u5df2\u5b58\u5728\u4e2d\u53f0\u8d26\u6237", (Object)accountBatchBind.getStatus(), (Object)outRequestNo);
                                    accountApplyDO.setDocNo(accountBatchBind.getOutRequestNo());
                                    accountApplyDO.setApplyStatus(UdcEnum.WQF_APPLY_STATUS_FAIL.getValueCode());
                                    accountApplyDO.setErrorMsg(String.format("\u6279\u91cf\u7ed1\u5b9a\u8d26\u6237\u5931\u8d25\u3010{%s}\u3011\uff0c\u4e0d\u5904\u7406\uff0coutRequestNo:{%s},\u5df2\u5b58\u5728\u4e2d\u53f0\u8d26\u6237", accountBatchBind.getStatus(), outRequestNo));
                                    this.scpWqfEntAccountApplyRepo.save(accountApplyDO);
                                    return "";
                                }
                            }
                            if (CollectionUtils.isEmpty(bindNotifyDetail = this.scpWqfEntAccountApplyRepoDProc.findAccountBindNotifyDetail(accountBatchBind.getOutRequestNo(), accounts))) {
                                log.info("\u6279\u91cf\u7ed1\u5b9a\u8d26\u6237\u5931\u8d25\u3010{}\u3011\uff0c\u4e0d\u5904\u7406\uff0coutRequestNo:{},\u672a\u67e5\u8be2\u5230\u7b26\u5408\u8d26\u6237\u660e\u7ec6", (Object)accountBatchBind.getStatus(), (Object)outRequestNo);
                                accountApplyDO.setDocNo(accountBatchBind.getOutRequestNo());
                                accountApplyDO.setApplyStatus(UdcEnum.WQF_APPLY_STATUS_FAIL.getValueCode());
                                accountApplyDO.setErrorMsg(String.format("\u6279\u91cf\u7ed1\u5b9a\u8d26\u6237\u5931\u8d25\u3010%s\u3011\uff0c\u4e0d\u5904\u7406\uff0coutRequestNo:%s,\u672a\u67e5\u8be2\u5230\u7b26\u5408\u4e2d\u53f0\u8d26\u6237\u660e\u7ec6", accountBatchBind.getStatus(), outRequestNo));
                                this.scpWqfEntAccountApplyRepo.save(accountApplyDO);
                                return "";
                            }
                            accountApplyDO.setDocNo(accountBatchBind.getOutRequestNo());
                            accountApplyDO.setApplyStatus(UdcEnum.WQF_APPLY_STATUS_SUCESS.getValueCode());
                            Map<String, ScpWqfEntAccountApplyDDTO> accountApplyDMap = bindNotifyDetail.stream().collect(Collectors.toMap(ScpWqfEntAccountApplyDDTO::getBankAccount, v -> v, (v1, v2) -> v1));
                            ArrayList<ScpWqfEntAccountDO> saveList = new ArrayList<ScpWqfEntAccountDO>();
                            for (BindAccountDetail accountDetail : accountBatchBind.getAccounts()) {
                                ScpWqfEntAccountApplyDDTO accountApplyDDTO = accountApplyDMap.get(accountDetail.getBankAccountNumber());
                                if (accountApplyDDTO == null) continue;
                                ScpWqfEntAccountDO scpWqfEntAccountDO = new ScpWqfEntAccountDO();
                                scpWqfEntAccountDO.setApplyNo(outRequestNo);
                                scpWqfEntAccountDO.setStoreId(accountApplyDDTO.getStoreId());
                                scpWqfEntAccountDO.setStoreCode(accountApplyDDTO.getStoreCode());
                                scpWqfEntAccountDO.setOuId(accountApplyDDTO.getOuId());
                                scpWqfEntAccountDO.setOuCode(accountApplyDDTO.getOuCode());
                                scpWqfEntAccountDO.setEntId(accountApplyDO.getEntId());
                                scpWqfEntAccountDO.setEntAcctId(accountDetail.getEntAcctId());
                                scpWqfEntAccountDO.setAccountType(accountApplyDDTO.getAccountType());
                                scpWqfEntAccountDO.setBankAccount(accountDetail.getBankAccountNumber());
                                scpWqfEntAccountDO.setOpenBank(accountApplyDDTO.getOpenBank());
                                scpWqfEntAccountDO.setBranchName(accountApplyDDTO.getBranchName());
                                scpWqfEntAccountDO.setEntAcctId(accountDetail.getEntAcctId());
                                scpWqfEntAccountDO.setBankBranchCode(accountApplyDDTO.getBankBranchCode());
                                scpWqfEntAccountDO.setBranchName(accountApplyDDTO.getBranchName());
                                scpWqfEntAccountDO.setStatus(Boolean.TRUE);
                                saveList.add(scpWqfEntAccountDO);
                            }
                            log.info("\u6279\u91cf\u7ed1\u5b9a\u8d26\u6237\u6210\u529f\uff0coutRequestNo:{},saveList:{}", (Object)outRequestNo, saveList);
                            if (CollectionUtils.isNotEmpty(saveList)) {
                                this.batchInsert(saveList);
                            }
                            accountApplyDO.setErrorMsg(null);
                            this.scpWqfEntAccountApplyRepo.save(accountApplyDO);
                            return "ok";
                        }
                        catch (Exception e) {
                            log.error("\u66f4\u65b0\u8981\u8d27\u5355\u51fa\u9519:{}", (Object)e.getMessage(), (Object)e);
                            transactionStatus.setRollbackOnly();
                            return "ok";
                        }
                    });
                    return "";
                }, entpayProperties.getTenantCode());
            }
        }
        catch (BusinessException | InterruptedException e) {
            log.error("accountBind lock error:", e);
            throw new BusinessException(e.getMessage());
        }
        finally {
            if (lock.isLocked() && lock.isHeldByCurrentThread()) {
                lock.unlock();
                log.info("accountBind unlock success,lockKey:{}", (Object)lockKey);
            }
        }
    }

    public void batchInsert(List<ScpWqfEntAccountDO> dataList) {
        int index = 0;
        int batchSize = 100;
        for (ScpWqfEntAccountDO data : dataList) {
            this.entityManager.persist((Object)data);
            if (batchSize <= 1 || ++index % batchSize != 0) continue;
            this.entityManager.flush();
            this.entityManager.clear();
        }
        if (!dataList.isEmpty()) {
            this.entityManager.flush();
        }
    }

    public NotifyVerifyServiceImpl(RedisWrapper redisWrapper, RedisTemplate<Object, Object> redisTemplate, EntityManager entityManager, RmiPurRpcService rmiPurRpcService, RmiFinRpcService rmiFinRpcService, RmiInvStkRpcService rmiInvStkRpcService, MessageDelyQueueService messageDelyQueueService, ScpDemandOrderDRepoProc scpDemandOrderDRepoProc, MessageQueueTemplate messageQueueTemplate, ScpWqfEntAccountApplyRepo scpWqfEntAccountApplyRepo, ScpWqfEntAccountApplyRepoProc scpWqfEntAccountApplyRepoProc, ScpWqfEntAccountApplyDRepoProc scpWqfEntAccountApplyRepoDProc, TenantDataIsolateProvider tenantDataIsolateProvider, TransactionTemplate transactionTemplate, ScpWqfEntAccountRepoProc scpWqfEntAccountRepoProc, RedissonClient redissonClient) {
        this.redisWrapper = redisWrapper;
        this.redisTemplate = redisTemplate;
        this.entityManager = entityManager;
        this.rmiPurRpcService = rmiPurRpcService;
        this.rmiFinRpcService = rmiFinRpcService;
        this.rmiInvStkRpcService = rmiInvStkRpcService;
        this.messageDelyQueueService = messageDelyQueueService;
        this.scpDemandOrderDRepoProc = scpDemandOrderDRepoProc;
        this.messageQueueTemplate = messageQueueTemplate;
        this.scpWqfEntAccountApplyRepo = scpWqfEntAccountApplyRepo;
        this.scpWqfEntAccountApplyRepoProc = scpWqfEntAccountApplyRepoProc;
        this.scpWqfEntAccountApplyRepoDProc = scpWqfEntAccountApplyRepoDProc;
        this.tenantDataIsolateProvider = tenantDataIsolateProvider;
        this.transactionTemplate = transactionTemplate;
        this.scpWqfEntAccountRepoProc = scpWqfEntAccountRepoProc;
        this.redissonClient = redissonClient;
    }
}

