package com.elitesland.scp.utils;

import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.cloudt.system.vo.SysSettingVO;
import com.elitesland.scp.application.out.service.SystemDubboService;
import com.elitesland.scp.common.ScpConstant;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * @author chaofeng.xia
 * @date 2023/10/27 20:08
 */
@Slf4j
@Component
@RequiredArgsConstructor
public class WorkFlowUtil {
    private final SystemDubboService systemDubboService;

    /**
     * 检查工作流是否启用
     * @param workFlowKey 工作流key
     * @return
     */
    public Boolean checkIsEnableWorkFlow(String workFlowKey) {
        SysSettingVO sysSetting = systemDubboService.findSysSetting(workFlowKey);
        return ObjectUtil.isNull(sysSetting) || ScpConstant.SETTING_FLAG_ONE.equals(sysSetting.getSettingVal());
    }

    // 没有系统配置不启动工作流
    public Boolean checkEnableWorkFlow(String workFlowKey) {
        SysSettingVO sysSetting = systemDubboService.findSysSetting(workFlowKey);
        return ObjectUtil.isNotNull(sysSetting) && ScpConstant.SETTING_FLAG_ONE.equals(sysSetting.getSettingVal());
    }

}
