/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.infr.repo.calendar;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.scp.application.facade.vo.param.calendar.ScpStoreCalendarSetPageParamVO;
import com.elitesland.scp.application.facade.vo.param.calendar.ScpStoreCalendarSetParamVO;
import com.elitesland.scp.application.facade.vo.resp.calendar.ScpStoreCalendarSetPageRespVO;
import com.elitesland.scp.application.facade.vo.resp.calendar.ScpStoreCalendarSetRespVO;
import com.elitesland.scp.domain.entity.calendar.QScpStoreCalendarSetDO;
import com.elitesland.scp.domain.entity.calendar.QScpStoreCalendarSetLineDO;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPADeleteClause;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class ScpStoreCalendarSetRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private static final QScpStoreCalendarSetDO scpStoreCalendarSetDO = QScpStoreCalendarSetDO.scpStoreCalendarSetDO;
    private static final QScpStoreCalendarSetLineDO scpStoreCalendarSetLineDO = QScpStoreCalendarSetLineDO.scpStoreCalendarSetLineDO;
    private final QBean<ScpStoreCalendarSetPageRespVO> pageList;

    public long count(ScpStoreCalendarSetPageParamVO paramVO) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(ScpStoreCalendarSetRepoProc.scpStoreCalendarSetDO.id).distinct()).from((EntityPath)scpStoreCalendarSetDO)).leftJoin((EntityPath)scpStoreCalendarSetLineDO)).on((Predicate)ScpStoreCalendarSetRepoProc.scpStoreCalendarSetDO.id.eq(ScpStoreCalendarSetRepoProc.scpStoreCalendarSetLineDO.masId));
        jpaQuery.where(this.whereCalendarSet(paramVO));
        return jpaQuery.fetchCount();
    }

    public List<ScpStoreCalendarSetPageRespVO> queryCalendarSet(ScpStoreCalendarSetPageParamVO paramVO) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.pageList).distinct()).from((EntityPath)scpStoreCalendarSetDO)).leftJoin((EntityPath)scpStoreCalendarSetLineDO)).on((Predicate)ScpStoreCalendarSetRepoProc.scpStoreCalendarSetDO.id.eq(ScpStoreCalendarSetRepoProc.scpStoreCalendarSetLineDO.masId));
        paramVO.setPaging(jpaQuery);
        paramVO.fillOrders(jpaQuery, scpStoreCalendarSetDO);
        jpaQuery.where(this.whereCalendarSet(paramVO));
        return jpaQuery.fetch();
    }

    private Predicate whereCalendarSet(ScpStoreCalendarSetPageParamVO paramVO) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (StrUtil.isNotBlank((CharSequence)paramVO.getSetName())) {
            predicates.add(ScpStoreCalendarSetRepoProc.scpStoreCalendarSetDO.setName.like("%" + paramVO.getSetName() + "%"));
        }
        if (CollUtil.isNotEmpty(paramVO.getStoreCodes())) {
            predicates.add(ScpStoreCalendarSetRepoProc.scpStoreCalendarSetLineDO.storeCode.in(paramVO.getStoreCodes()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public long deleteByIds(List<Long> ids) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        predicates.add(ScpStoreCalendarSetRepoProc.scpStoreCalendarSetDO.id.in(ids));
        JPADeleteClause delete = this.jpaQueryFactory.delete((EntityPath)scpStoreCalendarSetDO).where(new Predicate[]{ExpressionUtils.allOf(predicates)});
        return delete.execute();
    }

    public List<ScpStoreCalendarSetRespVO> findCalendarSet(ScpStoreCalendarSetParamVO paramVO) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ScpStoreCalendarSetRespVO.class, (Expression[])new Expression[]{ScpStoreCalendarSetRepoProc.scpStoreCalendarSetDO.id, ScpStoreCalendarSetRepoProc.scpStoreCalendarSetDO.setCode})).from((EntityPath)scpStoreCalendarSetDO);
        if (StrUtil.isNotBlank((CharSequence)paramVO.getSetCode())) {
            jpaQuery.where((Predicate)ScpStoreCalendarSetRepoProc.scpStoreCalendarSetDO.setCode.eq((Object)paramVO.getSetCode()));
        }
        return jpaQuery.fetch();
    }

    public void approveUpdateApplyAlter(List<Long> ids, String docStatus, ProcInstStatus procInstStatus, String approveComment, LocalDateTime apprTime) {
        this.jpaQueryFactory.update((EntityPath)scpStoreCalendarSetDO).set((Path)ScpStoreCalendarSetRepoProc.scpStoreCalendarSetDO.docStatus, (Object)docStatus).set(ScpStoreCalendarSetRepoProc.scpStoreCalendarSetDO.procInstStatus, (Object)procInstStatus).set((Path)ScpStoreCalendarSetRepoProc.scpStoreCalendarSetDO.approveComment, (Object)approveComment).set(ScpStoreCalendarSetRepoProc.scpStoreCalendarSetDO.apprTime, (Object)apprTime).set(ScpStoreCalendarSetRepoProc.scpStoreCalendarSetDO.approvedTime, (Object)apprTime).where(new Predicate[]{ScpStoreCalendarSetRepoProc.scpStoreCalendarSetDO.id.in(ids)}).execute();
    }

    public void applyChangeUpdate(Long id, String docStatus, ProcInstStatus procInstStatus) {
        this.jpaQueryFactory.update((EntityPath)scpStoreCalendarSetDO).set((Path)ScpStoreCalendarSetRepoProc.scpStoreCalendarSetDO.docStatus, (Object)docStatus).set(ScpStoreCalendarSetRepoProc.scpStoreCalendarSetDO.submitTime, (Object)LocalDateTime.now()).set(ScpStoreCalendarSetRepoProc.scpStoreCalendarSetDO.procInstStatus, (Object)procInstStatus).where(new Predicate[]{ScpStoreCalendarSetRepoProc.scpStoreCalendarSetDO.id.eq((Object)id)}).execute();
    }

    public ScpStoreCalendarSetRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.pageList = Projections.bean(ScpStoreCalendarSetPageRespVO.class, (Expression[])new Expression[]{ScpStoreCalendarSetRepoProc.scpStoreCalendarSetDO.id, ScpStoreCalendarSetRepoProc.scpStoreCalendarSetDO.setCode, ScpStoreCalendarSetRepoProc.scpStoreCalendarSetDO.setName, ScpStoreCalendarSetRepoProc.scpStoreCalendarSetDO.setDescription, ScpStoreCalendarSetRepoProc.scpStoreCalendarSetDO.docStatus, ScpStoreCalendarSetRepoProc.scpStoreCalendarSetDO.startYear, ScpStoreCalendarSetRepoProc.scpStoreCalendarSetDO.endYear, ScpStoreCalendarSetRepoProc.scpStoreCalendarSetDO.creator, ScpStoreCalendarSetRepoProc.scpStoreCalendarSetDO.createUserId, ScpStoreCalendarSetRepoProc.scpStoreCalendarSetDO.createTime, ScpStoreCalendarSetRepoProc.scpStoreCalendarSetDO.updater, ScpStoreCalendarSetRepoProc.scpStoreCalendarSetDO.modifyUserId, ScpStoreCalendarSetRepoProc.scpStoreCalendarSetDO.modifyTime, ScpStoreCalendarSetRepoProc.scpStoreCalendarSetDO.remark});
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

