package com.elitesland.scp.application.facade.vo.param.order;


import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.elitesland.scp.common.PartitionQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.time.LocalDateTime;

@Data
@ApiModel(value = "订货订单评价查询参数")
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class ScpDemandOrderReplyPageParamVO extends PartitionQueryParam {

    @ApiModelProperty("类型")
    private String type;

    @ApiModelProperty("订货集编码")
    private String demandCode;

    @ApiModelProperty("订货单编码")
    private String docCode;

    @ApiModelProperty("单据状态")
    private String docStatus;

    @ApiModelProperty("单据类型")
    private String docType;

    @ApiModelProperty("门店编码/仓库编码")
    private String demandWhStCode;

    @ApiModelProperty("供应仓库编码")
    private String suppWhCode;

    @ApiModelProperty("需求日期开始")
    private LocalDateTime demandDateFrom;

    @ApiModelProperty("需求日期结束")
    private LocalDateTime demandDateTo;

    @ApiModelProperty(value = "订单分数")
    private Integer orderScore;

    @ApiModelProperty(value = "物流分数")
    private Integer expressScore;

}
