package com.elitesland.scp.application.web.whnet;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.whnet.*;
import com.elitesland.scp.application.service.whnet.ScpWhNetRelationService;
import com.elitesland.scp.dto.whnet.ScpWhNetRelationRpcDTO;
import com.elitesland.scp.param.ScpWhNetRelationRpcDtoParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import lombok.val;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * @author jeesie
 * @description:
 * @datetime 2024年 03月 20日 14:29
 * @version: 1.0
 */
@Slf4j
@Api(tags = "仓网供应关系接口")
@RestController
@RequestMapping(value = "/whNetRelation", produces = MediaType.APPLICATION_JSON_VALUE)
@AllArgsConstructor
public class ScpWhNetRelationController {

    private final ScpWhNetRelationService scpWhNetRelationService;


    @PostMapping("/page")
    @ApiOperation("仓网供应关系-分页")
    public ApiResult<PagingVO<ScpWhNetRelationPageVO>> searchPage(@RequestBody ScpWhNetRelationPageParamVO queryParam) {
        val ret = scpWhNetRelationService.page(queryParam);
        return ApiResult.ok(ret);
    }


    @PostMapping("/save")
    @ApiOperation("仓网供应关系-新增/编辑")
    public ApiResult saveWhNetRelation(@RequestBody ScpWhNetRelationSaveVO createParam) {
        return scpWhNetRelationService.saveWhNetRelation(createParam);
    }

    @PutMapping("/ouInfo")
    @ApiOperation("仓网供应关系-销售公司查询")
    public ApiResult<OuInfo> findOuInfo(@Valid @RequestBody OuInfoQueryParamVO param) {
        val ret = scpWhNetRelationService.findOuInfo(param);
        return ApiResult.ok(ret);
    }

    @PutMapping("/header")
    @ApiOperation("仓网供应关系-详情查询")
    public ApiResult<List<ScpWhNetRelationRespVO>> findWhNetList(@Valid @RequestBody ScpWhNetRelationBaseParamVO param) {
        val ret = scpWhNetRelationService.findWhNetList(param);
        return ApiResult.ok(ret);
    }


    @PutMapping("/delete")
    @ApiOperation("仓网供应关系-删除")
    public ApiResult deleteWhNetRelation(@RequestBody List<Long> ids) {
        scpWhNetRelationService.deleteWhNetRelation(ids);
        return ApiResult.ok();
    }

    @PostMapping("/findWhNetRelationRpcDtoByParam")
    @ApiOperation("仓网供应关系条件查询")
    public ApiResult<List<ScpWhNetRelationRpcDTO>> findWhNetRelationRpcDtoByParam(@RequestBody ScpWhNetRelationRpcDtoParam queryParam) {
        val ret = scpWhNetRelationService.findWhNetRelationRpcDtoByParam(queryParam);
        return ApiResult.ok(ret);
    }

    @PostMapping("/scpmanAuthorityPage")
    @ApiOperation("仓网供应关系-计划员权限分页列表")
    public ApiResult<PagingVO<ScpWhNetRelationPageVO>> scpmanAuthorityPage(@RequestBody ScpWhNetRelationPageParamVO queryParam) {
        val ret = scpWhNetRelationService.scpmanAuthorityPage(queryParam);
        return ApiResult.ok(ret);
    }


    @PutMapping("/batch/delete")
    @ApiOperation("仓网供应关系-批量删除")
    public ApiResult batchDelete(@RequestBody List<Long> ids) {
        scpWhNetRelationService.batchDelete(ids);
        return ApiResult.ok();
    }

}
