package com.elitesland.scp.infr.repo.template;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.template.*;
import com.elitesland.scp.domain.entity.template.QScpTemplateSetDO;
import com.elitesland.scp.dto.template.DemandOrderListRpcParamDTO;
import com.elitesland.scp.dto.template.DemandOrderListRpcRespDTO;
import com.elitesland.scp.utils.DateTimeUtil;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @Auther: Mark
 * @Date: 2024/4/25 10:33
 * @Description:
 */
@Component
@RequiredArgsConstructor
public class ScpDemandTemplateSetRepoProc {

    private final JPAQueryFactory jpaQueryFactory;
    private static final QScpTemplateSetDO scpTemplateSetDO = QScpTemplateSetDO.scpTemplateSetDO;

    public void updateStatus(Integer status, List<Long> ids) {
        jpaQueryFactory.update(scpTemplateSetDO)
                .set(scpTemplateSetDO.demandTemStatus, status)
                .where(scpTemplateSetDO.id.in(ids))
                .execute();
    }

    public void delete(List<Long> ids) {
        jpaQueryFactory.update(scpTemplateSetDO)
                .set(scpTemplateSetDO.deleteFlag, 1)
                .where(scpTemplateSetDO.id.in(ids))
                .execute();
    }

    public PagingVO<DemandOrderPageRespVO> findTemplateSet(DemandOrderPageQueryVO paramVO) {
        JPAQuery<DemandOrderPageRespVO> jpaQuery =
                jpaQueryFactory.select(Projections.bean(DemandOrderPageRespVO.class,
                                scpTemplateSetDO.id,
                                scpTemplateSetDO.demandTemCode,
                                scpTemplateSetDO.demandTemName,
                                scpTemplateSetDO.startDate,
                                scpTemplateSetDO.endDate,
                                scpTemplateSetDO.detailedTime,
                                scpTemplateSetDO.demandTemStatus,
                                scpTemplateSetDO.docType,
                                scpTemplateSetDO.type,
                                scpTemplateSetDO.creator,
                                scpTemplateSetDO.createTime))
                        .from(scpTemplateSetDO);

        List<Predicate> predicates = new ArrayList<>();
        where(paramVO, predicates);
        jpaQuery.where(ExpressionUtils.allOf(predicates));
        paramVO.setPaging(jpaQuery);
        jpaQuery.orderBy(scpTemplateSetDO.createTime.desc());
        //     vo.fillOrders(jpaQuery, scpTemplateSetDO);

        return PagingVO.<DemandOrderPageRespVO>builder()
                .total(jpaQuery.fetchCount())
                .records(jpaQuery.fetch())
                .build();
    }


    private static void where(DemandOrderPageQueryVO queryVO, List<Predicate> predicates) {
        if (StringUtils.isNotBlank(queryVO.getDemandTemCode())) {
            predicates.add(scpTemplateSetDO.demandTemCode.eq(queryVO.getDemandTemCode()));
        }
        if (StringUtils.isNotBlank(queryVO.getDemandTemName())) {
            predicates.add(scpTemplateSetDO.demandTemName.like("%" + queryVO.getDemandTemName() + "%"));
        }
        if (queryVO.getDemandTemStatus() != null) {
            predicates.add(scpTemplateSetDO.demandTemStatus.eq(queryVO.getDemandTemStatus()));
        }
        if (Boolean.TRUE.equals(queryVO.getScpmanAuthority()) && CollectionUtils.isNotEmpty(queryVO.getIds())) {
            predicates.add(scpTemplateSetDO.id.in(queryVO.getIds()));
        }
        if (CollUtil.isNotEmpty(queryVO.getDocTypes())) {
            predicates.add(scpTemplateSetDO.docType.in(queryVO.getDocTypes()));
        }
        if (StrUtil.isNotBlank(queryVO.getType())) {
            predicates.add(scpTemplateSetDO.type.eq(queryVO.getType()));
        }
    }


    public List<DemandOrderPageRespVO> findTemplateSetLoad(DemandOrderLoadParamVO paramVO) {
        Date now = DateTimeUtil.nowOnlyDay();

        JPAQuery<DemandOrderPageRespVO> jpaQuery =
                jpaQueryFactory.select(Projections.bean(DemandOrderPageRespVO.class,
                                scpTemplateSetDO.id,
                                scpTemplateSetDO.demandTemCode,
                                scpTemplateSetDO.demandTemName,
                                scpTemplateSetDO.startDate,
                                scpTemplateSetDO.endDate,
                                scpTemplateSetDO.detailedTime,
                                scpTemplateSetDO.demandTemStatus,
                                scpTemplateSetDO.docType,
                                scpTemplateSetDO.creator,
                                scpTemplateSetDO.createTime))
                        .from(scpTemplateSetDO);

        List<Predicate> predicates = new ArrayList<>();
        predicates.add(scpTemplateSetDO.demandTemStatus.eq(1));
        predicates.add(scpTemplateSetDO.startDate.loe(now));
        predicates.add(scpTemplateSetDO.endDate.goe(now));
        where(paramVO, predicates);
        jpaQuery.where(ExpressionUtils.allOf(predicates));
        //    paramVO.setPaging(jpaQuery);
        jpaQuery.orderBy(scpTemplateSetDO.createTime.desc());
        return jpaQuery.fetch();
    }

    private static void where(DemandOrderLoadParamVO queryVO, List<Predicate> predicates) {
        if (StringUtils.isNotBlank(queryVO.getDemandTemCode())) {
            predicates.add(scpTemplateSetDO.demandTemCode.eq(queryVO.getDemandTemCode()));
        }
        if (StringUtils.isNotBlank(queryVO.getDemandTemName())) {
            predicates.add(scpTemplateSetDO.demandTemName.like("%" + queryVO.getDemandTemName() + "%"));
        }
        if (StrUtil.isNotBlank(queryVO.getDocType())) {
            predicates.add(scpTemplateSetDO.docType.eq(queryVO.getDocType()));
        }
        if (StrUtil.isNotBlank(queryVO.getType())) {
            predicates.add(scpTemplateSetDO.type.eq(queryVO.getType()));
        }
    }

    public List<DemandOrderListRpcRespDTO> findTemplateSetList(DemandOrderListRpcParamDTO dto) {
        Date now = DateTimeUtil.nowOnlyDay();

        JPAQuery<DemandOrderListRpcRespDTO> jpaQuery =
                jpaQueryFactory.select(Projections.bean(DemandOrderListRpcRespDTO.class,
                                scpTemplateSetDO.id,
                                scpTemplateSetDO.demandTemCode,
                                scpTemplateSetDO.demandTemName,
                                scpTemplateSetDO.startDate,
                                scpTemplateSetDO.endDate,
                                scpTemplateSetDO.detailedTime,
                                scpTemplateSetDO.demandTemStatus,
                                scpTemplateSetDO.creator,
                                scpTemplateSetDO.createTime))
                        .from(scpTemplateSetDO);

        List<Predicate> predicates = new ArrayList<>();
        predicates.add(scpTemplateSetDO.demandTemStatus.eq(1));
        predicates.add(scpTemplateSetDO.startDate.loe(now));
        predicates.add(scpTemplateSetDO.endDate.goe(now));
        where(dto, predicates);
        jpaQuery.where(ExpressionUtils.allOf(predicates));
        jpaQuery.orderBy(scpTemplateSetDO.createTime.desc());
        return jpaQuery.fetch();
    }

    private static void where(DemandOrderListRpcParamDTO dto, List<Predicate> predicates) {
        if (StringUtils.isNotBlank(dto.getDemandTemCode())) {
            predicates.add(scpTemplateSetDO.demandTemCode.eq(dto.getDemandTemCode()));
        }
        if (StringUtils.isNotBlank(dto.getDemandTemName())) {
            predicates.add(scpTemplateSetDO.demandTemName.like("%" + dto.getDemandTemName() + "%"));
        }
        if (StrUtil.isNotBlank(dto.getType())) {
            predicates.add(scpTemplateSetDO.type.eq(dto.getType()));
        }
    }

    public List<DemandOrderListRespVO> findTemplateSetList(DemandOrderListParamVO vo) {
        Date now = DateTimeUtil.nowOnlyDay();

        JPAQuery<DemandOrderListRespVO> jpaQuery =
                jpaQueryFactory.select(Projections.bean(DemandOrderListRespVO.class,
                                scpTemplateSetDO.id,
                                scpTemplateSetDO.demandTemCode,
                                scpTemplateSetDO.demandTemName,
                                scpTemplateSetDO.docType,
                                scpTemplateSetDO.startDate,
                                scpTemplateSetDO.endDate,
                                scpTemplateSetDO.detailedTime,
                                scpTemplateSetDO.demandTemStatus,
                                scpTemplateSetDO.creator,
                                scpTemplateSetDO.createTime))
                        .from(scpTemplateSetDO);

        List<Predicate> predicates = new ArrayList<>();
        predicates.add(scpTemplateSetDO.demandTemStatus.eq(1));
        predicates.add(scpTemplateSetDO.startDate.loe(now));
        predicates.add(scpTemplateSetDO.endDate.goe(now));
        where(vo, predicates);
        jpaQuery.where(ExpressionUtils.allOf(predicates));
        jpaQuery.orderBy(scpTemplateSetDO.createTime.desc());
        return jpaQuery.fetch();
    }

    private static void where(DemandOrderListParamVO queryVO, List<Predicate> predicates) {
        String searchWord = queryVO.getDemandTemSearchWord();
        String searchConditionStr = "%" + searchWord + "%";

        if (StrUtil.isNotBlank(queryVO.getDocType())) {
            predicates.add(scpTemplateSetDO.docType.eq(queryVO.getDocType()));
        }
        if (StringUtils.isNotBlank(searchWord)) {
            predicates.add(scpTemplateSetDO.demandTemName.like(searchConditionStr).or(scpTemplateSetDO.demandTemCode.like(searchConditionStr)));
        }
        if (StrUtil.isNotBlank(queryVO.getType())) {
            predicates.add(scpTemplateSetDO.type.eq(queryVO.getType()));
        }
    }

    public PagingVO<ScpDemandTemplateExportRespVO> findTemplateSetExport(ScpDemandTemplateExportParamVO paramVO) {
        JPAQuery<ScpDemandTemplateExportRespVO> jpaQuery =
                jpaQueryFactory.select(Projections.bean(ScpDemandTemplateExportRespVO.class,
                                scpTemplateSetDO.id,
                                scpTemplateSetDO.demandTemCode,
                                scpTemplateSetDO.demandTemName,
                                scpTemplateSetDO.startDate,
                                scpTemplateSetDO.endDate,
                                scpTemplateSetDO.docType,
                                scpTemplateSetDO.type.as("demandType"),
                                scpTemplateSetDO.detailedTime,
                                scpTemplateSetDO.demandTemStatus,
                                scpTemplateSetDO.remark,
                                scpTemplateSetDO.creator,
                                scpTemplateSetDO.createTime))
                        .from(scpTemplateSetDO);

        List<Predicate> predicates = new ArrayList<>();
        where(paramVO, predicates);
        jpaQuery.where(ExpressionUtils.allOf(predicates));
        paramVO.setPaging(jpaQuery);
        jpaQuery.orderBy(scpTemplateSetDO.createTime.desc());
        //     vo.fillOrders(jpaQuery, scpTemplateSetDO);

        return PagingVO.<ScpDemandTemplateExportRespVO>builder()
                .total(jpaQuery.fetchCount())
                .records(jpaQuery.fetch())
                .build();
    }

    private static void where(ScpDemandTemplateExportParamVO queryVO, List<Predicate> predicates) {
        if (CollUtil.isNotEmpty(queryVO.getIds())) {
            predicates.add(scpTemplateSetDO.id.in(queryVO.getIds()));
        }
        if (CollUtil.isNotEmpty(queryVO.getDocTypes())) {
            predicates.add(scpTemplateSetDO.docType.in(queryVO.getDocTypes()));
        }

        if (StrUtil.isNotBlank(queryVO.getDemandTemCode())) {
            predicates.add(scpTemplateSetDO.demandTemCode.eq(queryVO.getDemandTemCode()));
        }

        if (StringUtils.isNotBlank(queryVO.getDemandTemName())) {
            predicates.add(scpTemplateSetDO.demandTemName.like("%" + queryVO.getDemandTemName() + "%"));
        }

        if (queryVO.getStatus() != null) {
            predicates.add(scpTemplateSetDO.demandTemStatus.eq(queryVO.getStatus()));
        }
        if (StrUtil.isNotBlank(queryVO.getType())) {
            predicates.add(scpTemplateSetDO.type.eq(queryVO.getType()));
        }
    }
}
