/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.rmi;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.support.provider.org.service.OrgRegionRpcService;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RmiOrgRegionRpcService {
    private static final Logger log = LoggerFactory.getLogger(RmiOrgRegionRpcService.class);
    private final OrgRegionRpcService orgRegionRpcService;

    public Map<String, String> findRpcDtoByRegionCodes(Set<String> regionCodes) {
        log.info("\u8c03\u7528\u652f\u6491\u57df-\u6839\u636e\u533a\u57df\u7f16\u7801\u83b7\u53d6\u5217\u8868\uff0c\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), regionCodes);
        try {
            ApiResult apiResult = this.orgRegionRpcService.getNameByCode(regionCodes);
            if (apiResult.isSuccess()) {
                return (Map)apiResult.getData();
            }
            throw new BusinessException(ApiCode.FAIL, apiResult.getMsg());
        }
        catch (Exception e) {
            log.error("findRpcDtoByAddrNo error:", (Throwable)e);
            return null;
        }
    }

    public RmiOrgRegionRpcService(OrgRegionRpcService orgRegionRpcService) {
        this.orgRegionRpcService = orgRegionRpcService;
    }
}

