package com.elitesland.scp.application.facade.vo.boh;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Data
@ApiModel(value = "门店收货确认")
public class StoreReceiveConfirmParam implements Serializable {

    private static final long serialVersionUID = -3542365886389320346L;

    @ApiModelProperty("业务单据id")
    private Long docId;

    @ApiModelProperty("明细")
    private List<StoreReceiveConfirmParam.StoreReceiveConfirmDetail> details;

    @Data
    public static class StoreReceiveConfirmDetail implements Serializable {
        private static final long serialVersionUID = -8342040474280563355L;

        @ApiModelProperty("明细id")
        private Long id;

        @ApiModelProperty("商品id")
        private Long itemId;

        @ApiModelProperty("商品编码")
        private String itemCode;

        @ApiModelProperty("实收数量")
        private BigDecimal qty;

        @ApiModelProperty("收货库存状态")
        private String limit1;

        @ApiModelProperty("收货批次")
        private String lotNo;

        @ApiModelProperty("生产日期")
        private LocalDateTime manuDate;
    }
}
