package com.elitesland.scp.application.facade.vo.resp.wqf;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
* @description:  
* @author: jeesie.jiang
* @create: 2025-02-28
* @Version 1.0
**/

@Data
@ApiModel("门店微企付账号列表")
public class ScpWqfEntAccountPageVO extends BaseViewModel implements Serializable {

    @ApiModelProperty(value = "公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty(value = "公司编码")
    private String ouCode;

    @ApiModelProperty(value = "申请单号")
    private String applyNo;

    @ApiModelProperty(value = "公司名称")
    private String ouName;

    @ApiModelProperty(value = "公司商户号")
    private String entId;

    @ApiModelProperty(value = "门店ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long storeId;

    @ApiModelProperty(value = "门店名称")
    private String storeName;

    @ApiModelProperty(value = "门店编码")
    private String storeCode;

    @ApiModelProperty(value = "门店商户号")
    private String entAcctId;

    @ApiModelProperty(value = "账户类型")
    @SysCode(sys = "yst-suplan", mod = "WQF_ACCOUNT_TYPE")
    private String accountType;
    private String accountTypeName;

    @ApiModelProperty(value = "门店充值子账号")
    private String bankAccount;

    @ApiModelProperty(value = "开户银行")
    private String openBank;

    @ApiModelProperty(value = "联行号")
    private String bankBranchCode;

    @ApiModelProperty(value = "支行名")
    private String branchName;

    @ApiModelProperty(value = "状态")
    private Boolean status;




}