package com.elitesland.scp.lakalapay.controller;

import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitesland.scp.lakalapay.service.LklPaymentService;
import com.elitesland.scp.pay.service.AccountBatchBindService;
import com.elitesland.scp.pay.service.PaymentService;
import com.elitesland.scp.pay.service.RefundsService;
import com.tenpay.business.entpay.mse.sdk.exception.EntpayException;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.configurationprocessor.json.JSONException;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

@Slf4j
@RestController
@RequestMapping("/notify")
@RequiredArgsConstructor
public class LakalaNotifyVerifyController {

    private final LklPaymentService lklPaymentService;

    // 支付回调
    @ResponseBody
    @PostMapping("/pay/callback")
    public String paymentNotify(@RequestBody String bytes) throws EntpayException, JSONException {
        log.info("支付回调通知数据,body：{}", JSONUtil.toJsonStr(bytes));
        return lklPaymentService.paymentNotify(bytes);
    }
}
