/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.common;

import com.elitescloud.boot.task.delay.common.DelayTaskSender;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderPayTimeoutMqParam;
import java.io.Serializable;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class OrderStatusCountdownService {
    private static final Logger log = LoggerFactory.getLogger(OrderStatusCountdownService.class);
    private final DelayTaskSender delayTaskSender;

    public void startCountdown(Long orderId, long delaySeconds, String targetStatus, LocalDateTime startTime) {
        try {
            ScpDemandOrderPayTimeoutMqParam orderSubmitMqParam = new ScpDemandOrderPayTimeoutMqParam();
            orderSubmitMqParam.setDocId(orderId);
            orderSubmitMqParam.setTargetStatus(targetStatus);
            orderSubmitMqParam.setBusinessKey("scp_order_pay_timeout");
            LocalDateTime delayTime = startTime.plusSeconds(delaySeconds);
            log.info("\u8ba2\u5355 {} \u5012\u8ba1\u65f6\u5f00\u59cb\uff0c\u5012\u8ba1\u65f6\u7ed3\u675f\u65f6\u95f4\uff1a{}", (Object)orderId, (Object)delayTime);
            this.delayTaskSender.send("scp_order_pay_timeout", orderId.toString(), (Serializable)orderSubmitMqParam, delayTime);
        }
        catch (Exception e) {
            log.info("\u542f\u52a8\u652f\u4ed8\u5012\u8ba1\u65f6\uff1a{},\u53d1\u9001mq\u6d88\u606f\u5931\u8d25\uff1a{}", (Object)orderId, (Object)e.toString());
        }
        log.info("\u8ba2\u5355 {} \u542f\u52a8\u5012\u8ba1\u65f6\uff0c{} \u79d2\u540e\u66f4\u65b0\u72b6\u6001\u4e3a {}", new Object[]{orderId, delaySeconds, targetStatus});
    }

    public OrderStatusCountdownService(DelayTaskSender delayTaskSender) {
        this.delayTaskSender = delayTaskSender;
    }
}

