package com.elitesland.scp.application.service.app;

import com.elitesland.scp.application.facade.vo.param.app.ScpStoreItemParamVO;
import com.elitesland.scp.domain.entity.item.ScpStoreItemDO;

import java.util.List;

public interface ScpCacheService {

    /**
     * 获取商品信息
     *
     * @param paramVO
     * @return
     */
    List<ScpStoreItemDO> getItem(ScpStoreItemParamVO paramVO);

    /**
     * 删除指定商品缓存
     *
     * @param spuIds
     */
    void deleteKeys(List<Long> spuIds);

    /**
     * 删除所有商品的缓存
     */
    void deleteAllKeys();

    /**
     * 删除spec
     * @param spec
     */
    void deleteSpecKeys(String spec);
}
