/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.domain.service.alloc;

import cn.hutool.core.collection.CollUtil;
import com.elitesland.scp.application.facade.vo.resp.alloc.ScpAllocSettingBrandRespVO;
import com.elitesland.scp.application.facade.vo.save.alloc.ScpAllocSettingBrandSaveVO;
import com.elitesland.scp.domain.convert.alloc.ScpAllocSettingBrandConvert;
import com.elitesland.scp.domain.entity.alloc.ScpAllocSettingBrandDO;
import com.elitesland.scp.domain.service.alloc.ScpAllocSettingBrandDomainService;
import com.elitesland.scp.infr.repo.alloc.ScpAllocSettingBrandRepo;
import com.elitesland.scp.infr.repo.alloc.ScpAllocSettingBrandRepoProc;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScpAllocSettingBrandDomainServiceImpl
implements ScpAllocSettingBrandDomainService {
    private static final Logger log = LoggerFactory.getLogger(ScpAllocSettingBrandDomainServiceImpl.class);
    private final ScpAllocSettingBrandRepo scpAllocSettingBrandRepo;
    private final ScpAllocSettingBrandRepoProc scpAllocSettingBrandRepoProc;

    @Override
    public List<ScpAllocSettingBrandRespVO> findByMasId(Long masId) {
        List<ScpAllocSettingBrandDO> settingItemDOS = this.scpAllocSettingBrandRepo.findByMasId(masId);
        if (CollUtil.isNotEmpty(settingItemDOS)) {
            return ScpAllocSettingBrandConvert.INSTANCE.dosToRespVOS(settingItemDOS);
        }
        return new ArrayList<ScpAllocSettingBrandRespVO>();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchSaveAllocSettingBrand(List<ScpAllocSettingBrandSaveVO> saveVOS) {
        this.scpAllocSettingBrandRepo.saveAll(ScpAllocSettingBrandConvert.INSTANCE.saveVosDOS(saveVOS));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByMasId(Long masId) {
        this.scpAllocSettingBrandRepo.deleteByMasId(masId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByIds(List<Long> ids) {
        this.scpAllocSettingBrandRepo.deleteByIds(ids);
    }

    @Override
    public List<Long> findMasIdByBrand(String brand) {
        return this.scpAllocSettingBrandRepoProc.findMasIdByBrand(brand);
    }

    public ScpAllocSettingBrandDomainServiceImpl(ScpAllocSettingBrandRepo scpAllocSettingBrandRepo, ScpAllocSettingBrandRepoProc scpAllocSettingBrandRepoProc) {
        this.scpAllocSettingBrandRepo = scpAllocSettingBrandRepo;
        this.scpAllocSettingBrandRepoProc = scpAllocSettingBrandRepoProc;
    }
}

