package com.elitesland.scp.application.facade.vo.resp.app;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.support.provider.item.dto.ItmItemAttachmentProviderDTO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;


@Data
@ApiModel("门店订货小程序商品列表")
public class AppItmItemPageVO implements Serializable {

    @ApiModelProperty(value = "商品品类编码")
    private String itemCateCode;

    @ApiModelProperty(value = "商品品类名称")
    private String itemCateName;

    @ApiModelProperty(value = "商品id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty(value = "商品编码")
    private String itemCode;

    @ApiModelProperty(value = "商品名称")
    private String itemName;

    @ApiModelProperty(value = "状态")
    private Boolean status;

    @ApiModelProperty(value = "订货单位")
    private String uom;
    private String uomName;

    @ApiModelProperty("基本单位")
    private String uom2;
    @ApiModelProperty(value = "基本单位名称")
    private String uom2Name;

    @ApiModelProperty("单位转换系数")
    private BigDecimal uomRatio;

    @ApiModelProperty("有效位数")
    private Integer decimalPlaces;

    @ApiModelProperty(value = "价格")
    private BigDecimal price;

    @ApiModelProperty("规格型号")
    private String spec;

    @ApiModelProperty(value = "类型")
    private String itemType;
    private String itemTypeName;

    @ApiModelProperty(value = "物料分类")
    private String itemType2;
    private String itemType2Name;

    @ApiModelProperty(value = "品牌")
    private String brand;
    private String brandName;

    @ApiModelProperty(value = "商品规格2(1单规格 0多规格)")
    private String itemAttr2;

    @ApiModelProperty(value = "商品图片")
    private List<ItmItemAttachmentProviderDTO> itemImageList;

    @ApiModelProperty("spuId")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long spuId;

    @ApiModelProperty(value = "spuCode")
    private String spuCode;

    @ApiModelProperty(value = "spuName")
    private String spuName;

    @ApiModelProperty(value = "商品别名")
    private String anotherName;

    @ApiModelProperty(value = "数量")
    private BigDecimal qty;

    @ApiModelProperty(value = "包装规格")
    private String itemAttrName;

    @ApiModelProperty("领用单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String receiveUom;
    private String receiveUomName;

    @ApiModelProperty(value = "领用单位转换系数")
    private BigDecimal receiveUomRatio;

    @ApiModelProperty(value = "库存可供量")
    private BigDecimal avalQty;

    @ApiModelProperty(value = "最小起订量")
    private BigDecimal moq;

    @ApiModelProperty("多规格商品详情")
    private List<AppItmItemPageVO> details;

    @ApiModelProperty("组合商品标识")
    private Boolean combineItemFlag;

    @ApiModelProperty(value = "组合数量")
    private BigDecimal combineQty;

    @ApiModelProperty("组合商品编码")
    private String combineItemCode;

    @ApiModelProperty("组合商品名称")
    private String combineItemName;

    @ApiModelProperty("组合商品价格")
    private BigDecimal combineItemPrice;

    @ApiModelProperty(value = "强配活动编码")
    private String activityCode;

    @ApiModelProperty(value = "强配活动Id")
    private Long activityId;

    @ApiModelProperty("最小强配数量")
    private BigDecimal minNum;

    @ApiModelProperty("是否属于强配商品")
    private Boolean activityItemFlag;


}
