package com.elitesland.scp.domain.entity.storereceive;

import com.elitescloud.boot.jpa.common.PartitionField;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Entity
@Table(name = "scp_store_receive")
@org.hibernate.annotations.Table(appliesTo = "scp_store_receive", comment = "门店收/退货列表")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0")
public class StoreReceiveDO extends BaseModel implements Serializable {

    @Comment("收/退货id")
    @Column()
    private Long docId;

    @Comment("门店id")
    @Column()
    private Long storeId;

    @ApiModelProperty("收/退货单号")
    @Comment("收/退货单号")
    @Column()
    private String docNo;

    @Comment("订货单id")
    @Column()
    private Long orderId;

    @ApiModelProperty("订货单单号")
    @Comment("订货单单号")
    @Column()
    private String orderNo;

    @Comment("订货集id")
    @Column()
    private Long orderSetId;

    @ApiModelProperty("计划出、退数量")
    @Comment("计划出、退数量")
    @Column()
    private BigDecimal totalQty;

    @ApiModelProperty("实际出、退数量")
    @Comment("实际出、退数量")
    @Column()
    private BigDecimal totalRealQty;

    @ApiModelProperty("总金额")
    @Comment("总金额")
    @Column()
    private BigDecimal totalAmt;

    @ApiModelProperty("实际金额")
    @Comment("实际金额")
    @Column()
    private BigDecimal realAmt;

    @ApiModelProperty("单据创建日期")
    @Comment("单据创建日期")
    @Column()
    private LocalDateTime docCreateDate;

    @ApiModelProperty("订货日期")
    @Comment("订货日期")
    @Column()
    private LocalDateTime orderDate;

    @ApiModelProperty("发货日期")
    @Comment("发货日期")
    @Column()
    private LocalDateTime deliveryDate;

    @ApiModelProperty("收货日期")
    @Comment("收货日期")
    @Column()
    private LocalDateTime receiveDate;

    @ApiModelProperty("退货日期")
    @Comment("退货日期")
    @Column()
    private LocalDateTime rtnDate;

    @ApiModelProperty("单据类型，TRN：仓配-调拨单，GR：供应商直发-采购收货单")
    @Comment("单据类型，TRN：仓配-调拨单，GR：供应商直发-采购收货单")
    @Column(length = 30)
    private String docType;

    @ApiModelProperty("状态，DR：退货待审，CE：待收货/待退货、CF：已收货/已退货、CL：已取消")
    @Comment("状态，DR：退货待审，CE：待收货/待退货、CF：已收货/已退货、CL：已取消")
    @Column(length = 30)
    private String status;

    @ApiModelProperty("收/退类型，R：收货，T：退货")
    @Comment("收/退类型，R：收货，T：退货")
    @Column(length = 30)
    private String rtType;

    @Comment("退货单对应的收货单id")
    @Column()
    private Long receiveDocId;

    @Comment("退货单对应的收货单号")
    @Column()
    private String receiveDocNo;

    @ApiModelProperty("表分区字段：月")
    @Comment("表分区字段：月")
    @Column(updatable = false)
    @PartitionField(PartitionField.PartitionType.YEAR_MONTH)
    private Integer ym;
}
