package com.elitesland.scp.infr.repo.order;

import com.alibaba.fastjson.JSON;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpOrderTemplatePageParamVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpOrderTemplatePageRespVO;
import com.elitesland.scp.domain.entity.order.QScpOrderTemplateDO;
import com.elitesland.scp.domain.entity.order.ScpOrderTemplateDO;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Slf4j
@Component
@RequiredArgsConstructor
public class ScpOrderTemplateRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private static final QScpOrderTemplateDO jpaQDo = QScpOrderTemplateDO.scpOrderTemplateDO;

    public PagingVO<ScpOrderTemplatePageRespVO> page(ScpOrderTemplatePageParamVO paramVO) {

        JPAQuery<ScpOrderTemplatePageRespVO>
                jpaQuery = jpaQueryFactory.select(Projections.bean(ScpOrderTemplatePageRespVO.class,
                        jpaQDo.id,
                        jpaQDo.type,
                        jpaQDo.docType,
                        jpaQDo.storeCode,
                        jpaQDo.storeName,
                        jpaQDo.regionCode,
                        jpaQDo.deadlineTime,
                        jpaQDo.startDate,
                        jpaQDo.endDate,
                        jpaQDo.isActive,
                        jpaQDo.creator,
                        jpaQDo.createTime
                ))
                .from(jpaQDo);
        jpaQuery.orderBy(jpaQDo.createTime.desc());
        this.where(jpaQuery, paramVO);
        paramVO.setPaging(jpaQuery);
        log.info(JSON.toJSONString(jpaQuery.fetch()));
        // paramVO.fillOrders(jpaQuery, jpaQDo);

        return PagingVO.<ScpOrderTemplatePageRespVO>builder()
                .total(jpaQuery.fetchCount())
                .records(jpaQuery.fetch())
                .build();
    }
    private void where(JPAQuery<ScpOrderTemplatePageRespVO> jpaQuery, ScpOrderTemplatePageParamVO paramVO) {
        List<Predicate> predicates = new ArrayList<>();
        if(paramVO.getType() != null){
            predicates.add(jpaQDo.type.eq(paramVO.getType()));
        }
        if(paramVO.getDocType() != null){
            predicates.add(jpaQDo.docType.eq(paramVO.getDocType()));
        }
        if(paramVO.getStoreCode() != null){
            predicates.add(jpaQDo.storeCode.eq(paramVO.getStoreCode()));
        }
        if(paramVO.getStoreName() != null){
            predicates.add(jpaQDo.storeName.eq(paramVO.getStoreName()));
        }
        if(paramVO.getRegionCode() != null){
            predicates.add(jpaQDo.regionCode.eq(paramVO.getRegionCode()));
        }
        if(paramVO.getIsActive() != null){
            predicates.add(jpaQDo.isActive.eq(paramVO.getIsActive()));
        }
        if(paramVO.getStartDate() != null){
            predicates.add(jpaQDo.startDate.before(paramVO.getStartDate()));
        }else if(paramVO.getEndDate() != null){
            predicates.add(jpaQDo.endDate.after(paramVO.getEndDate()));
        }
        if (paramVO.getDate() != null){
            predicates.add(jpaQDo.startDate.loe(paramVO.getDate()));
            predicates.add(jpaQDo.endDate.goe(paramVO.getDate()));
        }
        jpaQuery.where(predicates.toArray(new Predicate[0]));
    }


}
