package com.elitesland.scp.lakalapay.service;


import com.alibaba.fastjson.JSONObject;
import com.elitesland.scp.lakalapay.vo.*;
import com.tenpay.business.entpay.mse.sdk.exception.EntpayException;
import org.springframework.boot.configurationprocessor.json.JSONException;

public interface LklPaymentService {

    /**
     * 小程序支付下单-在线
     *
     * @return
     */
    OnlineLklPayOrderResponseVO createMpPayOnline(OnlineLklPayOrderParamVO param);

    /**
     * 查询交易结果
     * @param docNo
     * @return
     */
    OnlineLklPayOrderResultResponseVO queryResult(String docNo);

    /**
     * 查询余额
     *
     * @param param
     * @return
     */
    BalanceResponseVO queryBalance(QueryBalanceParamVO param);

    JSONObject queryAccountDtl(QueryAccountDtlParamVO param);

    /**
     * 支付回调
     *
     * @param body
     * @return
     */
    String paymentNotify(String body) throws EntpayException, JSONException;

}
