package com.elitesland.scp.workflow.service.impl;


import com.elitesland.scp.application.out.service.SystemDubboService;
import com.elitesland.scp.domain.service.feedback.ScpStoreFeedbackDomainService;
import com.elitesland.scp.domain.service.feedback.impl.ScpStoreFeedbackDomainServiceImpl;
import com.elitesland.scp.workflow.service.FeedbackProcessService;
import com.elitesland.workflow.enums.ProcInstStatus;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 采购对账
 *
 * @author tine.he
 * @date 2021/8/29
 */
@Service
@RequiredArgsConstructor
public class FeedbackProcessServiceImpl implements FeedbackProcessService {
    private final SystemDubboService systemDubboService;
    private final ScpStoreFeedbackDomainService scpStoreFeedbackDomainService;


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void processStatusChange(long id, ProcInstStatus procInstStatus, String customParams) {
        scpStoreFeedbackDomainService.statusChangeByProcess(id, procInstStatus, customParams);
    }

    @Override
    public ArrayList<String> taskAssignee(Long id,String customParams) {
        List<Long> userIds = systemDubboService.findUserIdsByFlowRoles(id,customParams);
        ArrayList<String> userStrIds = new ArrayList<>();
        if(!CollectionUtils.isEmpty(userIds)) {
            userIds.stream().forEach( i -> {
                String newString = String.valueOf( i );
                userStrIds.add( newString );
            } );
            return userStrIds;
        }
        return new ArrayList<>();
    }
}
