package com.elitesland.scp.application.service.cart;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.threadpool.ThreadPoolAutoConfiguration;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.inv.dto.invstk.InvWhItemTotalStkRpcDTO;
import com.elitesland.inv.dto.invstk.InvWhItemTotalStkRpcParam;
import com.elitesland.inv.enums.InvDeter2TypeEnum;
import com.elitesland.sale.api.vo.resp.crm.GiftRpcDTO;
import com.elitesland.sale.api.vo.resp.crm.MktDiscountGiftRpcDTO;
import com.elitesland.sale.api.vo.resp.crm.MktDiscountGiftRpcParam;
import com.elitesland.scp.application.facade.vo.cart.*;
import com.elitesland.scp.application.facade.vo.freight.ScpStoreOrderFreightPageParamVO;
import com.elitesland.scp.application.facade.vo.param.app.AppItemActivityItemPriceParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderPageParamVO;
import com.elitesland.scp.application.facade.vo.param.setting.ScpOrderSettingParamVO;
import com.elitesland.scp.application.facade.vo.resp.alloc.ScpAllocSettingItemRespVO;
import com.elitesland.scp.application.facade.vo.resp.freight.ScpStoreOrderFreightPageRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderTitlePageRespVO;
import com.elitesland.scp.application.facade.vo.resp.setting.ScpOrderSettingRespVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandOrderDSaveVO;
import com.elitesland.scp.application.service.UserService;
import com.elitesland.scp.application.service.common.CommonPriceService;
import com.elitesland.scp.application.service.freight.ScpStoreOrderFreightService;
import com.elitesland.scp.application.service.order.ScpDemandOrderService;
import com.elitesland.scp.application.service.setting.ScpOrderSettingService;
import com.elitesland.scp.application.service.supalloc.ScpSupplyAllocationService;
import com.elitesland.scp.application.service.whnet.ScpWhNetRelationService;
import com.elitesland.scp.common.ScpConstant;
import com.elitesland.scp.domain.convert.cart.ScpStoreCartConvert;
import com.elitesland.scp.domain.entity.calendar.ScpStoreDemandCalendarDO;
import com.elitesland.scp.domain.entity.cart.ScpStoreCartDO;
import com.elitesland.scp.domain.service.alloc.ScpAllocSettingItemDomainService;
import com.elitesland.scp.domain.service.calendar.ScpStoreDemandCalendarDomainService;
import com.elitesland.scp.domain.service.setting.ScpOrderSettingDomainService;
import com.elitesland.scp.dto.supalloc.ScpSupplyAllocationRpcDTO;
import com.elitesland.scp.dto.whnet.ScpWhNetRelationRpcDTO;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.rmi.*;
import com.elitesland.scp.utils.BeanUtils;
import com.elitesland.scp.utils.CartRedisUtil;
import com.elitesland.scp.utils.CollectRedisUtil;
import com.elitesland.scp.utils.SysUtils;
import com.elitesland.support.provider.item.dto.ItmItemAttachmentProviderDTO;
import com.elitesland.support.provider.item.dto.ItmItemBaseRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemSimpleRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemSpuBusinessRpcDTO;
import com.elitesland.support.provider.item.param.ItmItemBaseRpcParam;
import com.elitesland.support.provider.item.service.ItmItemRpcService;
import com.elitesland.support.provider.org.dto.OrgStoreBaseRpcDTO;
import com.elitesland.support.provider.pri.service.dto.PriPriceRpcDTO;
import com.elitesland.support.provider.pri.service.param.ItmBomPriceRpcDtoParam;
import com.elitesland.support.provider.pri.service.param.ItmPriPriceRpcDtoParam;
import io.seata.common.util.CollectionUtils;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.task.TaskExecutor;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;

import static java.util.stream.Collectors.toList;

/**
 * @Auther: ryan.xu
 * @Date: 2024/7/28
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class ScpStoreCartServiceImpl implements ScpStoreCartService {
    @Autowired
    @Qualifier(ThreadPoolAutoConfiguration.BEAN_NAME)
    private TaskExecutor taskExecutor;
    private final CartRedisUtil cartRedisUtil;
    private final CollectRedisUtil collectRedisUtil;
    private final RmiItemService rmiItemService;
    private final RmiPriceRpcService rmiPriceRpcService;
    private final ScpSupplyAllocationService scpSupplyAllocationService;
    private final ScpWhNetRelationService scpWhNetRelationService;
    private final RmiOrgStoreRpcService rmiOrgStoreRpcService;
    private final CommonPriceService commonPriceService;
    private final ScpOrderSettingDomainService scpOrderSettingDomainService;
    private final RmiInvStkRpcService rmiInvStkRpcService;
    private final ScpAllocSettingItemDomainService scpAllocSettingItemDomainService;
    private final ItmItemRpcService itmItemRpcService;
    private final ScpStoreOrderFreightService scpStoreOrderFreightService;
    private final RmiSalService rmiSalService;
    private final ScpStoreDemandCalendarDomainService storeDemandCalendarDomainService;
    private final ScpOrderSettingService scpOrderSettingService;
    private final ScpDemandOrderService scpDemandOrderService;

    @Override
    public List<CartDetailRespVO> detail(CartDetailParamVO paramVO) {
        //门店编码
        String storeCode = paramVO.getDemandWhStCode();
        //购物车类型
        String cartType = paramVO.getCartType();
        Long currentUserId = UserService.currentUserId();
        List<ScpStoreCartDO> cartDOS = cartRedisUtil.getStoreCartItems(storeCode, cartType, currentUserId);
        if (CollUtil.isEmpty(cartDOS)) {
            return new ArrayList<>();
        }

        // 判断当前商品是否在订货周期内
        ScpOrderSettingParamVO scpOrderSettingParamVO = new ScpOrderSettingParamVO();
        List<ScpOrderSettingRespVO> scpOrderSettingRespVOS = scpOrderSettingService.queryOrderSettingList(scpOrderSettingParamVO);
        cartDOS.forEach(cartSaveVO -> {
            scpOrderSettingRespVOS.stream().filter(scpOrderSettingRespVO -> scpOrderSettingRespVO.getItemCates().contains(cartSaveVO.getItemType()))
                    .findAny().ifPresent(a -> {
                        cartSaveVO.setDocType(a.getDocType());
                    });
        });
        List<String> keyList = cartDOS.stream().map(cartSaveVO -> cartSaveVO.getDemandWhStCode() + cartSaveVO.getDocType() + LocalDate.now().getYear() + getTwoDigitMonth() + LocalDate.now().getDayOfMonth()).collect(toList());
        List<ScpStoreDemandCalendarDO> existList = storeDemandCalendarDomainService.findByStoreDayCalendar(keyList);
        cartDOS.forEach(cartSaveVO -> {
            if(CollUtil.isEmpty(existList)){
                cartSaveVO.setInOrderCycle(false);
            }
            Optional<ScpStoreDemandCalendarDO> e = existList.stream().filter(a -> a.getStoreCode().equals(cartSaveVO.getDemandWhStCode())
                            && a.getItemType2().equals(cartSaveVO.getDocType()))
                    .findAny();
            if(e.isEmpty()){
                cartSaveVO.setInOrderCycle(false);
            }
            if (e.isPresent() && e.get().getWorkStatus().equals("E")) {
                cartSaveVO.setInOrderCycle(false);
            } else cartSaveVO.setInOrderCycle(e.isPresent() && e.get().getWorkStatus().equals("W"));
        });

        AtomicReference<Map<String, BigDecimal>> stockMapRef = new AtomicReference<>(new HashMap<>());
        //实时获取价格
        //获取单据类型配置
        ScpOrderSettingRespVO orderSetting = scpOrderSettingDomainService.findCacheByDocType(cartType, ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode());
        var priceParamVOS = cartDOS.stream().map(row -> {
            AppItemActivityItemPriceParamVO priceParamVO = new AppItemActivityItemPriceParamVO();
            priceParamVO.setItemCode(row.getItemCode());
            priceParamVO.setItemId(row.getItemId());
            priceParamVO.setItemCateCode(row.getItemCateCode());
            priceParamVO.setUom(row.getUom());
            priceParamVO.setCombineItemCode(row.getCombineItemCode());
            priceParamVO.setCombineItemFlag(row.getCombineItemFlag());
            return priceParamVO;
        }).collect(Collectors.toList());
        Map<String, List<PriPriceRpcDTO>> priceMap = commonPriceService.getPriceAndStockDetails(priceParamVOS, storeCode, orderSetting, ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode(), stockMapRef);
        //封装返回
        List<CartDetailRespVO> resultList = new ArrayList<>();
        Map<String, BigDecimal> stockMap = stockMapRef.get();
        Map<String, List<ScpStoreCartDO>> spuMap =
                cartDOS.stream().collect(Collectors.groupingBy(a->a.getSpuCode()+"/"+a.getCombineItemCode()));
        for (Map.Entry<String, List<ScpStoreCartDO>> entry : spuMap.entrySet()) {
            CartDetailRespVO vo = new CartDetailRespVO();
            List<ScpStoreCartDO> storeCartDOS = entry.getValue();
            // SPU信息赋值
            ScpStoreCartDO storeCartDO = storeCartDOS.get(0);
            vo.setSpuId(storeCartDO.getSpuId());
            vo.setSpuCode(storeCartDO.getSpuCode());
            vo.setSpuName(storeCartDO.getSpuName());
            vo.setSpec(storeCartDO.getSpec());
            vo.setUrl(storeCartDO.getUrl());
            vo.setAnotherName(storeCartDO.getAnotherName());
            vo.setCombineItemCode(storeCartDO.getCombineItemCode());
            vo.setCombineItemName(storeCartDO.getCombineItemName());
            vo.setCombineItemFlag(storeCartDO.getCombineItemFlag());
            vo.setCombineQty(SysUtils.processStoreQtyScale(storeCartDO.getCombineQty()));
            vo.setCollectFlag(collectRedisUtil.existsSpuInUser(storeCode, currentUserId, SysUtils.getItemKey(storeCartDO.getCombineItemCode(), storeCartDO.getItemCode())));
            // SKU商品信息赋值
            List<CartDetailRespVO.ItemSpecObjectVO> itemSpecObjectVOS = new ArrayList<>();
            for (ScpStoreCartDO scpCartDO : storeCartDOS) {
                CartDetailRespVO.ItemSpecObjectVO detailVo = new CartDetailRespVO.ItemSpecObjectVO();
                detailVo.setUom(scpCartDO.getUom());
                detailVo.setUomName(scpCartDO.getUomName());
                detailVo.setItemId(scpCartDO.getItemId());
                detailVo.setItemCode(scpCartDO.getItemCode());
                detailVo.setItemName(scpCartDO.getItemName());
//                detailVo.setItemType2(scpCartDO.getItemType2());
//                // 设置配送类型
//                Optional.ofNullable(itemType2.get(scpCartDO.getItemType2())).ifPresent(detailVo::setItemType2Name);

                // 获取价格
                List<PriPriceRpcDTO> priPriceRpcDTOS = priceMap.get(SysUtils.getItemKey(scpCartDO.getCombineItemCode(), scpCartDO.getItemCode()));
                if (CollUtil.isNotEmpty(priPriceRpcDTOS)) {
                    detailVo.setItemPrice(priPriceRpcDTOS.get(0).getPrice());
                }
                if(scpCartDO.getCombineItemFlag()!=null && scpCartDO.getCombineItemFlag()&&StringUtils.isEmpty(scpCartDO.getCombineItemCode())){
                    List<PriPriceRpcDTO> priPriceRpcDTOS2 = priceMap.get(SysUtils.getItemKey(scpCartDO.getItemCode(), scpCartDO.getItemCode()));
                    if (CollUtil.isNotEmpty(priPriceRpcDTOS2)) {
                        detailVo.setItemPrice(priPriceRpcDTOS2.get(0).getPrice());
                    }
                }
                //添加数量赋值
                detailVo.setQty(SysUtils.processStoreQtyScale(scpCartDO.getQty()));
                detailVo.setCombineQty(SysUtils.processStoreQtyScale(scpCartDO.getCombineQty()));

                detailVo.setStatus(scpCartDO.getSelectedStatus());
                detailVo.setUom2(scpCartDO.getUom2());
                detailVo.setUom2Name(scpCartDO.getUom2Name());
                detailVo.setDecimalPlaces(scpCartDO.getDecimalPlaces());
                detailVo.setUomRatio(scpCartDO.getUomRatio());
                detailVo.setItemAttrName(scpCartDO.getItemAttrName());
                detailVo.setActivityItemFlag(scpCartDO.getActivityItemFlag());
                detailVo.setActivityCode(scpCartDO.getActivityCode());
                detailVo.setActivityId(scpCartDO.getActivityId());
                detailVo.setMinNum(scpCartDO.getMinNum());
                // 查询库存信息
                if (stockMap.containsKey(scpCartDO.getItemCode())) {
                    detailVo.setAvalQty(stockMap.get(scpCartDO.getItemCode()));
                } else {
                    detailVo.setAvalQty(BigDecimal.ZERO);
                }
                detailVo.setMoq(scpCartDO.getMoq());
                itemSpecObjectVOS.add(detailVo);
            }
            vo.setItemSpecObjectVOS(itemSpecObjectVOS);
            boolean allSelected = itemSpecObjectVOS.stream()
                    .allMatch(item -> item.getStatus() != null && item.getStatus().equals(1));
            vo.setStatus(allSelected ? 1 : 0);
            // 小计金额
            BigDecimal totalAmt = itemSpecObjectVOS.stream()
                    .filter(item -> ObjectUtil.isNotNull(item.getItemPrice()))
                    .map(CartDetailRespVO.ItemSpecObjectVO::getTotalAmt).filter(Objects::nonNull)
                    .reduce(BigDecimal.ZERO, BigDecimal::add);
            vo.setTotalAmt(totalAmt);
            vo.setInOrderCycle(storeCartDO.getInOrderCycle());
            resultList.add(vo);
        }
        //刷新购物车价格
        refreshCartPrice(paramVO, currentUserId, cartDOS, priceMap);

        // 组合商品处理
        List<CartDetailRespVO> itemResultList = resultList.stream().filter(d -> StringUtils.isBlank(d.getCombineItemCode())).collect(Collectors.toList());
        Map<String, List<CartDetailRespVO>> subItemMap = resultList.stream().filter(d -> StringUtils.isNotBlank(d.getCombineItemCode())).collect(Collectors.groupingBy(CartDetailRespVO::getCombineItemCode));
        if (CollectionUtils.isNotEmpty(itemResultList)) {
            List<CartDetailRespVO> combineItemList =  itemResultList.stream().filter(a -> Objects.nonNull(a.getCombineItemFlag()) && a.getCombineItemFlag())
                    .collect(Collectors.toList());
            combineItemList.forEach(d -> {
                List<CartDetailRespVO> subItemList = new ArrayList<>();
                d.getItemSpecObjectVOS().forEach(item -> {
                    List<CartDetailRespVO> cartDetailRespVOS = subItemMap.get(item.getItemCode());
                    subItemList.addAll(cartDetailRespVOS);
                });
                d.setSubItemList(subItemList);

                BigDecimal mainStkQty = BigDecimal.ZERO;
                for (int i = 0; i < d.getSubItemList().size(); i++) {
                    CartDetailRespVO detail = d.getSubItemList().get(i);
                    if (detail == null) continue;

                    // 库存数据设置
                    BigDecimal avalQty = stockMap.getOrDefault(detail.getItemSpecObjectVOS().get(0).getItemCode(), BigDecimal.ZERO);

                    // 主商品库存计算
                    if (Boolean.TRUE.equals(detail.getCombineItemFlag())) {
                        BigDecimal qty = detail.getCombineQty();
                        // 若 qty 为 0，divide 不执行，避免异常
                        if (qty != null && qty.compareTo(BigDecimal.ZERO) != 0) {
                            BigDecimal divide = avalQty.divide(qty, 0, RoundingMode.FLOOR);
                            if (i == 0) {
                                mainStkQty = divide;
                            } else {
                                if (divide.compareTo(mainStkQty) < 0) {
                                    mainStkQty = divide;
                                }
                            }
                        }
                    }
                }

                if (d.getCombineItemFlag() != null && d.getCombineItemFlag()) {
                    d.getItemSpecObjectVOS().get(0).setAvalQty(mainStkQty);
                }
            });
            List<Long> spuIds = itemResultList.stream().map(CartDetailRespVO::getSpuId)
                    .filter(Objects::nonNull).distinct().collect(Collectors.toList());
            List<ItmItemAttachmentProviderDTO> skuImgByItemIds = itmItemRpcService.findSkuImgByItemIds(spuIds);
            if (CollectionUtils.isNotEmpty(skuImgByItemIds)) {
                Map<Long, List<ItmItemAttachmentProviderDTO>> listMap = skuImgByItemIds.stream().collect(Collectors.groupingBy(ItmItemAttachmentProviderDTO::getItemId));
                itemResultList.forEach(d -> {
                    if (CollectionUtils.isNotEmpty(listMap.get(d.getSpuId()))) {
                        d.setFileCode(listMap.get(d.getSpuId()).get(0).getFileCode());
                    }
                });
            }
        }
        return itemResultList;
    }

    /**
     * 刷新购物车价格
     *
     * @param paramVO
     * @param currentUserId
     * @param cartDOS
     * @param priceMap
     */
    private void refreshCartPrice(CartDetailParamVO paramVO, Long currentUserId, List<ScpStoreCartDO> cartDOS, Map<String, List<PriPriceRpcDTO>> priceMap) {
        var storeCartOps = cartRedisUtil.getStoreCartOps(paramVO.getDemandWhStCode(), paramVO.getCartType(), currentUserId);
        for (ScpStoreCartDO cartDO : cartDOS) {
            List<PriPriceRpcDTO> priceRpcDTOS = priceMap.get(cartDO.getItemCode());
            if (CollUtil.isNotEmpty(priceRpcDTOS)) {
                cartDO.setItemPrice(SysUtils.processPriceScale(priceRpcDTOS.get(0).getPrice()));
            }
            storeCartOps.put(SysUtils.generateRedisKey(ScpConstant.SKU, cartDO.getCombineItemCode(), cartDO.getItemCode()), JSONUtil.toJsonStr(cartDO));
        }
    }

    @Override
    public Map<String, Integer> getCartCount(StoreCartQueryParamVO param) {
        Map<String, Integer> result = new HashMap<>();
        Long currentUserId = UserService.currentUserId();
        List<ScpOrderSettingRespVO> enabledSettings = scpOrderSettingDomainService.findEnabledSetting();
        for (ScpOrderSettingRespVO setting : enabledSettings) {
            List<ScpStoreCartDO> cartDOS = cartRedisUtil.getStoreCartItems(param.getDemandWhStCode(), setting.getDocType(), currentUserId);
            //过滤子品
            cartDOS= cartDOS.stream().filter(cartDO -> StringUtils.isBlank(cartDO.getCombineItemCode())).collect(Collectors.toList());
            result.put(setting.getDocType(), CollUtil.isNotEmpty(cartDOS) ? cartDOS.size() : 0);
        }
        result.values().stream().reduce(Integer::sum).ifPresent(total -> result.put("total", total));
        return result;
    }

    @Override
    public String saveCart(StoreCartSaveVO cartSaveVO) {

        // 判断当前商品是否在订货周期内
        ScpOrderSettingParamVO scpOrderSettingParamVO = new ScpOrderSettingParamVO();
        scpOrderSettingParamVO.setItemCate(cartSaveVO.getItemType());
        List<ScpOrderSettingRespVO> scpOrderSettingRespVOS = scpOrderSettingService.queryOrderSettingList(scpOrderSettingParamVO);
        if(!CollUtil.isEmpty(scpOrderSettingRespVOS)){
            cartSaveVO.setDocType(scpOrderSettingRespVOS.get(0).getDocType());
        }
        String key = cartSaveVO.getDemandWhStCode() + cartSaveVO.getDocType() + LocalDate.now().getYear() + getTwoDigitMonth() + LocalDate.now().getDayOfMonth();
        List<ScpStoreDemandCalendarDO> existList = storeDemandCalendarDomainService.findByStoreDayCalendar(List.of(key));
        String msg = "";
        if (CollUtil.isEmpty(existList) || existList.get(0).getWorkStatus().equals("E")) {
            msg = "该商品["+cartSaveVO.getItemName()+"]不在订货周期，无法下单";
        }
        Long currentUserId = UserService.currentUserId();
        // 要操作的购物车信息
        var cartOps = cartRedisUtil.getStoreCartOps(cartSaveVO.getDemandWhStCode(), cartSaveVO.getCartType(), currentUserId);
        saveOrUpdateCart(cartSaveVO, cartOps);
//        Map<Long, BigDecimal> result = new HashMap<>();
//        result.put(cartSaveVO.getItemId(), cartSaveVO.getQty());
        return msg;
    }

    @Override
    public void clearCart(CartClearParamVO clearParamVO) {

        Long currentUserId = UserService.currentUserId();
        // 要操作的购物车信息
        var cartOps = cartRedisUtil.getStoreCartOps(clearParamVO.getDemandWhStCode(), clearParamVO.getCartType(), currentUserId);
        //清空购物车
        Set<Object> keys = cartOps.keys();
        if (CollUtil.isNotEmpty(keys)) {
            cartOps.delete(keys.toArray());
        }
    }

    private String getTwoDigitMonth() {
        LocalDate date = LocalDate.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MM");
        return date.format(formatter);
    }

    @Override
    public String batchSaveCart(String storeCode, String cartType, List<StoreCartSaveVO> cartSaveVOS) {

        // 判断当前商品是否在订货周期内
        ScpOrderSettingParamVO scpOrderSettingParamVO = new ScpOrderSettingParamVO();
        List<ScpOrderSettingRespVO> scpOrderSettingRespVOS = scpOrderSettingService.queryOrderSettingList(scpOrderSettingParamVO);
        cartSaveVOS.forEach(cartSaveVO -> {
            scpOrderSettingRespVOS.stream().filter(scpOrderSettingRespVO -> scpOrderSettingRespVO.getItemCates().contains(cartSaveVO.getItemType()))
                    .findAny().ifPresent(a -> {
                        cartSaveVO.setDocType(a.getDocType());
                    });
        });
        List<String> keyList = cartSaveVOS.stream().map(cartSaveVO -> cartSaveVO.getDemandWhStCode() + cartSaveVO.getDocType() + LocalDate.now().getYear() + getTwoDigitMonth() + LocalDate.now().getDayOfMonth()).collect(toList());
        List<ScpStoreDemandCalendarDO> existList = storeDemandCalendarDomainService.findByStoreDayCalendar(keyList);
        List<String> itemNameList = new ArrayList<>();
        if(CollUtil.isEmpty(existList)){
            itemNameList = cartSaveVOS.stream().map(StoreCartSaveVO::getItemName).collect(toList());
        }

        List<String> finalItemNameList = itemNameList;
        cartSaveVOS.forEach(cartSaveVO -> {
            Optional<ScpStoreDemandCalendarDO> e = existList.stream().filter(a -> a.getStoreCode().equals(cartSaveVO.getDemandWhStCode())
                    && a.getItemType2().equals(cartSaveVO.getDocType()))
                    .findAny();
            if(e.isEmpty()){
                finalItemNameList.add(cartSaveVO.getItemName());
            }
            if(e.isPresent() && e.get().getWorkStatus().equals("E")){
                finalItemNameList.add(cartSaveVO.getItemName());
            }
        });
        Long currentUserId = UserService.currentUserId();
        //强配活动商品加购
        addAllocActivityItems(storeCode, cartType, cartSaveVOS);
        // 要操作的购物车信息
        var cartOps = cartRedisUtil.getStoreCartOps(storeCode, cartType, currentUserId);
        cartSaveVOS.forEach(cartSaveVO -> {
            saveOrUpdateCart(cartSaveVO, cartOps);
        });
        if(CollUtil.isNotEmpty(itemNameList)){
            return "该商品["+itemNameList+"]不在订货周期，无法下单";
        }
        return "";
    }

    private void addAllocActivityItems(String storeCode, String cartType, List<StoreCartSaveVO> cartSaveVOS) {
        List<String> itemTypes = cartSaveVOS.stream().map(StoreCartSaveVO::getItemType).distinct().collect(toList());
        List<ScpAllocSettingItemRespVO> allocSettingItemList = scpAllocSettingItemDomainService
                .getEnableAllocSettingItemByStoreCode(storeCode,
                        cartType, itemTypes);
        log.info("购物车添加强配商品：{}", JSON.toJSONString(allocSettingItemList));
        if(CollUtil.isNotEmpty(allocSettingItemList)){
            List<Long> existActivityAllocItemIds = cartSaveVOS.stream().filter(d -> Boolean.TRUE.equals(d.getActivityItemFlag()))
                    .map(StoreCartSaveVO::getItemId).toList();
            //查询未添加的强配商品
            allocSettingItemList = allocSettingItemList.stream()
                    .filter(d -> !existActivityAllocItemIds.contains(d.getItemId())).toList();
            if(CollUtil.isNotEmpty(allocSettingItemList)){
                List<Long> itemIds = allocSettingItemList.stream().map(d -> d.getItemId()).distinct().toList();
                ItmItemBaseRpcParam itmItemBaseRpcParam = new ItmItemBaseRpcParam();
                itmItemBaseRpcParam.setItemIds(itemIds);
                List<ItmItemBaseRpcDTO> itemList = rmiItemService.findItemBaseRpcDtoByParam(itmItemBaseRpcParam);
                Map<Long, ItmItemBaseRpcDTO> itemMap = itemList.stream().collect(Collectors.toMap(ItmItemBaseRpcDTO::getId, Function.identity()));
                List<StoreCartSaveVO> allocItemList = allocSettingItemList.stream().map(row -> {
                    ItmItemBaseRpcDTO itmItemBaseRpcDTO = itemMap.get(row.getItemId());
                    StoreCartSaveVO storeCartSaveVO = new StoreCartSaveVO();
                    storeCartSaveVO.setItemId(row.getItemId());
                    storeCartSaveVO.setDemandWhStCode(storeCode);
                    storeCartSaveVO.setCartType(cartType);
                    storeCartSaveVO.setItemCode(itmItemBaseRpcDTO.getItemCode());
                    storeCartSaveVO.setItemName(itmItemBaseRpcDTO.getItemName());
                    storeCartSaveVO.setAnotherName(itmItemBaseRpcDTO.getAnotherName());
                    storeCartSaveVO.setUom(itmItemBaseRpcDTO.getUom2());
                    storeCartSaveVO.setUomName(itmItemBaseRpcDTO.getUom2Name());
                    storeCartSaveVO.setSpuId(itmItemBaseRpcDTO.getSpuId());
                    storeCartSaveVO.setSpuCode(itmItemBaseRpcDTO.getSpuCode());
                    storeCartSaveVO.setSpuName(itmItemBaseRpcDTO.getSpuName());
                    storeCartSaveVO.setSpec(itmItemBaseRpcDTO.getSpec());
                    storeCartSaveVO.setQty(row.getMinNum());
                    storeCartSaveVO.setUom2(itmItemBaseRpcDTO.getUom2());
                    storeCartSaveVO.setUom2Name(itmItemBaseRpcDTO.getUom2Name());
                    storeCartSaveVO.setUomRatio(itmItemBaseRpcDTO.getUomRatio2());
                    storeCartSaveVO.setDecimalPlaces(itmItemBaseRpcDTO.getDecimalPlaces());
                    storeCartSaveVO.setItemType(itmItemBaseRpcDTO.getItemType2());
                    storeCartSaveVO.setItemAttrName(itmItemBaseRpcDTO.getItemAttrName());
                    storeCartSaveVO.setActivityCode(row.getActivityCode());
                    storeCartSaveVO.setActivityId(row.getMasId());
                    storeCartSaveVO.setItemCateCode(itmItemBaseRpcDTO.getItemCateCode());
                    storeCartSaveVO.setMinNum(row.getMinNum());
                    storeCartSaveVO.setUrl(row.getImgUrl());
                    storeCartSaveVO.setAutoAddFlag(Boolean.TRUE);
                    storeCartSaveVO.setActivityItemFlag(Boolean.TRUE);
                    return storeCartSaveVO;
                }).toList();
                log.info("购物车添加强配商品：{}", JSON.toJSONString(allocItemList));
                cartSaveVOS.addAll(allocItemList);
            }
        }
    }

    @Override
    public void deleteItem(CartDeleteItemParamVO paramVO) {
        Long currentUserId = UserService.currentUserId();
        for (CartDeleteItemParamVO.ItemSpecObjectVO vo : paramVO.getItemSpecObjectVOS()) {
            for (String itemKey : vo.getItemKeys()) {
                // 清空redis缓存
                var cartOps = cartRedisUtil.getStoreCartOps(paramVO.getDemandWhStCode(), paramVO.getCartType(), currentUserId);
                cartOps.delete(SysUtils.generateRedisKey(ScpConstant.SKU, itemKey));
            }
        }
    }

    @Override
    public CartDataSummaryRespVO dataSummary(CartDataSummaryParamVO paramVO) {
        Long currentUserId = UserService.currentUserId();
        List<ScpStoreCartDO> scpCartDOS = cartRedisUtil.getCheckedShoppingCartItems(paramVO.getDemandWhStCode(), paramVO.getCartType(), currentUserId);
        if (CollUtil.isEmpty(scpCartDOS)) {
            return new CartDataSummaryRespVO().setItemTypeNum(0).setQtyTotal(BigDecimal.ZERO).setAmtTotal(BigDecimal.ZERO);
        }
        //过滤子品
        List<ScpStoreCartDO> filteredCartDOS = scpCartDOS.stream().filter(a -> StringUtils.isBlank(a.getCombineItemCode())).collect(Collectors.toList());
        Map<String, List<ScpStoreCartDO>> spuMap =
                filteredCartDOS.stream().collect(Collectors.groupingBy(ScpStoreCartDO::getSpuCode));

        CartDataSummaryRespVO resultVo = new CartDataSummaryRespVO();
        resultVo.setItemTypeNum(spuMap.size());
        // 数量
        BigDecimal qty = filteredCartDOS.stream()
                .map(ScpStoreCartDO::getQty)
                .filter(Objects::nonNull) // 过滤掉qty为空的数据
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        //金额
        BigDecimal totalAmt = filteredCartDOS.stream().filter(item -> ObjectUtil.isNotNull(item.getItemPrice())).map(ScpStoreCartDO::getTotalAmt).filter(Objects::nonNull)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        resultVo.setQtyTotal(SysUtils.processQtyScale(qty));
        resultVo.setAmtTotal(SysUtils.processAmtScale(totalAmt));
        return resultVo;
    }

    @Override
    public void changeSelectedStatus(CartChangeSelectedStatusParamVO paramVO) {
        Long currentUserId = UserService.currentUserId();
        String demandWhStCode = paramVO.getDemandWhStCode();
        for (CartChangeSelectedStatusParamVO.ItemSpecObjectVO vo :
                paramVO.getItemSpecObjectVOS()) {
            for (CartChangeSelectedStatusParamVO.InnerItemSpecObjectVO item :
                    vo.getInnerItemSpecObjectVOS()) {
                if (item.getItemId() == null) {
                    throw new BusinessException("商品ID不能为空");
                }
                //查询购物车里面的商品
                ScpStoreCartDO cartItem = cartRedisUtil.getStoreCartItem(SysUtils.getItemKey(item.getCombineItemCode(), item.getItemCode()), demandWhStCode, paramVO.getCartType(), currentUserId);
                if (cartItem == null) {
                    log.error("购物车中不存在此物料：{},请刷新购物车重试", item.getItemId());
                    continue;
                }
                //修改商品选中状态
                cartItem.setSelectedStatus(item.getStatus());
                //序列化存入redis中
                String redisValue = JSON.toJSONString(cartItem);
                var cartOps = cartRedisUtil.getStoreCartOps(paramVO.getDemandWhStCode(), paramVO.getCartType(), currentUserId);
                cartOps.put(SysUtils.generateRedisKey(ScpConstant.SKU, item.getCombineItemCode(), item.getItemCode()), redisValue);
            }
        }
    }

    @Override
    public void changeSelectedStatusAll(CartChangeSelectedStatusAllParamVO paramVO) {
        Long currentUserId = UserService.currentUserId();
        List<ScpStoreCartDO> cartItems = cartRedisUtil.getStoreCartItems(paramVO.getDemandWhStCode(), paramVO.getCartType(), currentUserId);
        var cartOps = cartRedisUtil.getStoreCartOps(paramVO.getDemandWhStCode(), paramVO.getCartType(), currentUserId);

        //修改商品选中状态
        cartItems.forEach(row -> {
            row.setSelectedStatus(paramVO.getStatus());
            //序列化存入redis中
            String redisValue = JSON.toJSONString(row);
            cartOps.put(SysUtils.generateRedisKey(ScpConstant.SKU, row.getCombineItemCode(), row.getItemCode()), redisValue);
        });
    }

    @Override
    public void updateCount(CartCountParamVO cartCountParamVO) {
        Long currentUserId = UserService.currentUserId();
        var cartOps = cartRedisUtil.getStoreCartOps(cartCountParamVO.getDemandWhStCode(), cartCountParamVO.getCartType(), currentUserId);
        for (CartCountParamVO.ItemSpecObjectVO vo : cartCountParamVO.getItemSpecObjectVOS()) {
            for (CartCountParamVO.InnerItemSpecObjectVO itemSpecObjectVO : vo.getInnerItemSpecObjectVOS()) {
                if (itemSpecObjectVO.getItemId() == null) {
                    throw new BusinessException("商品ID不能为空");
                }
                // 购物车有此商品，修改数量即可
                String product = (String) cartOps.get(SysUtils.generateRedisKey(ScpConstant.SKU, itemSpecObjectVO.getCombineItemCode(), itemSpecObjectVO.getItemCode()));
                if (product == null) {
                    log.error("购物车中不存在此物料：{},请刷新购物车重试", itemSpecObjectVO.getItemId());
                    continue;
                }
                // 添加商品数量=0时，删除采购车商品
                if (itemSpecObjectVO.getQty().compareTo(BigDecimal.ZERO) == 0) {
                    cartOps.delete(SysUtils.generateRedisKey(ScpConstant.SKU, itemSpecObjectVO.getCombineItemCode(), itemSpecObjectVO.getItemCode()));
                } else {
                    var storeCartDO = JSON.parseObject(product, ScpStoreCartDO.class);
                    storeCartDO.setQty(itemSpecObjectVO.getQty());
                    String cartItemJson = JSON.toJSONString(storeCartDO);
                    // 购物车保存
                    cartOps.put(SysUtils.generateRedisKey(ScpConstant.SKU, itemSpecObjectVO.getCombineItemCode(), itemSpecObjectVO.getItemCode()), cartItemJson);
                }
            }
        }
    }

    @Override
    public OrderCheckRespVO order(OrderCheckParamVO paramVO) {
        OrderCheckRespVO resultVO = new OrderCheckRespVO();
        List<CartToOrderSuccessRespVO> successList = new ArrayList<>();
        List<CartToOrderFailRespVO> failList = new ArrayList<>();

        //根据门店+商品去查：
        //1、仓网关系接口，匹配出仓库，则返回前端展示成仓+品；
        //2、如果1找不到的情况下，调供应商配额接口，匹配出供应商，则返回前端展示成供应商+品；
        //3、如果上面1和2都找不到的情况下，后端返回信息说匹配不到仓或供应商，前端要根据后端返回的错误在前端进行商品行的置灰，控制用户下不了单。
        String demandWhStCode = paramVO.getDemandWhStCode();
        OrgStoreBaseRpcDTO orgStore = rmiOrgStoreRpcService.getOrgStoreBase(demandWhStCode);
        //获取单据类型配置
        ScpOrderSettingRespVO orderSetting = scpOrderSettingDomainService.findCacheByDocType(paramVO.getDocType(), ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode());
        if (orderSetting == null) {
            throw new BusinessException("请先配置或启用单据类型:" + paramVO.getDocType());
        }

        //获取当前用户信息
        Long currentUserId = UserService.currentUserId();
        List<ScpStoreCartDO> dataList = cartRedisUtil.getCheckedShoppingCartItems(paramVO.getDemandWhStCode(), paramVO.getDocType(), currentUserId);
        if (CollUtil.isEmpty(dataList)) {
            log.info("用户:{},购物车数据为空", currentUserId);
            return new OrderCheckRespVO();
        }
        //去掉组合品主品
        List<ScpStoreCartDO> filerCarts = dataList.stream().filter(row -> Objects.nonNull(row.getCombineItemFlag()) && row.getCombineItemFlag() && StringUtils.isEmpty(row.getCombineItemCode())).collect(Collectors.toList());
        dataList.removeAll(filerCarts);
        //查询强配商品
        addAllocSettingItem(currentUserId, demandWhStCode, orderSetting, dataList);
        //库存数量
        AtomicReference<Map<String, BigDecimal>> stockMapRef = new AtomicReference<>(new HashMap<>());
        List<String> itemCodes = dataList.stream().map(ScpStoreCartDO::getItemCode).collect(Collectors.toList());
        //获取仓网供应关系
        Map<String, List<ScpWhNetRelationRpcDTO>> whNetMap = scpWhNetRelationService.findWhNetByParam(demandWhStCode, ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode(), dataList);
        //获取供应商份额
        Map<String, List<ScpSupplyAllocationRpcDTO>> supplyAllocationMap = scpSupplyAllocationService.findSupplyAllocationByParam(demandWhStCode, ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode(), itemCodes);
        List<ItmPriPriceRpcDtoParam> priceParamList = new ArrayList<>();
        List<OrderConfirmRespVO> confirmRespVOS = new ArrayList<>();
        List<String> priorities = Arrays.asList(orderSetting.getFirstPriority(), orderSetting.getSecPriority());
        for (ScpStoreCartDO cartDO : dataList) {
            List<OrderConfirmRespVO> inConfirmList = new ArrayList<>();
            for (String priority : priorities) {
                if (ScpUdcEnum.ORDER_PRIORITY_SUPALLOC.getValueCode().equals(priority)) {
                    inConfirmList.addAll(suppAllocStrategy(cartDO, orgStore, orderSetting.getSuppFreightFlag(), supplyAllocationMap, priceParamList, stockMapRef));
                } else if (ScpUdcEnum.ORDER_PRIORITY_WHNET.getValueCode().equals(priority)) {
                    inConfirmList.addAll(whnetStrategy(cartDO, orgStore, orderSetting.getWhnetFreightFlag(), whNetMap, priceParamList));
                }
                if (!inConfirmList.isEmpty()) {
                    confirmRespVOS.addAll(inConfirmList);
                    break;
                }
            }
        }
        // 物料数量
        BigDecimal dataNum = confirmRespVOS.stream().filter(e->e.getFreightFlag().equals(true))
                .map(OrderConfirmRespVO::getDemandQuantity)
                .filter(qty -> qty != null)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
//        // 物料数量
//        BigDecimal dataNum = dataList.stream()
//                .map(ScpStoreCartDO::getQty)
//                .filter(qty -> qty != null)
//                .reduce(BigDecimal.ZERO, BigDecimal::add);
        // 校验是否低于起订数量
        Boolean gtFreeFreightNum = checkGtFreeFreightNum(orgStore,orderSetting,dataNum);
        BigDecimal freightPriceAll = BigDecimal.ZERO;
        BigDecimal freightPrice = BigDecimal.ZERO;
        // 如果检查为达到起订量，并且不是确认提交，直接返回未达到起订量
        if(!gtFreeFreightNum){
            // 按照低于起订量付款
            Integer freeFreightNum = orgStore.getFreeFreightNum();
            BigDecimal fillFreightPrice = orgStore.getFillFreightPrice();
            freightPriceAll = fillFreightPrice.multiply(BigDecimal.valueOf(freeFreightNum));
            if(paramVO.getConfirmFlag()){
                // 没有达到起订量
                OrderCheckRespVO orderCheckRespVO = new OrderCheckRespVO();
                orderCheckRespVO.setGtFreeFreightNum(false);
                orderCheckRespVO.setFreeFreightNum(freeFreightNum);// 起订量
                orderCheckRespVO.setFillFreightPrice(fillFreightPrice);// 起订量单价
                orderCheckRespVO.setFillFreightTotal(freightPriceAll);// 起订量总价
                return orderCheckRespVO;
            }else{
                if(freeFreightNum==null || freeFreightNum==0){
                    throw new BusinessException("门店起订数量和补运费单价不能为空！");
                }
                // 单价
                freightPrice = freightPriceAll.divide(dataNum,2, RoundingMode.HALF_UP);
            }
        }
        //构建拆分行map
        Map<String, List<OrderConfirmRespVO>> confirmMap = buildConfirmMap(confirmRespVOS);
        InvWhItemTotalStkRpcParam stockParam = buildStockParam(confirmRespVOS);
        CompletableFuture<List<PriPriceRpcDTO>> future1 = CompletableFuture.supplyAsync(() -> {
            if (CollUtil.isEmpty(priceParamList)) {
                return new ArrayList<>();
            } else {
                return rmiPriceRpcService.findPriceByParam(priceParamList);
            }
        }, taskExecutor);

        //查询组合品价格
        List<ItmBomPriceRpcDtoParam> param = new ArrayList<>();
        List<ScpStoreCartDO> scpStoreCartDOList =  dataList.stream().filter(item -> StringUtils.isNotEmpty(item.getCombineItemCode())).collect(Collectors.toList());
        scpStoreCartDOList.forEach(item -> {
            ItmBomPriceRpcDtoParam item2  = new ItmBomPriceRpcDtoParam();
            item2.setItemCode(item.getItemCode());
            item2.setCombineItemCode(item.getCombineItemCode());
            item2.setUom(item.getUom());
            param.add(item2);
        });
        CompletableFuture<List<PriPriceRpcDTO>> subItemPriceFuture1 = CompletableFuture.supplyAsync(() -> {
            if (CollUtil.isEmpty(priceParamList)) {
                return new ArrayList<>();
            } else {
                return rmiPriceRpcService.findBomPriceByParam(param);
            }
        }, taskExecutor);

        CompletableFuture<Void> future2 = CompletableFuture.runAsync(() -> getWhStockMap(stockParam, stockMapRef,confirmRespVOS), taskExecutor);
        List<ScpStoreCartDO> finalDataList = dataList;
        CompletableFuture<Map<String, List<ItmItemSpuBusinessRpcDTO>>> future3 = CompletableFuture.supplyAsync(() -> getItemMoq(orgStore.getOuCode(), finalDataList), taskExecutor);
        CompletableFuture.allOf(future1, future2, future3 ,subItemPriceFuture1).join();
        //构建价格行map
        List<PriPriceRpcDTO> priceList = new ArrayList<>();
        Map<String, List<ItmItemSpuBusinessRpcDTO>> itemMoqMap = new HashMap<>();
        try {
            priceList = future1.get();
            priceList.addAll(subItemPriceFuture1.get());
            itemMoqMap = future3.get();
        } catch (Exception e) {
            log.info("查询价格和商品最小起订量报错：{}", e);
            throw new BusinessException("查询价格和商品最小起订量报错：" + e.toString());
        }
        //校验moq
        Map<String, List<ScpStoreCartDO>> itemMap = dataList.stream().collect(Collectors.groupingBy(ScpStoreCartDO::getSpuCode));
        for (Map.Entry<String, List<ScpStoreCartDO>> entry : itemMap.entrySet()) {
            String spuCode = entry.getKey();
            List<ScpStoreCartDO> list = entry.getValue();
            if (!itemMoqMap.containsKey(spuCode)) {
                continue;
            }
            if (list.get(0).getActivityCode() != null) {
                continue;
            }
            ItmItemSpuBusinessRpcDTO itemInfo = itemMoqMap.get(spuCode).get(0);
            BigDecimal totalQty = list.stream().map(ScpStoreCartDO::getQty).collect(Collectors.reducing(BigDecimal.ZERO, BigDecimal::add));
            if (itemInfo.getMoq() != null && totalQty.compareTo(itemInfo.getMoq()) < 0) {
                throw new BusinessException("商品：" + list.get(0).getItemName() + "小于最小起订量");
            }
        }

        Map<String, List<PriPriceRpcDTO>> priceMap = buildPriceMap(priceList, priceParamList);
        Map<String, BigDecimal> stockMap = stockMapRef.get();
        //封装返回结果
        Map<String, List<ScpStoreCartDO>> spuCodeMap =
                dataList.stream().collect(Collectors.groupingBy(a->a.getSpuCode()+"@"+a.getCombineItemCode()));
        List<ScpDemandOrderDSaveVO> saveVOList = new ArrayList<>();
        List<ScpDemandOrderDSaveVO> saveGiftVOList = new ArrayList<>();
        AtomicReference<BigDecimal> goodAmt = new AtomicReference<>(BigDecimal.ZERO);
        //查询运费模板列表（查询门店为目标门店，或者门店为ALL的所有模板）
        ScpStoreOrderFreightPageParamVO orderFreightModelQueryParam = new ScpStoreOrderFreightPageParamVO();
        orderFreightModelQueryParam.setStoreCodes(Arrays.asList("ALL",demandWhStCode));
        List<ScpStoreOrderFreightPageRespVO> orderFreightModels = scpStoreOrderFreightService.listStoreOrderFreight(orderFreightModelQueryParam);
        // 计算是否免运费
        Boolean freeFreightFlag = calculateFreeFreightFlag(paramVO.getDocType(),dataList);
        BigDecimal freightAdd = BigDecimal.ZERO;
        BigDecimal qtyAdd =BigDecimal.ZERO;
        for (Map.Entry<String, List<ScpStoreCartDO>> entry : spuCodeMap.entrySet()) {
            ScpStoreCartDO first = entry.getValue().get(0);
            CartToOrderSuccessRespVO successVO = new CartToOrderSuccessRespVO();
            successVO.setSpuId(first.getSpuId());
            successVO.setSpuCode(first.getSpuCode());
            successVO.setSpuName(first.getSpuName());
            successVO.setAnotherName(first.getAnotherName());
            successVO.setSpec(first.getSpec());
            successVO.setUrl(first.getUrl());
            successVO.setCombineItemFlag(first.getCombineItemFlag());
            successVO.setCombineItemCode(first.getCombineItemCode());
            successVO.setCombineItemName(first.getCombineItemName());

            List<CartToOrderSuccessRespVO.ItemSpecObjectVO> itemSpecObjectVOS = new ArrayList<>();
            for (ScpStoreCartDO scpCartDO : entry.getValue()) {
                String itemCode = scpCartDO.getItemCode();
                String activityCode = scpCartDO.getActivityCode();

                List<OrderConfirmRespVO> confirmList = confirmMap.get(itemCode +  scpCartDO.getCombineItemCode() + activityCode);
                if (CollUtil.isEmpty(confirmList)) {
                    //添加错误信息
                    CartToOrderFailRespVO failVO = new CartToOrderFailRespVO();
                    failVO.setItemCode(scpCartDO.getItemCode());
                    failVO.setItemName(scpCartDO.getItemName());
                    failVO.setMsg("匹配不到仓库或供应商");
                    failList.add(failVO);
                    continue;
                }
                List<CartToOrderSuccessRespVO.WhAllocObject> whAllocObjects = new ArrayList<>();
                for (OrderConfirmRespVO orderConfirmRespVO : confirmList) {
                    CartToOrderSuccessRespVO.WhAllocObject whAllocObject = new CartToOrderSuccessRespVO.WhAllocObject();
                    //供应商份额分配，如果销售公司无值，属于同公司，不需要带出含税单价，此行无需支付；
                    String ouCode = orderConfirmRespVO.getSaleOuCode();
                    if (StrUtil.isBlank(ouCode)) {
                        whAllocObject.setItemPrice(BigDecimal.ZERO);
                    } else {
                        List<PriPriceRpcDTO> priceRpcDTOS;
                        if(StringUtils.isNotEmpty(scpCartDO.getCombineItemCode())){
                            priceRpcDTOS = priceMap.get(orderConfirmRespVO.getItemCode() + "@" + scpCartDO.getCombineItemCode() + "@" +null);
                        }else {
                            priceRpcDTOS = priceMap.get(orderConfirmRespVO.getItemCode() + "@" + null + "@" +ouCode);
                        }
                        if (CollUtil.isNotEmpty(priceRpcDTOS)) {
                            whAllocObject.setItemPrice(priceRpcDTOS.get(0).getPrice());
                        } else {
                            log.info("该商品无价格, 编码:{},名称:{}", itemCode, scpCartDO.getItemName());
                            //添加错误信息
                            CartToOrderFailRespVO failVO = new CartToOrderFailRespVO();
                            failVO.setItemCode(scpCartDO.getItemCode());
                            failVO.setItemName(scpCartDO.getItemName());
                            failVO.setMsg("该商品无价格");
                            failList.add(failVO);
                            continue;
                        }
                    }
                    whAllocObject.setRatio(orderConfirmRespVO.getRatio());
                    whAllocObject.setQty(orderConfirmRespVO.getAllocationDeQuantity());
                    whAllocObject.setOuId(orderConfirmRespVO.getOuId());
                    whAllocObject.setOuCode(orderConfirmRespVO.getOuCode());
                    whAllocObject.setOuName(orderConfirmRespVO.getOuName());
                    whAllocObject.setSupplyType(orderConfirmRespVO.getSupplyType());
                    whAllocObject.setSupplyWhCode(orderConfirmRespVO.getSuppWhCode());
                    whAllocObject.setSupplyWhId(orderConfirmRespVO.getSuppWhId());
                    whAllocObject.setSupplyWhName(orderConfirmRespVO.getSuppWhName());
                    whAllocObject.setFreightFlag(orderConfirmRespVO.getFreightFlag());
//                    whAllocObject.setFreightRatio(orderConfirmRespVO.getFreightRatio());
                    whAllocObject.setSaleOuCode(orderConfirmRespVO.getSaleOuCode());
                    whAllocObject.setSaleOuName(orderConfirmRespVO.getSaleOuName());
                    whAllocObject.setSaleCustCode(orderConfirmRespVO.getSaleCustCode());
                    // 库存可供量
                    if (ScpUdcEnum.SUPPLY_DEMAND_TYPE_WH.getValueCode().equals(whAllocObject.getSupplyType())) {
                        if (stockMap != null && stockMap.containsKey(scpCartDO.getItemCode())) {
                            BigDecimal avalQty = stockMap.get(scpCartDO.getItemCode());
                            if (whAllocObject.getQty().compareTo(avalQty) > 0) {
                                if (StrUtil.isNotBlank(activityCode)) {
                                    continue;
                                } else {
                                    throw new BusinessException("商品【" + scpCartDO.getItemName() + "】库存可用量为:" + avalQty + ",不可超过该数量");
                                }
                            }
                            whAllocObject.setAvalQty(avalQty);
                        } else {
                            if (StrUtil.isBlank(activityCode)) {
                                throw new BusinessException("商品【" + scpCartDO.getItemName() + "】库存不足");
                            } else {
                                continue;
                            }
                        }
                    }
                    whAllocObjects.add(whAllocObject);
                    if(!freeFreightFlag){
                        BigDecimal currentFreightNum = BigDecimal.ZERO;
                        if(!gtFreeFreightNum){
                            // 未达到起订量，按照配置运费总额按比例计算运费
                            BigDecimal qty = whAllocObject.getQty();
                            qtyAdd = qtyAdd.add(qty);
                            if(qtyAdd.compareTo(dataNum)==0){
                                // 最后一次循环
                                currentFreightNum = freightPriceAll.subtract(freightAdd);
                            }else{
                                currentFreightNum = freightPrice.multiply(qty);
                                freightAdd = freightAdd.add(currentFreightNum);
                            }
                        }
                        //组装运费数据
                        buildSimpleOrderItem(scpCartDO, orderConfirmRespVO, whAllocObject, saveVOList,orderFreightModels,gtFreeFreightNum,currentFreightNum);
                    }
                    //组装一个赠品数据
                    buildSimpleGiftOrderItem(scpCartDO, whAllocObject, saveGiftVOList,orgStore,successList);
                }
                if (CollUtil.isEmpty(whAllocObjects)) {
                    continue;
                }
                CartToOrderSuccessRespVO.ItemSpecObjectVO itemSpecObjectVO = new CartToOrderSuccessRespVO.ItemSpecObjectVO();
                itemSpecObjectVO.setItemId(scpCartDO.getItemId());
                itemSpecObjectVO.setItemCode(scpCartDO.getItemCode());
                itemSpecObjectVO.setItemName(scpCartDO.getItemName());
                itemSpecObjectVO.setDemandQuantity(scpCartDO.getQty());
                itemSpecObjectVO.setUom(scpCartDO.getUom());
                itemSpecObjectVO.setUomName(scpCartDO.getUomName());
                itemSpecObjectVO.setUom2(scpCartDO.getUom2());
                itemSpecObjectVO.setUom2Name(scpCartDO.getUom2Name());
                itemSpecObjectVO.setDecimalPlaces(scpCartDO.getDecimalPlaces());
                itemSpecObjectVO.setUomRatio(scpCartDO.getUomRatio());
                itemSpecObjectVO.setItemType(scpCartDO.getItemType());
                itemSpecObjectVO.setItemAttrName(scpCartDO.getItemAttrName());
                itemSpecObjectVO.setActivityCode(activityCode);
                itemSpecObjectVO.setActivityId(scpCartDO.getActivityId());
                itemSpecObjectVO.setMinNum(scpCartDO.getMinNum());
                BigDecimal totalAmt = whAllocObjects.stream().map(CartToOrderSuccessRespVO.WhAllocObject::getAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
                itemSpecObjectVO.setTotalAmt(totalAmt);
                itemSpecObjectVO.setWhAllocObjects(whAllocObjects);
                itemSpecObjectVOS.add(itemSpecObjectVO);
                goodAmt.updateAndGet(v -> SysUtils.processAmtScale(v.add(totalAmt)));
            }
            if (CollUtil.isNotEmpty(itemSpecObjectVOS)) {
                successVO.setItemSpecObjectVOS(itemSpecObjectVOS);
                successList.add(successVO);
            }
        }
        // 运费计算
        if (CollUtil.isNotEmpty(saveVOList)) {
            buildFreightItem(saveVOList, resultVO, successList);
        }
        //商品金额
        resultVO.setGoodAmt(goodAmt.get());
        resultVO.setSuccess(successList);
        resultVO.setFail(failList);
        resultVO.setAllFailed(successList.size() == 0);
        //汇总信息
        Integer itemTypeNum = 0;
        AtomicReference<BigDecimal> qtyTotal = new AtomicReference<>(BigDecimal.ZERO);
        AtomicReference<BigDecimal> amtTotal = new AtomicReference<>(BigDecimal.ZERO);
        for (CartToOrderSuccessRespVO order : successList) {
            for (CartToOrderSuccessRespVO.ItemSpecObjectVO item : order.getItemSpecObjectVOS()) {
                itemTypeNum = itemTypeNum + 1;
                qtyTotal.updateAndGet(v -> v.add(item.getDemandQuantity()));
                amtTotal.updateAndGet(v -> v.add(item.getTotalAmt()));
            }
        }
        resultVO.setItemTypeNum(itemTypeNum);
        resultVO.setAmtTotal(SysUtils.processAmtScale(amtTotal.get()));
        resultVO.setQtyTotal(qtyTotal.get());
        return resultVO;
    }

    private Boolean checkGtFreeFreightNum(OrgStoreBaseRpcDTO orgStore,ScpOrderSettingRespVO orderSetting,BigDecimal sum) {
        if(sum.compareTo(BigDecimal.ZERO)==0) {
            return true;
        }
        // 门店详情- 按起订数量收取运费
        Boolean fillFreightFlag = orgStore.getFillFreightFlag();
        if(fillFreightFlag!=null && fillFreightFlag){
            // 是否应用起订量
            Boolean minOrderFlag = orderSetting.getMinOrderFlag();
            if(minOrderFlag!=null && minOrderFlag){
                ScpDemandOrderPageParamVO demandOrderPageParamVO = new ScpDemandOrderPageParamVO();
                demandOrderPageParamVO.setCreateTimeFrom(LocalDate.now().atStartOfDay());
                demandOrderPageParamVO.setDemandWhStCode(orgStore.getStoreCode());
                // 查询今天的订货单，判断是否是第一单
                PagingVO<ScpDemandOrderTitlePageRespVO> page = scpDemandOrderService.page(demandOrderPageParamVO);
                Boolean firstOrder = true;
                if(page.getRecords() != null && !page.getRecords().isEmpty()){
                    List<ScpDemandOrderTitlePageRespVO> pushedList = page.getRecords().stream().filter(e -> e.getIsPushed() != null && e.getIsPushed()).collect(toList());
                    if(CollectionUtils.isNotEmpty(pushedList)){
                        firstOrder = false;
                    }
                }
                if(firstOrder){
                    // 起订数量
                    Integer freeFreightNum = orgStore.getFreeFreightNum();
                    if(sum.compareTo(BigDecimal.valueOf(freeFreightNum))<0){
                        return false;
                    }
                }
            }
        }
        // 未匹配到配置或者达到了起订量时，都返回true
        return true;
    }

    private Boolean calculateFreeFreightFlag(String docType,List<ScpStoreCartDO> dataList) {
        //查询单据类型配置
        ScpOrderSettingRespVO scpOrderSettingRespVO;
        ScpOrderSettingParamVO orderSettingParamVO = new ScpOrderSettingParamVO();
        orderSettingParamVO.setDocType(docType);
        List<ScpOrderSettingRespVO> scpOrderSettingRespVOS = scpOrderSettingService.queryOrderSettingList(orderSettingParamVO);
        if(!CollUtil.isEmpty(scpOrderSettingRespVOS)) {
            scpOrderSettingRespVO = scpOrderSettingRespVOS.get(0);
        }else{
            scpOrderSettingRespVO = null;
        }
        // 判断是否需要计算运费
        // 根据单据类型判断免运费逻辑
        if(scpOrderSettingRespVO!=null) {
            if(scpOrderSettingRespVO.getFreeFreightFlag() && scpOrderSettingRespVO.getFreeFreightAmt()!=null){
                // 计算本次下单金额之和
                BigDecimal totalAmt = dataList.stream().filter(row -> row.getTotalAmt() != null).map(ScpStoreCartDO::getTotalAmt)
                        .collect(Collectors.reducing(BigDecimal.ZERO, BigDecimal::add));

                if(totalAmt.compareTo(scpOrderSettingRespVO.getFreeFreightAmt())>-1){
                    // 免运费
                    return true;
                }
            }
        }
        return false;
    }

    private Map<String, List<ItmItemSpuBusinessRpcDTO>> getItemMoq(String storeOuCode, List<ScpStoreCartDO> dataList) {
        List<String> spuCodes = dataList.stream().map(ScpStoreCartDO::getSpuCode).distinct().collect(Collectors.toList());
        Map<String, List<ItmItemSpuBusinessRpcDTO>> moqMap = rmiItemService.findMoqByParam(spuCodes, storeOuCode);
        return moqMap;
    }
    /**
     * 添加强配商品
     *
     * @param currentUserId
     * @param demandWhStCode
     * @param dataList
     */
    private void addAllocSettingItem(Long currentUserId, String demandWhStCode, ScpOrderSettingRespVO orderSetting, List<ScpStoreCartDO> dataList) {
        List<String> itemTypes = StrUtil.split(orderSetting.getItemCate(), ",");
        List<ScpAllocSettingItemRespVO> allocSettingItemList = scpAllocSettingItemDomainService.getEnableAllocSettingItemByStoreCode(demandWhStCode, orderSetting.getDocType(), itemTypes);
        if (CollUtil.isEmpty(allocSettingItemList)) {
            return;
        }
        Set<Long> existItemIds = dataList.stream()
                .map(ScpStoreCartDO::getItemId)
                .collect(Collectors.toSet());
        List<Long> itemIds = allocSettingItemList.stream()
                .map(ScpAllocSettingItemRespVO::getItemId)
                .filter(itemId -> !existItemIds.contains(itemId))
                .collect(Collectors.toList());
        if (CollUtil.isEmpty(itemIds)) {
            return;
        }
        ItmItemBaseRpcParam itmItemBaseRpcParam = new ItmItemBaseRpcParam();
        itmItemBaseRpcParam.setItemIds(itemIds);
        List<ItmItemBaseRpcDTO> itemList = rmiItemService.findItemBaseRpcDtoByParam(itmItemBaseRpcParam);
        if (CollUtil.isEmpty(itemList)) {
            return;
        }
        Map<Long, ItmItemBaseRpcDTO> itemMap = itemList.stream().collect(Collectors.toMap(ItmItemBaseRpcDTO::getId, Function.identity()));
        List<ScpStoreCartDO> allocItemList = allocSettingItemList.stream().map(row -> {
            ItmItemBaseRpcDTO itmItemBaseRpcDTO = itemMap.get(row.getItemId());
            ScpStoreCartDO storeCartDO = new ScpStoreCartDO();
            storeCartDO.setUserId(currentUserId);
            storeCartDO.setDemandWhStCode(demandWhStCode);
            storeCartDO.setItemId(row.getItemId());
            storeCartDO.setItemCode(itmItemBaseRpcDTO.getItemCode());
            storeCartDO.setItemName(itmItemBaseRpcDTO.getItemName());
            storeCartDO.setAnotherName(itmItemBaseRpcDTO.getAnotherName());
            storeCartDO.setUom(itmItemBaseRpcDTO.getUom2());
            storeCartDO.setUomName(itmItemBaseRpcDTO.getUom2Name());
            storeCartDO.setSpuId(itmItemBaseRpcDTO.getSpuId());
            storeCartDO.setSpuCode(itmItemBaseRpcDTO.getSpuCode());
            storeCartDO.setSpuName(itmItemBaseRpcDTO.getSpuName());
            storeCartDO.setSpec(itmItemBaseRpcDTO.getSpec());
            storeCartDO.setQty(row.getMinNum());
            storeCartDO.setSelectedStatus(1);
            storeCartDO.setUom2(itmItemBaseRpcDTO.getUom2());
            storeCartDO.setUom2Name(itmItemBaseRpcDTO.getUom2Name());
            storeCartDO.setUomRatio(itmItemBaseRpcDTO.getUomRatio2());
            storeCartDO.setDecimalPlaces(itmItemBaseRpcDTO.getDecimalPlaces());
            storeCartDO.setItemType(itmItemBaseRpcDTO.getItemType2());
            storeCartDO.setItemAttrName(itmItemBaseRpcDTO.getItemAttrName());
            storeCartDO.setActivityCode(row.getActivityCode());
            storeCartDO.setActivityId(row.getMasId());
            storeCartDO.setItemCateCode(itmItemBaseRpcDTO.getItemCateCode());
            storeCartDO.setMinNum(row.getMinNum());
            storeCartDO.setUrl(row.getImgUrl());
            return storeCartDO;
        }).collect(Collectors.toList());
        dataList.addAll(allocItemList);
    }

    private InvWhItemTotalStkRpcParam buildStockParam(List<OrderConfirmRespVO> confirmRespVOS) {
        if (CollUtil.isNotEmpty(confirmRespVOS)) {
            List<Long> itemIds = confirmRespVOS.stream().filter(row -> ScpUdcEnum.SUPPLY_DEMAND_TYPE_WH.getValueCode().equals(row.getSupplyType())).map(OrderConfirmRespVO::getItemId)
                    .filter(Objects::nonNull).distinct().collect(Collectors.toList());
            List<Long> whIds = confirmRespVOS.stream().filter(row -> ScpUdcEnum.SUPPLY_DEMAND_TYPE_WH.getValueCode().equals(row.getSupplyType())).map(OrderConfirmRespVO::getSuppWhId)
                    .filter(Objects::nonNull).distinct().collect(Collectors.toList());
            if (CollUtil.isEmpty(itemIds) || CollUtil.isEmpty(whIds)) {
                log.info("查询库存商品或者仓库为空，无需查询");
                return null;
            }
            InvWhItemTotalStkRpcParam invWhItemTotalStkRpcParam = new InvWhItemTotalStkRpcParam();
            invWhItemTotalStkRpcParam.setItemIds(itemIds);
            invWhItemTotalStkRpcParam.setWhIds(whIds);
            invWhItemTotalStkRpcParam.setExcludeDeter2Types(List.of(InvDeter2TypeEnum.TRANS.getType()));
            return invWhItemTotalStkRpcParam;
        }
        return null;
    }

    private void getWhStockMap(InvWhItemTotalStkRpcParam stkRpcParam, AtomicReference<Map<String, BigDecimal>> stockMap, List<OrderConfirmRespVO> confirmRespVOS) {
        if (stkRpcParam == null) {
            return;
        }

        Map<String, List<Long>> itemCodeAndWhId = confirmRespVOS.stream().filter(row -> ScpUdcEnum.SUPPLY_DEMAND_TYPE_WH.getValueCode().equals(row.getSupplyType())).collect(Collectors.groupingBy(OrderConfirmRespVO::getItemCode, Collectors.mapping(OrderConfirmRespVO::getSuppWhId, Collectors.toList())));
        List<InvWhItemTotalStkRpcDTO> invWhItemTotalStkRpcDTOS = rmiInvStkRpcService.queryInvWhItemTotalStk(stkRpcParam);
        if (CollUtil.isNotEmpty(invWhItemTotalStkRpcDTOS)) {
            for (InvWhItemTotalStkRpcDTO dto : invWhItemTotalStkRpcDTOS) {
                List<Long> longs = itemCodeAndWhId.get(dto.getItemCode());
                if (longs.contains(dto.getWhId())) {
                    stockMap.updateAndGet(currentMap -> {
                        currentMap.put(dto.getItemCode(), dto.getAvalQty2());
                        return currentMap;
                    });
                }
            }
        }
    }

    /**
     * 计算运费商品
     *
     * @param saveVOList
     * @param resultVO
     * @param successList
     */
    private void buildFreightItem(List<ScpDemandOrderDSaveVO> saveVOList, OrderCheckRespVO resultVO, List<CartToOrderSuccessRespVO> successList) {
        List<CartToOrderSuccessRespVO> freightItemList = new ArrayList<>();
        //门店订货单获取运费行商品
        String itemCode = SysUtils.getOrderItemSetting();
        String orderItemImgUrlSetting = SysUtils.getOrderItemImgUrlSetting();
        ItmItemBaseRpcParam itmItemBaseRpcParam = new ItmItemBaseRpcParam();
        itmItemBaseRpcParam.setItemCodes(Arrays.asList(itemCode));
        List<ItmItemBaseRpcDTO> itemBaseRpcDTOList = rmiItemService.findItemBaseRpcDtoByParam(itmItemBaseRpcParam);
        if (CollUtil.isEmpty(itemBaseRpcDTOList)) {
            throw new BusinessException("运费商品编码：" + itemCode + "不存在");
        }
        //运费商品
        ItmItemBaseRpcDTO shipmentItem = itemBaseRpcDTOList.get(0);
        Map<String, List<ScpDemandOrderDSaveVO>> whCodeMap = saveVOList.stream().collect(Collectors.groupingBy(row -> row.getSuppWhCode()));
        BigDecimal freightAmt = BigDecimal.ZERO;
        //门店订货单添加运费行，按照【要货门店】、【供应仓库】or【供应供应商】生成一行运费
        for (Map.Entry<String, List<ScpDemandOrderDSaveVO>> entry : whCodeMap.entrySet()) {
            List<ScpDemandOrderDSaveVO> list = entry.getValue();
            CartToOrderSuccessRespVO successVO = new CartToOrderSuccessRespVO();
            CartToOrderSuccessRespVO.ItemSpecObjectVO itemSpecObjectVO = new CartToOrderSuccessRespVO.ItemSpecObjectVO();
            CartToOrderSuccessRespVO.WhAllocObject whAllocObject = new CartToOrderSuccessRespVO.WhAllocObject();
            ScpDemandOrderDSaveVO oldSaveVO = list.get(0);
            BigDecimal amt = list.stream().filter(row -> row.getPlanAmt() != null).map(ScpDemandOrderDSaveVO::getPlanAmt)
                    .collect(Collectors.reducing(BigDecimal.ZERO, BigDecimal::add));
            whAllocObject.setItemPrice(SysUtils.processAmtScale(amt));
            whAllocObject.setRatio(oldSaveVO.getRatio());
            whAllocObject.setQty(BigDecimal.ONE);
            whAllocObject.setOuId(oldSaveVO.getOuId());
            whAllocObject.setOuCode(oldSaveVO.getOuCode());
            whAllocObject.setOuName(oldSaveVO.getOuName());
            whAllocObject.setSupplyType(oldSaveVO.getSupplyType());
            whAllocObject.setSupplyWhCode(oldSaveVO.getSuppWhCode());
            whAllocObject.setSupplyWhId(oldSaveVO.getSuppWhId());
            whAllocObject.setSupplyWhName(oldSaveVO.getSuppWhName());
            whAllocObject.setFreightFlag(oldSaveVO.getFreightFlag());
            whAllocObject.setFreightRatio(oldSaveVO.getFreightRatio());
            whAllocObject.setSaleOuCode(oldSaveVO.getSaleOuCode());
            whAllocObject.setSaleOuName(oldSaveVO.getSaleOuName());
            whAllocObject.setSaleCustCode(oldSaveVO.getSaleCustCode());
            List<CartToOrderSuccessRespVO.WhAllocObject> whAllocObjects = List.of(whAllocObject);

            itemSpecObjectVO.setItemId(shipmentItem.getId());
            itemSpecObjectVO.setItemCode(shipmentItem.getItemCode());
            itemSpecObjectVO.setItemName(shipmentItem.getItemName());
            itemSpecObjectVO.setDemandQuantity(BigDecimal.ONE);
            itemSpecObjectVO.setUom(shipmentItem.getUom2());
            itemSpecObjectVO.setUomName(shipmentItem.getUom2Name());
            itemSpecObjectVO.setUom2(shipmentItem.getUom());
            itemSpecObjectVO.setUom2Name(shipmentItem.getUomName());
            itemSpecObjectVO.setDecimalPlaces(shipmentItem.getDecimalPlaces());
            itemSpecObjectVO.setUomRatio(shipmentItem.getUomRatio2());
            itemSpecObjectVO.setItemType(shipmentItem.getItemType2());
            itemSpecObjectVO.setItemAttrName(shipmentItem.getItemAttrName());
            itemSpecObjectVO.setTotalAmt(whAllocObject.getItemPrice());
            itemSpecObjectVO.setWhAllocObjects(whAllocObjects);

            List<CartToOrderSuccessRespVO.ItemSpecObjectVO> itemSpecObjectVOS = List.of(itemSpecObjectVO);

            successVO.setSpuId(shipmentItem.getSpuId());
            successVO.setSpuCode(shipmentItem.getSpuCode());
            successVO.setSpuName(shipmentItem.getSpuName());
            successVO.setAnotherName(shipmentItem.getAnotherName());
            successVO.setSpec(shipmentItem.getSpec());
            successVO.setUrl(orderItemImgUrlSetting);

            if (CollUtil.isNotEmpty(itemSpecObjectVOS)) {
                successVO.setItemSpecObjectVOS(itemSpecObjectVOS);
                freightItemList.add(successVO);
            }
            freightAmt = SysUtils.processAmtScale(freightAmt.add(amt));
        }
        //运费金额
        resultVO.setFreightAmt(freightAmt);
        successList.addAll(freightItemList);
    }

    /**
     * 构建简单订单明细
     * （运费）
     *
     * @param scpCartDO
     * @param orderConfirmRespVO
     * @param whAllocObject
     * @param saveVOList
     */
    private static void buildSimpleOrderItem(ScpStoreCartDO scpCartDO, OrderConfirmRespVO orderConfirmRespVO, CartToOrderSuccessRespVO.WhAllocObject whAllocObject,
                                             List<ScpDemandOrderDSaveVO> saveVOList,List<ScpStoreOrderFreightPageRespVO> orderFreightModels,Boolean gtFreeFreightNum,BigDecimal objFreight) {
        ScpDemandOrderDSaveVO scpDemandOrderDSaveVO = new ScpDemandOrderDSaveVO();
        scpDemandOrderDSaveVO.setAllocationDeQuantity(whAllocObject.getQty());
        scpDemandOrderDSaveVO.setRatio(whAllocObject.getRatio());
        scpDemandOrderDSaveVO.setSupplyType(whAllocObject.getSupplyType());
        scpDemandOrderDSaveVO.setSuppWhId(whAllocObject.getSupplyWhId());
        scpDemandOrderDSaveVO.setSuppWhCode(whAllocObject.getSupplyWhCode());
        scpDemandOrderDSaveVO.setSuppWhName(whAllocObject.getSupplyWhName());
        scpDemandOrderDSaveVO.setDemandQuantity(whAllocObject.getQty());
        scpDemandOrderDSaveVO.setPrice(whAllocObject.getItemPrice());
        scpDemandOrderDSaveVO.setOuId(whAllocObject.getOuId());
        scpDemandOrderDSaveVO.setOuCode(whAllocObject.getOuCode());
        scpDemandOrderDSaveVO.setOuName(whAllocObject.getOuName());
        scpDemandOrderDSaveVO.setIsCalculated(Boolean.FALSE);
        scpDemandOrderDSaveVO.setIsPushed(Boolean.FALSE);
        scpDemandOrderDSaveVO.setUom2(scpCartDO.getUom2());
        scpDemandOrderDSaveVO.setUom2Name(scpCartDO.getUom2Name());
        scpDemandOrderDSaveVO.setUomRatio(scpCartDO.getUomRatio());
        // 如果运费是否计费字段为null则返回
        if (!(orderConfirmRespVO.getFreightFlag())) {
            return;
        }
        if (StrUtil.isBlank(orderConfirmRespVO.getSaleOuCode())) {
            return;
        }
        // 计算运费
        String supplyType = orderConfirmRespVO.getSupplyType();
        String whCode = orderConfirmRespVO.getSuppWhCode();//仓库code
        String storeCode = scpCartDO.getDemandWhStCode();//门店code
        String  itemCode = scpCartDO.getItemCode();//商品code
        ScpStoreOrderFreightPageRespVO matchedConfig = getMatchedOrderFreightConfig(supplyType,whCode,storeCode,itemCode,orderFreightModels);
        BigDecimal planAmount = BigDecimal.ZERO;
        BigDecimal freightRate = BigDecimal.ZERO;
        if(!gtFreeFreightNum){
            // 分摊运费
            planAmount=objFreight;
            freightRate =planAmount.divide(whAllocObject.getAmt(), 8, RoundingMode.HALF_UP);
        }else{
            if(matchedConfig.getFreightRate()!=null) {
                // 按比例收取
                planAmount = SysUtils.processAmtScale(whAllocObject.getAmt().multiply(matchedConfig.getFreightRate().divide(BigDecimal.valueOf(100L))));
                freightRate = matchedConfig.getFreightRate().divide(BigDecimal.valueOf(100L));
            }else if(matchedConfig.getAmountPerQuantity()!=null) {
                // 固定收取
                planAmount=matchedConfig.getAmountPerQuantity().multiply(whAllocObject.getQty());
                freightRate =planAmount.divide(whAllocObject.getAmt(), 8, RoundingMode.HALF_UP);
            };
        }
        whAllocObject.setFreightRatio(freightRate);
        whAllocObject.setFreightAmt(planAmount);
        scpDemandOrderDSaveVO.setPlanAmt(planAmount);
        scpDemandOrderDSaveVO.setFreightFlag(whAllocObject.getFreightFlag());
        scpDemandOrderDSaveVO.setFreightRatio(whAllocObject.getFreightRatio());
        scpDemandOrderDSaveVO.setSaleCustCode(whAllocObject.getSaleCustCode());
        scpDemandOrderDSaveVO.setSaleOuCode(whAllocObject.getSaleOuCode());
        scpDemandOrderDSaveVO.setSaleOuName(whAllocObject.getSaleOuName());
        saveVOList.add(scpDemandOrderDSaveVO);
    }

    /**
     * 构建简单订单明细
     * （赠品）
     *
     * @param scpCartDO
     * @param whAllocObjectMain
     */
    private void buildSimpleGiftOrderItem(ScpStoreCartDO scpCartDO, CartToOrderSuccessRespVO.WhAllocObject whAllocObjectMain, List<ScpDemandOrderDSaveVO> saveGiftVOList,OrgStoreBaseRpcDTO orgStore,List<CartToOrderSuccessRespVO> successList) {
        //门店code,查询买赠促销配置
        MktDiscountGiftRpcParam mktDiscountGiftRpcParam = new MktDiscountGiftRpcParam();
        mktDiscountGiftRpcParam.setItemCode(scpCartDO.getItemCode());
        mktDiscountGiftRpcParam.setOuCode(whAllocObjectMain.getSaleOuCode());
        mktDiscountGiftRpcParam.setCustCode(orgStore.getCustCode());
        mktDiscountGiftRpcParam.setNum((scpCartDO.getQty() == null ? BigDecimal.ZERO : scpCartDO.getQty()).longValue());
        mktDiscountGiftRpcParam.setSum(scpCartDO.getTotalAmt() == null ? BigDecimal.ZERO : scpCartDO.getTotalAmt());
        MktDiscountGiftRpcDTO discountGift = rmiSalService.findDiscountGift(mktDiscountGiftRpcParam);
        if (Objects.isNull(discountGift)) {
            return;
        }
        List<GiftRpcDTO> gifts = discountGift.getGifts();
        if (CollUtil.isEmpty(gifts)) {
            return;
        }
        List<String> itemCodes = gifts.stream().map(GiftRpcDTO::getItemCode).collect(Collectors.toList());
        if (CollUtil.isEmpty(itemCodes)) {
            return;
        }
        ItmItemBaseRpcParam itmItemBaseRpcParam = new ItmItemBaseRpcParam();
        itmItemBaseRpcParam.setItemCodes(itemCodes);
        List<ItmItemBaseRpcDTO> itemList = rmiItemService.findItemBaseRpcDtoByParam(itmItemBaseRpcParam);
        if (CollUtil.isEmpty(itemList)) {
            return;
        }
        List<Long> spuIds = itemList.stream().map(ItmItemBaseRpcDTO::getSpuId).collect(Collectors.toList());
        // 统计每个赠品code对应的id
        Map<String, Long> itemCodeIdMap = itemList.stream().collect(Collectors.toMap(ItmItemBaseRpcDTO::getItemCode,ItmItemBaseRpcDTO::getId));
        Map<String, Long> itemCodeSpuIdMap = itemList.stream().collect(Collectors.toMap(ItmItemBaseRpcDTO::getItemCode,ItmItemBaseRpcDTO::getSpuId));
        // 统计到每一个赠品id对应的商品信息
        Map<Long, ItmItemBaseRpcDTO> itemMap = itemList.stream().collect(Collectors.toMap(ItmItemBaseRpcDTO::getId, Function.identity()));
        List<ItmItemAttachmentProviderDTO> itemImages = rmiItemService.findSkuImgByItemIds(spuIds);
        // 统计每一个赠品的主图
        Map<Long, String> itemImageMap = itemImages.stream()
                .filter(ItmItemAttachmentProviderDTO::getMajor) // 只要主图
                .collect(Collectors.toMap(
                        ItmItemAttachmentProviderDTO::getItemId,
                        ItmItemAttachmentProviderDTO::getUrl,
                        (u1, u2) -> u1 // 如果有多个主图，取第一个
                ));
        for (GiftRpcDTO  gift: gifts) {
            // 获取itemId
            String itemCode = gift.getItemCode();
            Long itemId = itemCodeIdMap.get(itemCode);
            Long spuId = itemCodeSpuIdMap.get(itemCode);// 图片只能通过商品的spuId获取
            ItmItemBaseRpcDTO itmItemBaseRpcDTO = itemMap.get(itemId);
            CartToOrderSuccessRespVO successVO = new CartToOrderSuccessRespVO();
            CartToOrderSuccessRespVO.ItemSpecObjectVO itemSpecObjectVO = new CartToOrderSuccessRespVO.ItemSpecObjectVO();
            CartToOrderSuccessRespVO.WhAllocObject whAllocObject = new CartToOrderSuccessRespVO.WhAllocObject();
            whAllocObject.setItemPrice(BigDecimal.ZERO);
            whAllocObject.setRatio(whAllocObjectMain.getRatio());
            whAllocObject.setQty(BigDecimal.valueOf(gift.getGiftNum()));
            whAllocObject.setOuId(whAllocObjectMain.getOuId());
            whAllocObject.setOuCode(whAllocObjectMain.getOuCode());
            whAllocObject.setOuName(whAllocObjectMain.getOuName());
            whAllocObject.setSupplyType(whAllocObjectMain.getSupplyType());
            whAllocObject.setSupplyWhCode(whAllocObjectMain.getSupplyWhCode());
            whAllocObject.setSupplyWhId(whAllocObjectMain.getSupplyWhId());
            whAllocObject.setSupplyWhName(whAllocObjectMain.getSupplyWhName());
            whAllocObject.setSaleOuCode(whAllocObjectMain.getSaleOuCode());
            whAllocObject.setSaleOuName(whAllocObjectMain.getSaleOuName());
            whAllocObject.setSaleCustCode(whAllocObjectMain.getSaleCustCode());
            List<CartToOrderSuccessRespVO.WhAllocObject> whAllocObjects = List.of(whAllocObject);

            itemSpecObjectVO.setItemId(itmItemBaseRpcDTO.getId());
            itemSpecObjectVO.setItemCode(itmItemBaseRpcDTO.getItemCode());
            itemSpecObjectVO.setItemName(itmItemBaseRpcDTO.getItemName());
            itemSpecObjectVO.setDemandQuantity(BigDecimal.ONE);
            itemSpecObjectVO.setUom(itmItemBaseRpcDTO.getUom2());
            itemSpecObjectVO.setUomName(itmItemBaseRpcDTO.getUom2Name());
            itemSpecObjectVO.setUom2(itmItemBaseRpcDTO.getUom());
            itemSpecObjectVO.setUom2Name(itmItemBaseRpcDTO.getUomName());
            itemSpecObjectVO.setDecimalPlaces(itmItemBaseRpcDTO.getDecimalPlaces());
            itemSpecObjectVO.setUomRatio(itmItemBaseRpcDTO.getUomRatio2());
            itemSpecObjectVO.setItemType(itmItemBaseRpcDTO.getItemType2());
            itemSpecObjectVO.setItemAttrName(itmItemBaseRpcDTO.getItemAttrName());
            itemSpecObjectVO.setTotalAmt(BigDecimal.ZERO);
            itemSpecObjectVO.setWhAllocObjects(whAllocObjects);

            List<CartToOrderSuccessRespVO.ItemSpecObjectVO> itemSpecObjectVOS = List.of(itemSpecObjectVO);

            successVO.setSpuId(itmItemBaseRpcDTO.getSpuId());
            successVO.setSpuCode(itmItemBaseRpcDTO.getSpuCode());
            successVO.setSpuName(itmItemBaseRpcDTO.getSpuName());
            successVO.setAnotherName(itmItemBaseRpcDTO.getAnotherName());
            successVO.setSpec(itmItemBaseRpcDTO.getSpec());
            successVO.setUrl(itemImageMap.get(spuId));
            successVO.setGiftFlag(true);
            successVO.setGiftBindItemId(scpCartDO.getItemId());// 是哪个商品的赠品

            if (CollUtil.isNotEmpty(itemSpecObjectVOS)) {
                successVO.setItemSpecObjectVOS(itemSpecObjectVOS);
                successList.add(successVO);
            }
        }
    }



    private static ScpStoreOrderFreightPageRespVO getMatchedOrderFreightConfig(String supplyType,String whCode, String storeCode, String itemCode, List<ScpStoreOrderFreightPageRespVO> orderFreightModels) {
        ScpStoreOrderFreightPageRespVO matchedConfig = null;
        if(supplyType.equals(ScpUdcEnum.SUPPLY_DEMAND_TYPE_WH.getValueCode())){
            // 仓配
            List<ScpStoreOrderFreightPageRespVO> modelList = orderFreightModels.stream()
                    .filter(e -> e.getOrderType().equals(ScpUdcEnum.STORE_ORDER_TYPE_WD.getValueCode()))
                    .filter(e -> e.getWhCode() != null && !e.getWhCode().isBlank())
                    .collect(Collectors.toList());
            //列表中仓库code字段：whCode；门店code字段:storeCode；商品code:itemCode
            // 第一优先级匹配：仓库+门店+商品
            matchedConfig = modelList.stream()
                    .filter(e -> whCode.equals(e.getWhCode()) && storeCode.equals(e.getStoreCode()) && itemCode.equals(e.getItemCode()))
                    .findFirst()
                    .orElse(null);
            // 第一优先级（补充1.1）匹配：仓库+门店ALL+商品
            if (matchedConfig == null) {
                matchedConfig = modelList.stream()
                        .filter(e -> whCode.equals(e.getWhCode()) && "ALL".equalsIgnoreCase(e.getStoreCode()) && itemCode.equals(e.getItemCode()))
                        .findFirst()
                        .orElse(null);
            }
            // 第二优先级匹配：仓库+门店
            if (matchedConfig == null) {
                matchedConfig = modelList.stream()
                        .filter(e -> whCode.equals(e.getWhCode()) && storeCode.equals(e.getStoreCode()) && e.getItemCode()==null)
                        .findFirst()
                        .orElse(null);
            }
            // 第三优先级匹配：仓库+门店code为ALL
            // 第三优先级：仓库 + 门店=ALL
            if (matchedConfig == null) {
                matchedConfig = modelList.stream()
                        .filter(e -> whCode.equals(e.getWhCode()) && "ALL".equalsIgnoreCase(e.getStoreCode()) && e.getItemCode()==null)
                        .findFirst()
                        .orElse(null);
            }
        }else{
            // 供应商直送
            List<ScpStoreOrderFreightPageRespVO> modelList = orderFreightModels.stream().filter(e -> e.getOrderType().equals(ScpUdcEnum.STORE_ORDER_TYPE_DD.getValueCode())).collect(Collectors.toList());
            // 第一优先级匹配：门店+商品
            matchedConfig = modelList.stream()
                    .filter(e -> storeCode.equals(e.getStoreCode()) && itemCode.equals(e.getItemCode()))
                    .findFirst()
                    .orElse(null);
            // 第一优先级（补充1.1）匹配：门店ALL+商品
            if (matchedConfig == null) {
                matchedConfig = modelList.stream()
                        .filter(e -> "ALL".equalsIgnoreCase(e.getStoreCode()) && itemCode.equals(e.getItemCode()))
                        .findFirst()
                        .orElse(null);
            }
            // 第二优先级匹配：门店
            if (matchedConfig == null) {
                matchedConfig = modelList.stream()
                        .filter(e -> storeCode.equals(e.getStoreCode()) && e.getItemCode()==null)
                        .findFirst()
                        .orElse(null);
            }
            // 第三优先级匹配：门店code为ALL
            if (matchedConfig == null) {
                matchedConfig = modelList.stream()
                        .filter(e -> "ALL".equalsIgnoreCase(e.getStoreCode()) && e.getItemCode()==null)
                        .findFirst()
                        .orElse(null);
            }
        }
        // 如果还是没找到，直接抛异常
        if (matchedConfig == null) {
            throw new BusinessException("存在未设置运费的物料，下单失败");
        }
        return matchedConfig;
    }

    private Map<String, List<PriPriceRpcDTO>> buildPriceMap(List<PriPriceRpcDTO> priceList, List<ItmPriPriceRpcDtoParam> priceParamList) {
        if (CollUtil.isEmpty(priceList)) {
            //查询基本单位价格
            getBasePrice(priceParamList, priceList);
            if (CollUtil.isEmpty(priceList)) {
                return new HashMap<>();
            }
        } else {
            //查询基本单位价格
            Map<String, List<PriPriceRpcDTO>> inPriceMap =
                    priceList.stream().collect(Collectors.groupingBy(PriPriceRpcDTO::getItemCode));
            priceParamList.removeAll(priceParamList.stream().filter(row -> inPriceMap.containsKey(row.getItemCode())).collect(Collectors.toList()));
            getBasePrice(priceParamList, priceList);
        }
        return priceList.stream().collect(Collectors.groupingBy(row -> row.getItemCode() + "@" + row.getCombineItemCode() + "@" + row.getOuCode()));
    }

    private void getBasePrice(List<ItmPriPriceRpcDtoParam> priceParamList, List<PriPriceRpcDTO> priceList) {
        if (CollUtil.isEmpty(priceParamList)) {
            return;
        }
        //查询商品
        List<Long> itemIds = priceParamList.stream().map(ItmPriPriceRpcDtoParam::getItemId).distinct().collect(Collectors.toList());
        Map<Long, ItmItemSimpleRpcDTO> simpleItemMap = rmiItemService.findBaseItemMap(itemIds);

        List<ItmPriPriceRpcDtoParam> baseUomList = priceParamList.stream().map(row -> {
            ItmPriPriceRpcDtoParam param = BeanUtils.copyProperties(row, ItmPriPriceRpcDtoParam.class);
            ItmItemSimpleRpcDTO simpleItem = simpleItemMap.get(row.getItemId());
            param.setUom(simpleItem.getUom());
            return param;
        }).collect(Collectors.toList());
        List<PriPriceRpcDTO> basePriceList = rmiPriceRpcService.findPriceByParam(baseUomList);
        log.info("查询基本单位价格:{}", JSONUtil.toJsonStr(basePriceList));
        if (CollUtil.isNotEmpty(basePriceList)) {
            List<PriPriceRpcDTO> resultPriceList = basePriceList.stream().map(row -> {
                PriPriceRpcDTO priPriceRpcDTO = BeanUtils.copyProperties(row, PriPriceRpcDTO.class);
                ItmItemSimpleRpcDTO simpleItem = simpleItemMap.get(row.getItemId());
                if (simpleItem.getUomRatio2() == null) {
                    return null;
                }
                if (simpleItem.getDecimalPlaces() != null) {
                    priPriceRpcDTO.setPrice(row.getPrice().multiply(simpleItem.getUomRatio2()).setScale(simpleItem.getDecimalPlaces(), BigDecimal.ROUND_HALF_UP));
                } else {
                    priPriceRpcDTO.setPrice(row.getPrice().multiply(simpleItem.getUomRatio2()));
                }
                return priPriceRpcDTO;
            }).filter(Objects::nonNull).collect(Collectors.toList());
            priceList.addAll(resultPriceList);
        }
    }

    private Map<String, List<OrderConfirmRespVO>> buildConfirmMap(List<OrderConfirmRespVO> confirmList) {
        if (CollUtil.isEmpty(confirmList)) {
            return new HashMap<>();
        }
        return confirmList.stream().collect(Collectors.groupingBy(row -> row.getItemCode() + row.getCombineItemCode() + row.getActivityCode()));
    }

    private List<OrderConfirmRespVO> suppAllocStrategy(ScpStoreCartDO cartDO, OrgStoreBaseRpcDTO orgStore, Boolean freightFlag, Map<String, List<ScpSupplyAllocationRpcDTO>> supplyAllocationMap,
                                                       List<ItmPriPriceRpcDtoParam> priceParamList, AtomicReference<Map<String, BigDecimal>> stockMap) {
        List<OrderConfirmRespVO> result = new ArrayList<>();
        // 查询供应商配额
        List<ScpSupplyAllocationRpcDTO> suppAllocList = supplyAllocationMap.get(cartDO.getItemCode());
        log.info("供应商配额查询结果:{}", JSONUtil.toJsonStr(suppAllocList));
        if (CollUtil.isEmpty(suppAllocList)) {
            return new ArrayList<>();
        }
        // 销售价格
        for (ScpSupplyAllocationRpcDTO row : suppAllocList) {
            if (StrUtil.isBlank(row.getSaleOuCode())) {
                continue;
            }
            ItmPriPriceRpcDtoParam priceParam = new ItmPriPriceRpcDtoParam();
            priceParam.setPriceCls(ScpConstant.INTERNAL_SETTLEMENT_PRICE);
            priceParam.setPriceType(ScpConstant.INTERNAL_SETTLEMENT_PRICE);
            priceParam.setItemId(cartDO.getItemId());
            priceParam.setCustCode(row.getSaleCustCode());
            priceParam.setItemCode(cartDO.getItemCode());
            priceParam.setUom(cartDO.getUom());
            priceParam.setCurrCode(ScpConstant.CNY);
            priceParam.setOuCode(row.getSaleOuCode());
            priceParamList.add(priceParam);
        }
        int size = suppAllocList.size();
        BigDecimal sum = BigDecimal.ZERO;
        for (int i = 0; i < size; i++) {
            ScpSupplyAllocationRpcDTO row = suppAllocList.get(i);
            OrderConfirmRespVO orderConfirmRespVO = new OrderConfirmRespVO();
            orderConfirmRespVO.setItemId(cartDO.getItemId());
            orderConfirmRespVO.setItemCode(cartDO.getItemCode());
            orderConfirmRespVO.setItemName(cartDO.getItemName());
            orderConfirmRespVO.setSpuCode(cartDO.getSpuCode());
            orderConfirmRespVO.setSpuId(cartDO.getSpuId());
            orderConfirmRespVO.setSpuName(cartDO.getSpuName());
            orderConfirmRespVO.setUnitName(cartDO.getUomName());
            orderConfirmRespVO.setUnit(cartDO.getUom());
            orderConfirmRespVO.setSuppWhId(row.getSuppId());
            orderConfirmRespVO.setSuppWhCode(row.getSuppCode());
            orderConfirmRespVO.setSuppWhName(row.getSuppName());
            orderConfirmRespVO.setRatio(row.getAllocation());
            orderConfirmRespVO.setCurrency(ScpConstant.CNY);
            orderConfirmRespVO.setSupplyType(ScpUdcEnum.SUPPLY_DEMAND_TYPE_SUPP.getValueCode());
            orderConfirmRespVO.setSaleOuCode(row.getSaleOuCode());
            orderConfirmRespVO.setSaleOuName(row.getSaleOuName());
            orderConfirmRespVO.setSaleCustCode(row.getSaleCustCode());
            orderConfirmRespVO.setOuId(row.getOuId());
            orderConfirmRespVO.setOuCode(row.getOuCode());
            orderConfirmRespVO.setOuName(row.getOuName());
            orderConfirmRespVO.setDemandQuantity(cartDO.getQty());
            orderConfirmRespVO.setCombineItemCode(cartDO.getCombineItemCode());
            orderConfirmRespVO.setActivityCode(cartDO.getActivityCode());
            orderConfirmRespVO.setActivityId(cartDO.getActivityId());
            stockMap.updateAndGet(currentMap -> {
                currentMap.put(cartDO.getItemCode(), new BigDecimal("9999"));
                return currentMap;
            });
            if (orgStore.getFreightFlag2() && freightFlag) {
                orderConfirmRespVO.setFreightFlag(Boolean.TRUE);
                orderConfirmRespVO.setFreightRatio(orgStore.getFreightRatio2());
            } else {
                orderConfirmRespVO.setFreightFlag(Boolean.FALSE);
                orderConfirmRespVO.setFreightRatio(BigDecimal.ZERO);
            }
            if (orderConfirmRespVO.getDemandQuantity() == null) {
                result.add(orderConfirmRespVO);
                continue;
            }
            if (i == size - 1) {
                orderConfirmRespVO.setAllocationDeQuantity(orderConfirmRespVO.getDemandQuantity().subtract(sum));
            } else {
                BigDecimal ratioQty = orderConfirmRespVO.getDemandQuantity().multiply(orderConfirmRespVO.getRatio()).divide(BigDecimal.valueOf(100), 0, RoundingMode.HALF_DOWN);
                orderConfirmRespVO.setAllocationDeQuantity(ratioQty);
                sum = sum.add(ratioQty);
            }
            result.add(orderConfirmRespVO);
        }
        return result;
    }

    private List<OrderConfirmRespVO> whnetStrategy(ScpStoreCartDO cartDO, OrgStoreBaseRpcDTO orgStore, Boolean freightFlag, Map<String, List<ScpWhNetRelationRpcDTO>> whNetRelationMap, List<ItmPriPriceRpcDtoParam> priceParamList) {
        List<OrderConfirmRespVO> result = new ArrayList<>();
        var whNetRelationRpcDTOList = whNetRelationMap.get(cartDO.getItemCode());
        log.info("商品编码：{},仓网供应关系信息：{}", cartDO.getItemCode(), JSONUtil.toJsonStr(whNetRelationRpcDTOList));
        if (CollUtil.isEmpty(whNetRelationRpcDTOList)) {
            return new ArrayList<>();
        }
        // 查询销售价格
        for (ScpWhNetRelationRpcDTO row : whNetRelationRpcDTOList) {
            if (StrUtil.isBlank(row.getOuCode())) {
                continue;
            }
            ItmPriPriceRpcDtoParam priceParam = new ItmPriPriceRpcDtoParam();
            priceParam.setPriceCls(ScpConstant.INTERNAL_SETTLEMENT_PRICE);
            priceParam.setPriceType(ScpConstant.INTERNAL_SETTLEMENT_PRICE);
            priceParam.setItemId(cartDO.getItemId());
            priceParam.setCustCode(row.getCustCode());
            priceParam.setItemCode(cartDO.getItemCode());
            priceParam.setUom(cartDO.getUom());
            priceParam.setCurrCode(ScpConstant.CNY);
            priceParam.setOuCode(row.getOuCode());
            priceParamList.add(priceParam);
        }
        int size = whNetRelationRpcDTOList.size();
        BigDecimal sum = BigDecimal.ZERO;
        for (int i = 0; i < size; i++) {
            ScpWhNetRelationRpcDTO row = whNetRelationRpcDTOList.get(i);
            OrderConfirmRespVO orderConfirmRespVO = new OrderConfirmRespVO();
            orderConfirmRespVO.setItemId(cartDO.getItemId());
            orderConfirmRespVO.setItemCode(cartDO.getItemCode());
            orderConfirmRespVO.setItemName(cartDO.getItemName());
            orderConfirmRespVO.setSpuId(cartDO.getSpuId());
            orderConfirmRespVO.setSpuCode(cartDO.getSpuCode());
            orderConfirmRespVO.setSpuName(cartDO.getSpuName());
            orderConfirmRespVO.setUnitName(cartDO.getUomName());
            orderConfirmRespVO.setUnit(cartDO.getUom());
            orderConfirmRespVO.setSuppWhId(row.getSupplyWhId());
            orderConfirmRespVO.setSuppWhCode(row.getSupplyWhCode());
            orderConfirmRespVO.setSuppWhName(row.getSupplyWhName());
            orderConfirmRespVO.setRatio(row.getSupplyPercentage());
            orderConfirmRespVO.setCurrency(ScpConstant.CNY);
            orderConfirmRespVO.setSupplyType(ScpUdcEnum.SUPPLY_DEMAND_TYPE_WH.getValueCode());
            orderConfirmRespVO.setDemandQuantity(cartDO.getQty());
            orderConfirmRespVO.setSaleOuName(row.getOuName());
            orderConfirmRespVO.setSaleOuCode(row.getOuCode());
            orderConfirmRespVO.setSaleCustCode(row.getCustCode());
            orderConfirmRespVO.setActivityCode(cartDO.getActivityCode());
            orderConfirmRespVO.setActivityId(cartDO.getActivityId());
            orderConfirmRespVO.setCombineItemCode(cartDO.getCombineItemCode());
            if (orgStore.getFreightFlag() && freightFlag) {
                orderConfirmRespVO.setFreightFlag(Boolean.TRUE);
                orderConfirmRespVO.setFreightRatio(orgStore.getFreightRatio());
            } else {
                orderConfirmRespVO.setFreightFlag(Boolean.FALSE);
                orderConfirmRespVO.setFreightRatio(BigDecimal.ZERO);
            }
            if (orderConfirmRespVO.getDemandQuantity() == null) {
                result.add(orderConfirmRespVO);
                continue;
            }
            if (i == size - 1) {
                orderConfirmRespVO.setAllocationDeQuantity(orderConfirmRespVO.getDemandQuantity().subtract(sum));
            } else {
                BigDecimal ratioQty = orderConfirmRespVO.getDemandQuantity().multiply(orderConfirmRespVO.getRatio()).divide(BigDecimal.valueOf(100), 0, RoundingMode.HALF_DOWN);
                orderConfirmRespVO.setAllocationDeQuantity(ratioQty);
                sum = sum.add(ratioQty);
            }
            result.add(orderConfirmRespVO);
        }
        return result;

    }

    /**
     * 保存或更新购物车
     *
     * @param cartSaveVO
     * @param cartOps
     */
    private static void saveOrUpdateCart(StoreCartSaveVO cartSaveVO, BoundHashOperations<String, Object, Object> cartOps) {
        // 判断Redis是否有该商品的信息
        String product = (String) cartOps.get(SysUtils.generateRedisKey(ScpConstant.SKU, cartSaveVO.getCombineItemCode(), cartSaveVO.getItemCode()));
        if (StrUtil.isBlank(product) && cartSaveVO.getQty().compareTo(BigDecimal.ZERO) <= 0) {
            log.error("购物车中不存在此商品:{}，输入数量需要大于零", cartSaveVO.getItemCode());
            throw new BusinessException("购物车中不存在此商品，输入数量需要大于零");
        }
        if (StrUtil.isBlank(product)) {
            // 编辑购物车商品
            ScpStoreCartDO storeCartDO = ScpStoreCartConvert.INSTANCE.saveVoToDo(cartSaveVO);
            //添加购物车默认选中
            storeCartDO.setSelectedStatus(1);
            storeCartDO.setCreateTime(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            // 购物车保存
            cartOps.put(SysUtils.generateRedisKey(ScpConstant.SKU, cartSaveVO.getCombineItemCode(), cartSaveVO.getItemCode()), JSON.toJSONString(storeCartDO));
        } else {
            // 添加商品数量=0时，删除采购车商品
            if (cartSaveVO.getQty().compareTo(BigDecimal.ZERO) == 0) {
                cartOps.delete(SysUtils.generateRedisKey(ScpConstant.SKU, cartSaveVO.getCombineItemCode(), cartSaveVO.getItemCode()));
            } else {
                // 购物车有此商品，修改数量即可
                var storeCartDO = JSON.parseObject(product, ScpStoreCartDO.class);
                storeCartDO.setQty(cartSaveVO.getQty());
                storeCartDO.setMoq(cartSaveVO.getMoq());
                String cartItemJson = JSON.toJSONString(storeCartDO);
                // 购物车保存
                cartOps.put(SysUtils.generateRedisKey(ScpConstant.SKU, storeCartDO.getCombineItemCode(), storeCartDO.getItemCode()), cartItemJson);
            }
        }
    }
}
