package com.elitesland.scp.application.web.stock;


import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.stock.*;
import com.elitesland.scp.application.service.stock.ScpPredictStStockCalcService;
import com.elitesland.scp.utils.excel.ExcelWriteUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 预测安全库存目标库存批次记录 前端控制器
 * </p>
 *
 * @author jeesie.jiang
 * @since 2025-01-21
 */
@Slf4j
@Api(tags = "预测批次-安全库存&&目标库存")
@RestController
@RequestMapping("/predict-st-stock-calc")
@AllArgsConstructor
@Validated
public class ScpPredictStStockCalcController {

    private final ScpPredictStStockCalcService scpPredictStStockCalcService;

    @ApiOperation(value = "预测批次列表")
    @PostMapping(value = "/page")
    public ApiResult<PagingVO<ScpPredictStStockCalcPageVO>> page(@RequestBody ScpPredictStStockCalcPageParam param) {
        return ApiResult.ok(scpPredictStStockCalcService.page(param));
    }

    @ApiOperation(value = "预测批次详情")
    @PostMapping(value = "/page/detail")
    public ApiResult<PagingVO<ScpPredictStStockRespVO>> pageDetail(@Valid @RequestBody ScpPredictStStockParamVO param) {
        return ApiResult.ok(scpPredictStStockCalcService.stStockDetailPage(param));
    }

    @ApiOperation(value = "预测批次-删除")
    @PostMapping(value = "/delete")
    public ApiResult<?> delete(@RequestBody List<Long> ids) {
        scpPredictStStockCalcService.delete(ids);
        return ApiResult.ok();
    }

    @ApiOperation(value = "预测批次计算")
    @PostMapping(value = "/calc")
    public ApiResult<String> calc(@RequestBody ScpPredictStStockCalcParamVO param) {
        return ApiResult.ok(scpPredictStStockCalcService.calcPredictStStock(param));
    }

    @PostMapping("/download")
    @ApiOperation("导入模版下载导出")
    public void download(HttpServletResponse response, @RequestBody ScpPredictStStockDownLoadParam param) throws IOException {
        List<ScpPredictStStockDownloadVO> ret = scpPredictStStockCalcService.downloadTmplFile(param);
        ExcelWriteUtil.autoPredictStStockAliasExcelWrite(response, ret, ScpPredictStStockDownloadVO.class, "预测安全库存&目的库存导入模版", "安全库存&目的库存导入模版");

    }



}
