/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.infr.repo.calendar;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.calendar.ScpCalendarStoreQueryParamVO;
import com.elitesland.scp.application.facade.vo.calendar.ScpCalendarStoreRespVO;
import com.elitesland.scp.application.facade.vo.calendar.ScpStoreDemandCalendarPageParamVO;
import com.elitesland.scp.application.facade.vo.calendar.ScpStoreDemandCalendarPageVO;
import com.elitesland.scp.application.facade.vo.calendar.ScpStoreDemandCalendarParamVO;
import com.elitesland.scp.application.facade.vo.param.calendar.ScpStoreDemandCalendarParam;
import com.elitesland.scp.domain.entity.calendar.QScpStoreDemandCalendarDO;
import com.elitesland.scp.domain.entity.calendar.ScpStoreDemandCalendarDO;
import com.elitesland.scp.infr.dto.calendar.ScpStoreDemandCalendarDTO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.impl.JPAQuery;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class ScpStoreDemandCalendarRepoProc
extends BaseRepoProc<ScpStoreDemandCalendarDO> {
    private static final QScpStoreDemandCalendarDO jpaQDo = QScpStoreDemandCalendarDO.scpStoreDemandCalendarDO;
    private final QBean<ScpStoreDemandCalendarDTO> demandCalendarList;

    public ScpStoreDemandCalendarRepoProc() {
        super((EntityPathBase)jpaQDo);
        this.demandCalendarList = Projections.bean(ScpStoreDemandCalendarDTO.class, (Expression[])new Expression[]{ScpStoreDemandCalendarRepoProc.jpaQDo.id, ScpStoreDemandCalendarRepoProc.jpaQDo.type, ScpStoreDemandCalendarRepoProc.jpaQDo.year, ScpStoreDemandCalendarRepoProc.jpaQDo.month, ScpStoreDemandCalendarRepoProc.jpaQDo.day, ScpStoreDemandCalendarRepoProc.jpaQDo.itemType2, ScpStoreDemandCalendarRepoProc.jpaQDo.workStatus, ScpStoreDemandCalendarRepoProc.jpaQDo.storeId, ScpStoreDemandCalendarRepoProc.jpaQDo.storeCode, ScpStoreDemandCalendarRepoProc.jpaQDo.storeName, ScpStoreDemandCalendarRepoProc.jpaQDo.sddType});
    }

    public PagingVO<ScpStoreDemandCalendarPageVO> searchPage(ScpStoreDemandCalendarPageParamVO param) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ScpStoreDemandCalendarPageVO.class, (Expression[])new Expression[]{ScpStoreDemandCalendarRepoProc.jpaQDo.storeCode, ScpStoreDemandCalendarRepoProc.jpaQDo.storeName, ScpStoreDemandCalendarRepoProc.jpaQDo.storeId, ScpStoreDemandCalendarRepoProc.jpaQDo.year, ScpStoreDemandCalendarRepoProc.jpaQDo.month, ScpStoreDemandCalendarRepoProc.jpaQDo.type, ScpStoreDemandCalendarRepoProc.jpaQDo.itemType2, ScpStoreDemandCalendarRepoProc.jpaQDo.sddType})).distinct()).from((EntityPath)jpaQDo);
        if (param != null) {
            jpaQuery.where(this.where(param));
        }
        jpaQuery.orderBy(new OrderSpecifier[]{ScpStoreDemandCalendarRepoProc.jpaQDo.year.desc(), ScpStoreDemandCalendarRepoProc.jpaQDo.month.desc()});
        param.setPaging(jpaQuery);
        return PagingVO.builder().total(this.getCount(param).longValue()).records(jpaQuery.fetch()).build();
    }

    private Long getCount(ScpStoreDemandCalendarPageParamVO param) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.selectDistinct(new Expression[]{ScpStoreDemandCalendarRepoProc.jpaQDo.storeCode, ScpStoreDemandCalendarRepoProc.jpaQDo.itemType2, ScpStoreDemandCalendarRepoProc.jpaQDo.storeName, ScpStoreDemandCalendarRepoProc.jpaQDo.storeId, ScpStoreDemandCalendarRepoProc.jpaQDo.year, ScpStoreDemandCalendarRepoProc.jpaQDo.month, ScpStoreDemandCalendarRepoProc.jpaQDo.type, ScpStoreDemandCalendarRepoProc.jpaQDo.sddType}).from((EntityPath)jpaQDo);
        if (param != null) {
            jpaQuery.where(this.where(param));
        }
        return jpaQuery.fetch().size();
    }

    public Predicate where(ScpStoreDemandCalendarPageParamVO param) {
        String month;
        DateTimeFormatter formatter;
        String year;
        BooleanExpression predicate = Expressions.ONE.eq((Expression)Expressions.ONE);
        if (StringUtils.isNotEmpty((String)param.getStoreCode())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)ScpStoreDemandCalendarRepoProc.jpaQDo.storeCode.eq((Object)param.getStoreCode()));
        }
        if (Objects.nonNull(param.getStoreId())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)ScpStoreDemandCalendarRepoProc.jpaQDo.storeId.eq((Object)param.getStoreId()));
        }
        if (CollectionUtils.isNotEmpty(param.getItemType2s())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)ScpStoreDemandCalendarRepoProc.jpaQDo.itemType2.in(param.getItemType2s()));
        }
        if (StringUtils.isNotEmpty((String)param.getItemType2())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)ScpStoreDemandCalendarRepoProc.jpaQDo.itemType2.eq((Object)param.getItemType2()));
        }
        if (param.getStartDate() != null) {
            year = String.valueOf(param.getStartDate().getYear());
            formatter = DateTimeFormatter.ofPattern("MM");
            month = param.getStartDate().format(formatter);
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)ScpStoreDemandCalendarRepoProc.jpaQDo.year.goe((Comparable)((Object)year)).and((Predicate)ScpStoreDemandCalendarRepoProc.jpaQDo.month.goe((Comparable)((Object)month))));
        }
        if (param.getEndDate() != null) {
            year = String.valueOf(param.getEndDate().getYear());
            formatter = DateTimeFormatter.ofPattern("MM");
            month = param.getEndDate().format(formatter);
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)ScpStoreDemandCalendarRepoProc.jpaQDo.year.loe((Comparable)((Object)year)).and((Predicate)ScpStoreDemandCalendarRepoProc.jpaQDo.month.loe((Comparable)((Object)month))));
        }
        if (Boolean.TRUE.equals(param.getScpmanAuthority())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)ScpStoreDemandCalendarRepoProc.jpaQDo.storeCode.in(param.getStores()));
        }
        if (param.getFilterDate() != null) {
            year = String.valueOf(param.getFilterDate().getYear());
            formatter = DateTimeFormatter.ofPattern("MM");
            month = param.getFilterDate().format(formatter);
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)ScpStoreDemandCalendarRepoProc.jpaQDo.year.eq((Object)year).and((Predicate)ScpStoreDemandCalendarRepoProc.jpaQDo.month.eq((Object)month)));
        }
        return predicate;
    }

    public List<ScpStoreDemandCalendarDTO> findStoreCalendarByParam(ScpStoreDemandCalendarParamVO param) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ScpStoreDemandCalendarDTO.class, (Expression[])new Expression[]{ScpStoreDemandCalendarRepoProc.jpaQDo.storeCode, ScpStoreDemandCalendarRepoProc.jpaQDo.storeName, ScpStoreDemandCalendarRepoProc.jpaQDo.itemType2, ScpStoreDemandCalendarRepoProc.jpaQDo.storeId, ScpStoreDemandCalendarRepoProc.jpaQDo.year, ScpStoreDemandCalendarRepoProc.jpaQDo.month, ScpStoreDemandCalendarRepoProc.jpaQDo.type, ScpStoreDemandCalendarRepoProc.jpaQDo.day, ScpStoreDemandCalendarRepoProc.jpaQDo.id, ScpStoreDemandCalendarRepoProc.jpaQDo.workStatus, ScpStoreDemandCalendarRepoProc.jpaQDo.createTime, ScpStoreDemandCalendarRepoProc.jpaQDo.modifyTime, ScpStoreDemandCalendarRepoProc.jpaQDo.sddType})).from((EntityPath)jpaQDo);
        if (param != null) {
            jpaQuery.where(this.where(param));
        }
        jpaQuery.orderBy(new OrderSpecifier[]{ScpStoreDemandCalendarRepoProc.jpaQDo.year.desc(), ScpStoreDemandCalendarRepoProc.jpaQDo.month.desc(), ScpStoreDemandCalendarRepoProc.jpaQDo.day.asc()});
        return jpaQuery.fetch();
    }

    public Predicate where(ScpStoreDemandCalendarParamVO param) {
        BooleanExpression predicate = Expressions.ONE.eq((Expression)Expressions.ONE);
        if (StringUtils.isNotEmpty((String)param.getStoreCode())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)ScpStoreDemandCalendarRepoProc.jpaQDo.storeCode.eq((Object)param.getStoreCode()));
        }
        if (StringUtils.isNotEmpty((String)param.getYear())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)ScpStoreDemandCalendarRepoProc.jpaQDo.year.eq((Object)param.getYear()));
        }
        if (StringUtils.isNotEmpty((String)param.getMonth())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)ScpStoreDemandCalendarRepoProc.jpaQDo.month.eq((Object)param.getMonth()));
        }
        if (StringUtils.isNotEmpty((String)param.getItemType2())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)ScpStoreDemandCalendarRepoProc.jpaQDo.itemType2.eq((Object)param.getItemType2()));
        }
        if (CollectionUtils.isNotEmpty(param.getItemType2s())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)ScpStoreDemandCalendarRepoProc.jpaQDo.itemType2.in(param.getItemType2s()));
        }
        return predicate;
    }

    public List<ScpStoreDemandCalendarDTO> findDemandCalendarByParam(ScpStoreDemandCalendarParam paramVO) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select(this.demandCalendarList).from((EntityPath)jpaQDo);
        jpaQuery.where(this.whereDemandCalendar(paramVO));
        return jpaQuery.fetch();
    }

    private Predicate whereDemandCalendar(ScpStoreDemandCalendarParam paramVO) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (Objects.nonNull(paramVO.getStoreCode())) {
            predicates.add(ScpStoreDemandCalendarRepoProc.jpaQDo.storeCode.eq((Object)paramVO.getStoreCode()));
        }
        if (CollectionUtil.isNotEmpty(paramVO.getStoreCodeList())) {
            predicates.add(ScpStoreDemandCalendarRepoProc.jpaQDo.storeCode.in(paramVO.getStoreCodeList()));
        }
        if (Objects.nonNull(paramVO.getWorkStatus())) {
            predicates.add(ScpStoreDemandCalendarRepoProc.jpaQDo.workStatus.eq((Object)paramVO.getWorkStatus()));
        }
        if (Objects.nonNull(paramVO.getDocType())) {
            predicates.add(ScpStoreDemandCalendarRepoProc.jpaQDo.itemType2.eq((Object)paramVO.getDocType()));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getYear())) {
            predicates.add(ScpStoreDemandCalendarRepoProc.jpaQDo.year.eq((Object)paramVO.getYear()));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getMonth())) {
            predicates.add(ScpStoreDemandCalendarRepoProc.jpaQDo.month.eq((Object)paramVO.getMonth()));
        }
        if (StrUtil.isNotBlank((CharSequence)paramVO.getDay())) {
            predicates.add(ScpStoreDemandCalendarRepoProc.jpaQDo.day.eq((Object)paramVO.getDay()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public List<ScpCalendarStoreRespVO> listStoreByQueryParam(ScpCalendarStoreQueryParamVO param) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.selectDistinct((Expression)Projections.bean(ScpCalendarStoreRespVO.class, (Expression[])new Expression[]{ScpStoreDemandCalendarRepoProc.jpaQDo.storeCode, ScpStoreDemandCalendarRepoProc.jpaQDo.storeName, ScpStoreDemandCalendarRepoProc.jpaQDo.storeId, ScpStoreDemandCalendarRepoProc.jpaQDo.workStatus, ScpStoreDemandCalendarRepoProc.jpaQDo.itemType2})).from((EntityPath)jpaQDo);
        if (param != null) {
            jpaQuery.where(this.whereDemandCalendar(param));
        }
        return jpaQuery.fetch();
    }

    private Predicate whereDemandCalendar(ScpCalendarStoreQueryParamVO param) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        predicates.add(Expressions.ONE.eq((Expression)Expressions.ONE));
        if (StringUtils.isNotEmpty((String)param.getWorkStatus())) {
            predicates.add(ScpStoreDemandCalendarRepoProc.jpaQDo.workStatus.eq((Object)param.getWorkStatus()));
        }
        if (param.getFindDate() != null) {
            String year = String.valueOf(param.getFindDate().getYear());
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MM");
            String month = param.getFindDate().format(formatter);
            DateTimeFormatter dayFormatter = DateTimeFormatter.ofPattern("d");
            String day = param.getFindDate().format(dayFormatter);
            predicates.add(ScpStoreDemandCalendarRepoProc.jpaQDo.year.eq((Object)year).and((Predicate)ScpStoreDemandCalendarRepoProc.jpaQDo.month.eq((Object)month)).and((Predicate)ScpStoreDemandCalendarRepoProc.jpaQDo.day.eq((Object)day)));
        }
        if (param.getStoreCode() != null) {
            predicates.add(ScpStoreDemandCalendarRepoProc.jpaQDo.storeCode.eq((Object)param.getStoreCode()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public void deleteByStoreAndYear(List<String> storeCodes, String year) {
        this.jpaQueryFactory.delete((EntityPath)jpaQDo).where(new Predicate[]{ScpStoreDemandCalendarRepoProc.jpaQDo.storeCode.in(storeCodes).and((Predicate)ScpStoreDemandCalendarRepoProc.jpaQDo.year.eq((Object)year))}).execute();
    }
}

