/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.pay.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.boot.wrapper.RedisWrapper;
import com.elitesland.scp.pay.config.EntpayProperties;
import com.elitesland.scp.pay.service.AccountBatchBindService;
import com.elitesland.scp.pay.service.NotifyVerifyService;
import com.elitesland.scp.pay.vo.AccountBindNotifyModel;
import com.elitesland.scp.pay.vo.AccountBindParamVO;
import com.elitesland.scp.pay.vo.BankAccountParamVO;
import com.tenpay.business.entpay.mse.sdk.api.AccountBatchBind;
import com.tenpay.business.entpay.mse.sdk.common.NotifyHandler;
import com.tenpay.business.entpay.mse.sdk.config.EntpayConfig;
import com.tenpay.business.entpay.mse.sdk.exception.EntpayException;
import com.tenpay.business.entpay.mse.sdk.model.AccountBatchBindParam;
import com.tenpay.business.entpay.mse.sdk.model.NotifyUrl;
import com.tenpay.business.entpay.mse.sdk.model.PayeeAccounts;
import java.security.PublicKey;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.configurationprocessor.json.JSONException;
import org.springframework.boot.configurationprocessor.json.JSONObject;
import org.springframework.stereotype.Service;

@Service
public class AccountBatchBindServiceImpl
implements AccountBatchBindService {
    private static final Logger log = LoggerFactory.getLogger(AccountBatchBindServiceImpl.class);
    private final RedisWrapper redisWrapper;
    private final RedisUtils redisUtils;
    private final NotifyVerifyService notifyVerifyService;

    @Override
    public void accountBind(AccountBindParamVO paramVO) {
        try {
            EntpayProperties entpayProperties = Optional.ofNullable(this.redisWrapper.apply(() -> this.redisUtils.get("ENT_PAY_PROPERTIES"), null)).map(Object::toString).map(o -> (EntpayProperties)JSONUtil.toBean((String)o, EntpayProperties.class)).orElseThrow(() -> new BusinessException("\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u5fae\u4f01\u4ed8\u4fe1\u606f"));
            AccountBatchBindParam accountBatchBindParam = new AccountBatchBindParam();
            accountBatchBindParam.setEntId(paramVO.getEntId());
            accountBatchBindParam.setOutRequestNo(paramVO.getOutRequestNo());
            if (CollUtil.isEmpty(paramVO.getBankAccountList())) {
                throw new BusinessException("\u6536\u6b3e\u8d26\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            }
            List payeeAccounts = paramVO.getBankAccountList().stream().map(this::mapToPayeeAccount).collect(Collectors.toList());
            accountBatchBindParam.setPayeeAccounts(payeeAccounts);
            NotifyUrl notifyUrl = NotifyUrl.builder().serverNotifyUrl(entpayProperties.getServerAccountBindNotifyUrl()).webSuccessUrl(entpayProperties.getServerAccountBindNotifyUrl()).build();
            accountBatchBindParam.setNotifyUrl(notifyUrl);
            log.info("\u6279\u91cf\u7ed1\u5b9a\u8d26\u6237\u5fae\u4f01\u4ed8\u53c2\u6570\uff1a{}", (Object)JSONUtil.toJsonStr((Object)accountBatchBindParam));
            String requestNo = AccountBatchBind.create((AccountBatchBindParam)accountBatchBindParam).getRequestNo();
            log.info("\u6279\u91cf\u7ed1\u5b9a\u8d26\u6237\u5fae\u4f01\u4ed8\u8bf7\u6c42\u53f7\uff1a{}", (Object)requestNo);
        }
        catch (EntpayException e) {
            throw new BusinessException("\u5fae\u4f01\u4ed8\u6279\u91cf\u7ed1\u5b9a\u8d26\u53f7\u5931\u8d25: " + e.getMessage());
        }
    }

    private PayeeAccounts mapToPayeeAccount(BankAccountParamVO row) {
        return PayeeAccounts.builder().accountType(row.getAccountType()).bankAccountName(row.getBankAccountName()).bankAccountNumber(row.getBankAccountNumber()).bankName(row.getBankName()).bankBranchId(row.getBankBranchId()).bankBranchName(row.getBankBranchName()).build();
    }

    @Override
    public String accountBindNotify(String body, String authorization) throws EntpayException, JSONException {
        AccountBindNotifyModel notifyModel = (AccountBindNotifyModel)NotifyHandler.handlerWebhook((String)body, (String)authorization, AccountBindNotifyModel.class, (PublicKey)EntpayConfig.getRealTbepPublicKey(null));
        log.info("\u6279\u91cf\u7ed1\u5b9a\u8d26\u6237\u56de\u8c03\u901a\u77e5\u6570\u636e\uff1a{}", (Object)JSONUtil.toJsonStr((Object)notifyModel));
        this.notifyVerifyService.processAccountBindNotify(notifyModel);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("retcode", 0);
        jsonObject.put("retmsg", (Object)"SUCCESS");
        return jsonObject.toString();
    }

    public AccountBatchBindServiceImpl(RedisWrapper redisWrapper, RedisUtils redisUtils, NotifyVerifyService notifyVerifyService) {
        this.redisWrapper = redisWrapper;
        this.redisUtils = redisUtils;
        this.notifyVerifyService = notifyVerifyService;
    }
}

