package com.elitesland.scp.mq;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.mq.MessageQueueListener;
import com.elitesland.scp.boh.StoreReceiveConfirmSendParam;
import com.elitesland.scp.common.ScpConstant;
import com.elitesland.scp.domain.entity.storereceive.StoreReceiveDO;
import com.elitesland.scp.domain.service.order.ScpDemandOrderDDomainService;
import com.elitesland.scp.domain.service.order.ScpDemandOrderDomainService;
import com.elitesland.scp.infr.dto.boh.DemandOrderDtl;
import com.elitesland.scp.infr.repo.storereceive.StoreReceiveRepo;
import com.elitesland.scp.infr.repo.storereceive.StoreReceiveRepoProc;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 门店收货 确认回写
 */
@Component
@Slf4j
@RequiredArgsConstructor
public class StoreReceiveConfirmListener implements MessageQueueListener<StoreReceiveConfirmSendParam> {

    private final StoreReceiveRepo storeReceiveRepo;
    private final StoreReceiveRepoProc storeReceiveRepoProc;
    private final ScpDemandOrderDomainService scpDemandOrderDomainService;
    private final ScpDemandOrderDDomainService scpDemandOrderDDomainService;


    @Override
    public @NotEmpty String[] channels() {
        return new String[]{StoreReceiveConfirmSendParam.CONFIRM_CHANNEL};
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void onConsume(@NotBlank String s, @NotNull StoreReceiveConfirmSendParam storeReceiveSendParam) {
        log.info("门店收退货 确认回写：" + JSON.toJSONString(storeReceiveSendParam));

        List<StoreReceiveDO> receiveDOS = storeReceiveRepo.findAllByDocId(storeReceiveSendParam.getDocId());
        if (CollectionUtil.isEmpty(receiveDOS)) {
            return;
        }

        List<StoreReceiveDO> ceList = receiveDOS.stream().filter(i -> Objects.equals(i.getStatus(), "CE")).collect(Collectors.toList());
        if (ceList.isEmpty()) {
            return;
        }
        List<Long> orderDidList = storeReceiveSendParam.getItems().stream().map(i -> i.getOrderDid()).distinct().collect(Collectors.toList());
        List<DemandOrderDtl> orderDtl = storeReceiveRepoProc.findOrderDtl(orderDidList);
        Map<Long, BigDecimal> priceMap =
                orderDtl.stream().filter(i -> i.getPrice() != null).collect(Collectors.toMap(i -> i.getId(),
                        i -> i.getPrice()));

        StoreReceiveDO thisDo = receiveDOS.get(0);
        thisDo.setStatus("CF");
        thisDo.setTotalRealQty(storeReceiveSendParam.getItems().stream().map(i -> i.getQty()).reduce(BigDecimal.ZERO, BigDecimal::add));
        BigDecimal totalRealAmt = BigDecimal.ZERO;
        for (StoreReceiveConfirmSendParam.OrderItem item : storeReceiveSendParam.getItems()) {
            BigDecimal price = priceMap.get(item.getOrderDid());
            if (price == null) {
                continue;
            }
            totalRealAmt = totalRealAmt.add(item.getQty().multiply(price));
        }
        thisDo.setRealAmt(totalRealAmt);
        if (thisDo.getRtType().equals("R")) {
            thisDo.setReceiveDate(storeReceiveSendParam.getConfirmTime());
        } else {
            thisDo.setRtnDate(storeReceiveSendParam.getConfirmTime());
        }
        storeReceiveRepo.save(thisDo);
        //门店退货单直接返回
        if ("T".equals(thisDo.getRtType())) {
            return;
        }

        //回写收货数量
        log.info("调拨单更新订货单收货数量：{}", JSONUtil.toJsonStr(storeReceiveSendParam.getItems()));
        Map<Long, BigDecimal> orderDidQtyMap = storeReceiveSendParam.getItems().stream()
                .collect(Collectors.groupingBy(StoreReceiveConfirmSendParam.OrderItem::getOrderDid,
                        Collectors.mapping(StoreReceiveConfirmSendParam.OrderItem::getQty,
                                Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
        log.info("调拨单更新收货数量数据：{}", JSONUtil.toJsonStr(orderDidQtyMap));
        for (Map.Entry<Long, BigDecimal> item : orderDidQtyMap.entrySet()) {
            Long did = item.getKey();
            BigDecimal qty = item.getValue();
            scpDemandOrderDDomainService.updateRecvQty(did, qty);
        }
        List<Long> ids = storeReceiveSendParam.getItems().stream().map(StoreReceiveConfirmSendParam.OrderItem::getOrderDid).collect(Collectors.toList());
        List<Long> masIds = scpDemandOrderDDomainService.getMasIdByDId(ids).stream().distinct().collect(Collectors.toList());
        for (Long masId : masIds) {
            scpDemandOrderDomainService.updateDocStatusById(masId, ScpConstant.RECV);
        }
    }
}
